/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.fontbox.cff.CharStringCommand;
import org.apache.fontbox.cff.CharStringHandler;
import org.apache.fontbox.cff.Type1CharString;
import org.apache.fontbox.type1.Type1CharStringReader;

public class Type2CharString
extends Type1CharString {
    private float defWidthX = 0.0f;
    private float nominalWidthX = 0.0f;
    private int pathCount = 0;
    private final List<Object> type2sequence;
    private final int gid;

    public Type2CharString(Type1CharStringReader type1CharStringReader, String string, String string2, int n, List<Object> list, int n2, int n3) {
        super(type1CharStringReader, string, string2);
        this.gid = n;
        this.type2sequence = list;
        this.defWidthX = n2;
        this.nominalWidthX = n3;
        this.convertType1ToType2(list);
    }

    public int getGID() {
        return this.gid;
    }

    public List<Object> getType2Sequence() {
        return this.type2sequence;
    }

    private void convertType1ToType2(List<Object> list) {
        this.type1Sequence = new ArrayList();
        this.pathCount = 0;
        CharStringHandler charStringHandler = new CharStringHandler(){

            @Override
            public List<Number> handleCommand(List<Number> list, CharStringCommand charStringCommand) {
                return Type2CharString.this.handleCommand(list, charStringCommand);
            }
        };
        charStringHandler.handleSequence(list);
    }

    private List<Number> handleCommand(List<Number> list, CharStringCommand charStringCommand) {
        ++this.commandCount;
        String string = CharStringCommand.TYPE2_VOCABULARY.get(charStringCommand.getKey());
        if ("hstem".equals(string)) {
            list = this.clearStack(list, list.size() % 2 != 0);
            this.expandStemHints(list, true);
        } else if ("vstem".equals(string)) {
            list = this.clearStack(list, list.size() % 2 != 0);
            this.expandStemHints(list, false);
        } else if ("vmoveto".equals(string)) {
            list = this.clearStack(list, list.size() > 1);
            this.markPath();
            this.addCommand(list, charStringCommand);
        } else if ("rlineto".equals(string)) {
            this.addCommandList(Type2CharString.split(list, 2), charStringCommand);
        } else if ("hlineto".equals(string)) {
            this.drawAlternatingLine(list, true);
        } else if ("vlineto".equals(string)) {
            this.drawAlternatingLine(list, false);
        } else if ("rrcurveto".equals(string)) {
            this.addCommandList(Type2CharString.split(list, 6), charStringCommand);
        } else if ("endchar".equals(string)) {
            list = this.clearStack(list, list.size() == 5 || list.size() == 1);
            this.closePath();
            if (list.size() == 4) {
                list.add(0, 0);
                this.addCommand(list, new CharStringCommand(12, 6));
            } else {
                this.addCommand(list, charStringCommand);
            }
        } else if ("rmoveto".equals(string)) {
            list = this.clearStack(list, list.size() > 2);
            this.markPath();
            this.addCommand(list, charStringCommand);
        } else if ("hmoveto".equals(string)) {
            list = this.clearStack(list, list.size() > 1);
            this.markPath();
            this.addCommand(list, charStringCommand);
        } else if ("vhcurveto".equals(string)) {
            this.drawAlternatingCurve(list, false);
        } else if ("hvcurveto".equals(string)) {
            this.drawAlternatingCurve(list, true);
        } else if ("hflex".equals(string)) {
            List<Number> list2 = Arrays.asList(list.get(0), 0, list.get(1), list.get(2), list.get(3), 0);
            List<Number> list3 = Arrays.asList(list.get(4), 0, list.get(5), Float.valueOf(-list.get(2).floatValue()), list.get(6), 0);
            this.addCommandList(Arrays.asList(list2, list3), new CharStringCommand(8));
        } else if ("flex".equals(string)) {
            List<Number> list4 = list.subList(0, 6);
            List<Number> list5 = list.subList(6, 12);
            this.addCommandList(Arrays.asList(list4, list5), new CharStringCommand(8));
        } else if ("hflex1".equals(string)) {
            List<Number> list6 = Arrays.asList(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4), 0);
            List<Number> list7 = Arrays.asList(list.get(5), 0, list.get(6), list.get(7), list.get(8), 0);
            this.addCommandList(Arrays.asList(list6, list7), new CharStringCommand(8));
        } else if ("flex1".equals(string)) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < 5; ++i) {
                n += list.get(i * 2).intValue();
                n2 += list.get(i * 2 + 1).intValue();
            }
            List<Number> list8 = list.subList(0, 6);
            List<Number> list9 = Arrays.asList(list.get(6), list.get(7), list.get(8), list.get(9), Math.abs(n) > Math.abs(n2) ? (Number)list.get(10) : (Number)(-n), Math.abs(n) > Math.abs(n2) ? (Number)(-n2) : (Number)list.get(10));
            this.addCommandList(Arrays.asList(list8, list9), new CharStringCommand(8));
        } else if ("hstemhm".equals(string)) {
            list = this.clearStack(list, list.size() % 2 != 0);
            this.expandStemHints(list, true);
        } else if ("hintmask".equals(string) || "cntrmask".equals(string)) {
            if ((list = this.clearStack(list, list.size() % 2 != 0)).size() > 0) {
                this.expandStemHints(list, false);
            }
        } else if ("vstemhm".equals(string)) {
            list = this.clearStack(list, list.size() % 2 != 0);
            this.expandStemHints(list, false);
        } else if ("rcurveline".equals(string)) {
            if (list.size() >= 2) {
                this.addCommandList(Type2CharString.split(list.subList(0, list.size() - 2), 6), new CharStringCommand(8));
                this.addCommand(list.subList(list.size() - 2, list.size()), new CharStringCommand(5));
            }
        } else if ("rlinecurve".equals(string)) {
            if (list.size() >= 6) {
                this.addCommandList(Type2CharString.split(list.subList(0, list.size() - 6), 2), new CharStringCommand(5));
                this.addCommand(list.subList(list.size() - 6, list.size()), new CharStringCommand(8));
            }
        } else if ("vvcurveto".equals(string)) {
            this.drawCurve(list, false);
        } else if ("hhcurveto".equals(string)) {
            this.drawCurve(list, true);
        } else {
            this.addCommand(list, charStringCommand);
        }
        return null;
    }

    private List<Number> clearStack(List<Number> list, boolean bl) {
        if (this.type1Sequence.isEmpty()) {
            if (bl) {
                this.addCommand(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(list.get(0).floatValue() + this.nominalWidthX)), new CharStringCommand(13));
                list = list.subList(1, list.size());
            } else {
                this.addCommand(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(this.defWidthX)), new CharStringCommand(13));
            }
        }
        return list;
    }

    private void expandStemHints(List<Number> list, boolean bl) {
    }

    private void markPath() {
        if (this.pathCount > 0) {
            this.closePath();
        }
        ++this.pathCount;
    }

    private void closePath() {
        CharStringCommand charStringCommand = this.pathCount > 0 ? (CharStringCommand)this.type1Sequence.get(this.type1Sequence.size() - 1) : null;
        CharStringCommand charStringCommand2 = new CharStringCommand(9);
        if (charStringCommand != null && !charStringCommand2.equals(charStringCommand)) {
            this.addCommand(Collections.emptyList(), charStringCommand2);
        }
    }

    private void drawAlternatingLine(List<Number> list, boolean bl) {
        while (list.size() > 0) {
            this.addCommand(list.subList(0, 1), new CharStringCommand(bl ? 6 : 7));
            list = list.subList(1, list.size());
            bl = !bl;
        }
    }

    private void drawAlternatingCurve(List<Number> list, boolean bl) {
        while (list.size() >= 4) {
            boolean bl2;
            boolean bl3 = bl2 = list.size() == 5;
            if (bl) {
                this.addCommand(Arrays.asList(list.get(0), 0, list.get(1), list.get(2), bl2 ? (Number)list.get(4) : (Number)0, list.get(3)), new CharStringCommand(8));
            } else {
                this.addCommand(Arrays.asList(0, list.get(0), list.get(1), list.get(2), list.get(3), bl2 ? (Number)list.get(4) : (Number)0), new CharStringCommand(8));
            }
            list = list.subList(bl2 ? 5 : 4, list.size());
            bl = !bl;
        }
    }

    private void drawCurve(List<Number> list, boolean bl) {
        while (list.size() >= 4) {
            boolean bl2;
            boolean bl3 = bl2 = list.size() % 4 == 1;
            if (bl) {
                this.addCommand(Arrays.asList(list.get(bl2 ? 1 : 0), bl2 ? (Number)list.get(0) : (Number)0, list.get(bl2 ? 2 : 1), list.get(bl2 ? 3 : 2), list.get(bl2 ? 4 : 3), 0), new CharStringCommand(8));
            } else {
                this.addCommand(Arrays.asList(bl2 ? (Number)list.get(0) : (Number)0, list.get(bl2 ? 1 : 0), list.get(bl2 ? 2 : 1), list.get(bl2 ? 3 : 2), 0, list.get(bl2 ? 4 : 3)), new CharStringCommand(8));
            }
            list = list.subList(bl2 ? 5 : 4, list.size());
        }
    }

    private void addCommandList(List<List<Number>> list, CharStringCommand charStringCommand) {
        for (List<Number> list2 : list) {
            this.addCommand(list2, charStringCommand);
        }
    }

    private void addCommand(List<Number> list, CharStringCommand charStringCommand) {
        this.type1Sequence.addAll(list);
        this.type1Sequence.add(charStringCommand);
    }

    private static <E> List<List<E>> split(List<E> list, int n) {
        ArrayList<List<List<E>>> arrayList = new ArrayList<List<List<E>>>();
        for (int i = 0; i < list.size() / n; ++i) {
            arrayList.add(list.subList(i * n, (i + 1) * n));
        }
        return arrayList;
    }
}

