/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.async.ClientContext;
import freenet.crypt.EncryptedRandomAccessBucket;
import freenet.crypt.EncryptedRandomAccessBuffer;
import freenet.crypt.EncryptedRandomAccessBufferType;
import freenet.crypt.MasterSecret;
import freenet.support.Executor;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SizeUtil;
import freenet.support.TimeUtil;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.api.LockableRandomAccessBufferFactory;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.ArrayBucket;
import freenet.support.io.BucketTools;
import freenet.support.io.ByteArrayRandomAccessBuffer;
import freenet.support.io.Closer;
import freenet.support.io.DiskSpaceCheckingRandomAccessBufferFactory;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.InsufficientDiskSpaceException;
import freenet.support.io.PaddedEphemerallyEncryptedBucket;
import freenet.support.io.PaddedRandomAccessBucket;
import freenet.support.io.PaddedRandomAccessBuffer;
import freenet.support.io.PooledFileRandomAccessBufferFactory;
import freenet.support.io.RAFBucket;
import freenet.support.io.ReadOnlyRandomAccessBuffer;
import freenet.support.io.SwitchableProxyRandomAccessBuffer;
import freenet.support.io.TempFileBucket;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class TempBucketFactory
implements BucketFactory,
LockableRandomAccessBufferFactory {
    public static final long defaultIncrement = 4096L;
    public static final float DEFAULT_FACTOR = 1.25f;
    private final FilenameGenerator filenameGenerator;
    private final PooledFileRandomAccessBufferFactory underlyingDiskRAFFactory;
    private final DiskSpaceCheckingRandomAccessBufferFactory diskRAFFactory;
    private volatile long minDiskSpace;
    private long bytesInUse = 0L;
    private final Executor executor;
    private volatile boolean reallyEncrypt;
    private final MasterSecret secret;
    private long maxRAMBucketSize;
    private long maxRamUsed;
    private static final long RAMBUCKET_MAX_AGE = TimeUnit.MINUTES.toMillis(5L);
    static final int RAMBUCKET_CONVERSION_FACTOR = 4;
    static final boolean TRACE_BUCKET_LEAKS = false;
    private static volatile boolean logMINOR;
    static final double MAX_USAGE_LOW = 0.8;
    static final double MAX_USAGE_HIGH = 0.9;
    public static final EncryptedRandomAccessBufferType CRYPT_TYPE;
    boolean runningCleaner = false;
    private final Runnable cleaner = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            TempBucketFactory tempBucketFactory;
            boolean saidSo = false;
            try {
                long now = System.currentTimeMillis();
                while (true) {
                    try {
                        TempBucketFactory.this.cleanBucketQueue(now, false);
                    }
                    catch (InsufficientDiskSpaceException e22) {
                        if (!saidSo) {
                            Logger.error(this, "Insufficient disk space to migrate in-RAM buckets to disk!");
                            System.err.println("Out of disk space!");
                            saidSo = true;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
                saidSo = false;
                while (true) {
                    block27: {
                        TempBucketFactory e22 = TempBucketFactory.this;
                        synchronized (e22) {
                            if ((double)TempBucketFactory.this.bytesInUse <= (double)TempBucketFactory.this.maxRamUsed * 0.8) {
                                // MONITOREXIT @DISABLED, blocks:[0, 22, 25, 13] lbl24 : MonitorExitStatement: MONITOREXIT : e
                                tempBucketFactory = TempBucketFactory.this;
                                break;
                            }
                        }
                        if (TempBucketFactory.this.cleanBucketQueue(System.currentTimeMillis(), true)) break block27;
                        e22 = TempBucketFactory.this;
                        {
                            catch (InsufficientDiskSpaceException e222) {
                                if (!saidSo) {
                                    Logger.error(this, "Insufficient disk space to migrate in-RAM buckets to disk!");
                                    System.err.println("Out of disk space!");
                                    saidSo = true;
                                }
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {}
                                continue;
                            }
                        }
                        synchronized (e22) {
                            TempBucketFactory.this.runningCleaner = false;
                            return;
                        }
                    }
                    continue;
                    break;
                }
            }
            catch (Throwable throwable) {
                TempBucketFactory tempBucketFactory2 = TempBucketFactory.this;
                synchronized (tempBucketFactory2) {
                    TempBucketFactory.this.runningCleaner = false;
                    throw throwable;
                }
            }
            synchronized (tempBucketFactory) {
                TempBucketFactory.this.runningCleaner = false;
                return;
            }
        }
    };
    private final Queue<WeakReference<Migratable>> ramBucketQueue = new LinkedBlockingQueue<WeakReference<Migratable>>();

    public TempBucketFactory(Executor executor, FilenameGenerator filenameGenerator, long maxBucketSizeKeptInRam, long maxRamUsed, Random weakPRNG, boolean reallyEncrypt, long minDiskSpace, MasterSecret masterSecret) {
        this.filenameGenerator = filenameGenerator;
        this.maxRamUsed = maxRamUsed;
        this.maxRAMBucketSize = maxBucketSizeKeptInRam;
        this.reallyEncrypt = reallyEncrypt;
        this.executor = executor;
        this.underlyingDiskRAFFactory = new PooledFileRandomAccessBufferFactory(filenameGenerator, weakPRNG);
        this.underlyingDiskRAFFactory.enableCrypto(reallyEncrypt);
        this.minDiskSpace = minDiskSpace;
        this.diskRAFFactory = new DiskSpaceCheckingRandomAccessBufferFactory(this.underlyingDiskRAFFactory, filenameGenerator.getDir(), minDiskSpace - maxRamUsed);
        this.secret = masterSecret;
    }

    @Override
    public RandomAccessBucket makeBucket(long size) throws IOException {
        return this.makeBucket(size, 1.25f, 4096L);
    }

    public RandomAccessBucket makeBucket(long size, float factor) throws IOException {
        return this.makeBucket(size, factor, 4096L);
    }

    private synchronized void _hasTaken(long size) {
        this.bytesInUse += size;
    }

    private synchronized void _hasFreed(long size) {
        this.bytesInUse -= size;
    }

    public synchronized long getRamUsed() {
        return this.bytesInUse;
    }

    public synchronized void setMaxRamUsed(long size) {
        this.maxRamUsed = size;
    }

    public synchronized long getMaxRamUsed() {
        return this.maxRamUsed;
    }

    public synchronized void setMaxRAMBucketSize(long size) {
        this.maxRAMBucketSize = size;
        this.diskRAFFactory.setMinDiskSpace(this.minDiskSpace - this.maxRamUsed);
    }

    public synchronized long getMaxRAMBucketSize() {
        return this.maxRAMBucketSize;
    }

    public void setEncryption(boolean value) {
        this.reallyEncrypt = value;
        this.underlyingDiskRAFFactory.enableCrypto(value);
    }

    public synchronized void setMinDiskSpace(long min) {
        this.minDiskSpace = min;
        this.diskRAFFactory.setMinDiskSpace(this.minDiskSpace - this.maxRamUsed);
    }

    public boolean isEncrypting() {
        return this.reallyEncrypt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TempBucket makeBucket(long size, float factor, long increment) throws IOException {
        RandomAccessBucket realBucket = null;
        boolean useRAMBucket = false;
        long now = System.currentTimeMillis();
        TempBucketFactory tempBucketFactory = this;
        synchronized (tempBucketFactory) {
            if (size > 0L && size <= this.maxRAMBucketSize && this.bytesInUse < this.maxRamUsed && this.bytesInUse + size <= this.maxRamUsed) {
                useRAMBucket = true;
            }
            if ((double)this.bytesInUse >= (double)this.maxRamUsed * 0.9 && !this.runningCleaner) {
                this.runningCleaner = true;
                this.executor.execute(this.cleaner);
            }
        }
        realBucket = useRAMBucket ? new ArrayBucket() : this._makeFileBucket();
        TempBucket toReturn = new TempBucket(now, realBucket);
        if (useRAMBucket) {
            Queue<WeakReference<Migratable>> queue = this.ramBucketQueue;
            synchronized (queue) {
                this.ramBucketQueue.add(toReturn.getReference());
            }
        } else if (size != -1L && size != Long.MAX_VALUE && this.filenameGenerator.getDir().getUsableSpace() + size < this.minDiskSpace) {
            throw new InsufficientDiskSpaceException();
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanBucketQueue(long now, boolean force) throws InsufficientDiskSpaceException {
        boolean shouldContinue = true;
        LinkedList<Migratable> toMigrate = null;
        if (logMINOR) {
            Logger.minor(this, "Starting cleanBucketQueue");
        }
        do {
            Queue<WeakReference<Migratable>> queue = this.ramBucketQueue;
            synchronized (queue) {
                WeakReference<Migratable> tmpBucketRef = this.ramBucketQueue.peek();
                if (tmpBucketRef == null) {
                    shouldContinue = false;
                } else {
                    Migratable tmpBucket = (Migratable)tmpBucketRef.get();
                    if (tmpBucket == null) {
                        this.ramBucketQueue.remove(tmpBucketRef);
                        continue;
                    }
                    if (tmpBucket.creationTime() + RAMBUCKET_MAX_AGE > now && !force) {
                        shouldContinue = false;
                    } else {
                        if (logMINOR) {
                            Logger.minor(this, "The bucket " + tmpBucket + " is " + TimeUtil.formatTime(now - tmpBucket.creationTime()) + " old: we will force-migrate it to disk.");
                        }
                        this.ramBucketQueue.remove(tmpBucketRef);
                        if (toMigrate == null) {
                            toMigrate = new LinkedList<Migratable>();
                        }
                        toMigrate.add(tmpBucket);
                        force = false;
                    }
                }
            }
        } while (shouldContinue);
        if (toMigrate == null) {
            return false;
        }
        if (toMigrate.size() > 0) {
            if (logMINOR) {
                Logger.minor(this, "We are going to migrate " + toMigrate.size() + " RAMBuckets");
            }
            for (Migratable tmpBucket : toMigrate) {
                try {
                    tmpBucket.migrateToDisk();
                }
                catch (InsufficientDiskSpaceException e) {
                    throw e;
                }
                catch (IOException e) {
                    Logger.error(tmpBucket, "An IOE occured while migrating long-lived buckets:" + e.getMessage(), (Throwable)e);
                }
            }
            return true;
        }
        return false;
    }

    private RandomAccessBucket _makeFileBucket() throws IOException {
        RandomAccessBucket ret = new TempFileBucket(this.filenameGenerator.makeRandomFilename(), this.filenameGenerator, true);
        if (this.reallyEncrypt) {
            ret = new PaddedRandomAccessBucket(ret);
            ret = new EncryptedRandomAccessBucket(CRYPT_TYPE, ret, this.secret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockableRandomAccessBuffer makeRAF(long size) throws IOException {
        if (size < 0L) {
            throw new IllegalArgumentException();
        }
        if (size > Integer.MAX_VALUE) {
            return this.diskRAFFactory.makeRAF(size);
        }
        long now = System.currentTimeMillis();
        TempRandomAccessBuffer raf = null;
        Object object = this;
        synchronized (object) {
            if (size > 0L && size <= this.maxRAMBucketSize && this.bytesInUse < this.maxRamUsed && this.bytesInUse + size <= this.maxRamUsed) {
                raf = new TempRandomAccessBuffer((int)size, now);
                this.bytesInUse += size;
            }
            if ((double)this.bytesInUse >= (double)this.maxRamUsed * 0.9 && !this.runningCleaner) {
                this.runningCleaner = true;
                this.executor.execute(this.cleaner);
            }
        }
        if (raf != null) {
            object = this.ramBucketQueue;
            synchronized (object) {
                this.ramBucketQueue.add(raf.getReference());
            }
            return raf;
        }
        boolean encrypt = this.reallyEncrypt;
        long realSize = size;
        long paddedSize = size;
        if (encrypt) {
            paddedSize = PaddedEphemerallyEncryptedBucket.paddedLength(realSize += (long)TempBucketFactory.CRYPT_TYPE.headerLen, 1024L);
        }
        LockableRandomAccessBuffer ret = this.diskRAFFactory.makeRAF(paddedSize);
        if (encrypt) {
            if (realSize != paddedSize) {
                ret = new PaddedRandomAccessBuffer(ret, realSize);
            }
            try {
                ret = new EncryptedRandomAccessBuffer(CRYPT_TYPE, ret, this.secret, true);
            }
            catch (GeneralSecurityException e) {
                Logger.error(this, "Cannot create encrypted tempfile: " + e, (Throwable)e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockableRandomAccessBuffer makeRAF(byte[] initialContents, int offset, int size, boolean readOnly) throws IOException {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        long now = System.currentTimeMillis();
        TempRandomAccessBuffer raf = null;
        Object object = this;
        synchronized (object) {
            if (size > 0 && (long)size <= this.maxRAMBucketSize && this.bytesInUse < this.maxRamUsed && this.bytesInUse + (long)size <= this.maxRamUsed) {
                raf = new TempRandomAccessBuffer(initialContents, offset, size, now, readOnly);
                this.bytesInUse += (long)size;
            }
            if ((double)this.bytesInUse >= (double)this.maxRamUsed * 0.9 && !this.runningCleaner) {
                this.runningCleaner = true;
                this.executor.execute(this.cleaner);
            }
        }
        if (raf != null) {
            object = this.ramBucketQueue;
            synchronized (object) {
                this.ramBucketQueue.add(raf.getReference());
            }
            return raf;
        }
        if (this.reallyEncrypt) {
            LockableRandomAccessBuffer ret = this.makeRAF(size);
            ret.pwrite(0L, initialContents, offset, size);
            if (readOnly) {
                ret = new ReadOnlyRandomAccessBuffer(ret);
            }
            return ret;
        }
        return this.diskRAFFactory.makeRAF(initialContents, offset, size, readOnly);
    }

    public DiskSpaceCheckingRandomAccessBufferFactory getUnderlyingRAFFactory() {
        return this.diskRAFFactory;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        CRYPT_TYPE = EncryptedRandomAccessBufferType.ChaCha128;
    }

    class TempRandomAccessBuffer
    extends SwitchableProxyRandomAccessBuffer
    implements Migratable {
        protected boolean hasMigrated;
        private boolean hasFreedRAM;
        private final long creationTime;
        private final TempBucket original;
        private final Throwable tracer;
        private WeakReference<Migratable> weakRef;

        TempRandomAccessBuffer(int size, long time) throws IOException {
            super(new ByteArrayRandomAccessBuffer(size), size);
            this.hasMigrated = false;
            this.hasFreedRAM = false;
            this.weakRef = new WeakReference<TempRandomAccessBuffer>(this);
            this.creationTime = time;
            this.hasMigrated = false;
            this.original = null;
            this.tracer = null;
        }

        public TempRandomAccessBuffer(byte[] initialContents, int offset, int size, long time, boolean readOnly) throws IOException {
            super(new ByteArrayRandomAccessBuffer(initialContents, offset, size, readOnly), size);
            this.hasMigrated = false;
            this.hasFreedRAM = false;
            this.weakRef = new WeakReference<TempRandomAccessBuffer>(this);
            this.creationTime = time;
            this.hasMigrated = false;
            this.original = null;
            this.tracer = null;
        }

        public TempRandomAccessBuffer(LockableRandomAccessBuffer underlying, long creationTime, boolean migrated, TempBucket tempBucket) throws IOException {
            super(underlying, underlying.size());
            this.hasMigrated = false;
            this.hasFreedRAM = false;
            this.weakRef = new WeakReference<TempRandomAccessBuffer>(this);
            this.creationTime = creationTime;
            this.hasMigrated = this.hasFreedRAM = migrated;
            this.original = tempBucket;
            this.tracer = null;
        }

        @Override
        protected LockableRandomAccessBuffer innerMigrate(LockableRandomAccessBuffer underlying) throws IOException {
            ByteArrayRandomAccessBuffer b = (ByteArrayRandomAccessBuffer)underlying;
            byte[] buf = b.getBuffer();
            return TempBucketFactory.this.diskRAFFactory.makeRAF(buf, 0, (int)this.size, b.isReadOnly());
        }

        @Override
        public void free() {
            if (!super.innerFree()) {
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Freed " + this, (Throwable)new Exception("debug"));
            }
            if (this.original != null) {
                this.original.onFreed();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void afterFreeUnderlying() {
            Object object = this;
            synchronized (object) {
                if (this.hasFreedRAM) {
                    return;
                }
                this.hasFreedRAM = true;
            }
            TempBucketFactory.this._hasFreed(this.size);
            object = TempBucketFactory.this.ramBucketQueue;
            synchronized (object) {
                TempBucketFactory.this.ramBucketQueue.remove(this.getReference());
            }
        }

        public WeakReference<Migratable> getReference() {
            return this.weakRef;
        }

        @Override
        public long creationTime() {
            return this.creationTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean migrateToDisk() throws IOException {
            TempRandomAccessBuffer tempRandomAccessBuffer = this;
            synchronized (tempRandomAccessBuffer) {
                if (this.hasMigrated) {
                    return false;
                }
                this.hasMigrated = true;
            }
            this.migrate();
            return true;
        }

        public synchronized boolean hasMigrated() {
            return this.hasMigrated;
        }

        @Override
        public void onResume(ClientContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void storeTo(DataOutputStream dos) throws IOException {
            throw new UnsupportedOperationException();
        }

        protected void finalize() throws Throwable {
            if (this.original != null) {
                return;
            }
            if (!this.hasBeenFreed()) {
                Logger.error(this, "TempRandomAccessBuffer not freed, size=" + this.size() + " : " + this);
                this.free();
            }
            super.finalize();
        }
    }

    public class TempBucket
    implements Bucket,
    Migratable,
    RandomAccessBucket {
        private RandomAccessBucket currentBucket;
        private long currentSize;
        private boolean hasWritten;
        private OutputStream os = null;
        private final ArrayList<TempBucketInputStream> tbis;
        private short osIndex;
        public final long creationTime;
        private boolean hasBeenFreed = false;
        private final Throwable tracer;
        private WeakReference<Migratable> weakRef = new WeakReference<TempBucket>(this);

        public TempBucket(long now, RandomAccessBucket cur) {
            if (cur == null) {
                throw new NullPointerException();
            }
            this.tracer = null;
            this.currentBucket = cur;
            this.creationTime = now;
            this.osIndex = 0;
            this.tbis = new ArrayList(1);
            if (logMINOR) {
                Logger.minor(TempBucket.class, "Created " + this, (Throwable)new Exception("debug"));
            }
        }

        private synchronized void closeInputStreams(boolean forFree) {
            ListIterator<TempBucketInputStream> i = this.tbis.listIterator();
            while (i.hasNext()) {
                TempBucketInputStream is = i.next();
                if (forFree) {
                    i.remove();
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        Logger.error(this, "Caught " + e + " closing " + is);
                    }
                    continue;
                }
                try {
                    is._maybeResetInputStream();
                }
                catch (IOException e) {
                    i.remove();
                    Closer.close(is);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean migrateToDisk() throws IOException {
            long size;
            RandomAccessBucket toMigrate = null;
            Object object = this;
            synchronized (object) {
                if (!this.isRAMBucket() || this.hasBeenFreed) {
                    return false;
                }
                toMigrate = this.currentBucket;
                RandomAccessBucket tempFB = TempBucketFactory.this._makeFileBucket();
                size = this.currentSize;
                if (this.os != null) {
                    this.os.flush();
                    this.os.close();
                    this.os = tempFB.getOutputStreamUnbuffered();
                    if (size > 0L) {
                        BucketTools.copyTo(toMigrate, this.os, size);
                    }
                } else if (size > 0L) {
                    try (OutputStream temp = tempFB.getOutputStreamUnbuffered();){
                        BucketTools.copyTo(toMigrate, temp, size);
                    }
                }
                if (toMigrate.isReadOnly()) {
                    tempFB.setReadOnly();
                }
                this.closeInputStreams(false);
                this.currentBucket = tempFB;
            }
            if (logMINOR) {
                Logger.minor(this, "We have migrated " + toMigrate.hashCode());
            }
            object = TempBucketFactory.this.ramBucketQueue;
            synchronized (object) {
                TempBucketFactory.this.ramBucketQueue.remove(this.getReference());
            }
            toMigrate.free();
            TempBucketFactory.this._hasFreed(size);
            return true;
        }

        public final synchronized boolean isRAMBucket() {
            return this.currentBucket instanceof ArrayBucket;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return new BufferedOutputStream(this.getOutputStreamUnbuffered());
        }

        @Override
        public synchronized OutputStream getOutputStreamUnbuffered() throws IOException {
            if (this.os != null) {
                throw new IOException("Only one OutputStream per bucket on " + this + " !");
            }
            if (this.hasBeenFreed) {
                throw new IOException("Already freed");
            }
            this.hasWritten = true;
            this.osIndex = (short)(this.osIndex + 1);
            TempBucketOutputStream tos = new TempBucketOutputStream(this.osIndex);
            if (logMINOR) {
                Logger.minor(this, "Got " + tos + " for " + this, (Throwable)new Exception());
            }
            return tos;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(this.getInputStreamUnbuffered());
        }

        @Override
        public synchronized InputStream getInputStreamUnbuffered() throws IOException {
            if (!this.hasWritten) {
                throw new IOException("No OutputStream has been openned! Why would you want an InputStream then?");
            }
            if (this.hasBeenFreed) {
                throw new IOException("Already freed");
            }
            TempBucketInputStream is = new TempBucketInputStream(this.osIndex);
            this.tbis.add(is);
            if (logMINOR) {
                Logger.minor(this, "Got " + is + " for " + this, (Throwable)new Exception());
            }
            return is;
        }

        @Override
        public synchronized String getName() {
            return this.currentBucket.getName();
        }

        @Override
        public synchronized long size() {
            return this.currentSize;
        }

        @Override
        public synchronized boolean isReadOnly() {
            return this.currentBucket.isReadOnly();
        }

        @Override
        public synchronized void setReadOnly() {
            this.currentBucket.setReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void free() {
            RandomAccessBucket cur;
            TempBucket tempBucket = this;
            synchronized (tempBucket) {
                if (this.hasBeenFreed) {
                    return;
                }
                this.hasBeenFreed = true;
                Closer.close(this.os);
                this.closeInputStreams(true);
                if (this.isRAMBucket()) {
                    this.currentBucket.free();
                    TempBucketFactory.this._hasFreed(this.currentSize);
                    Queue queue = TempBucketFactory.this.ramBucketQueue;
                    synchronized (queue) {
                        TempBucketFactory.this.ramBucketQueue.remove(this.getReference());
                    }
                    return;
                }
                cur = this.currentBucket;
            }
            cur.free();
        }

        private synchronized void onFreed() {
            this.hasBeenFreed = true;
        }

        @Override
        public RandomAccessBucket createShadow() {
            return this.currentBucket.createShadow();
        }

        public WeakReference<Migratable> getReference() {
            return this.weakRef;
        }

        protected void finalize() throws Throwable {
            if (!this.hasBeenFreed) {
                Logger.error(this, "TempBucket not freed, size=" + this.size() + ", isRAMBucket=" + this.isRAMBucket() + " : " + this);
                this.free();
            }
            super.finalize();
        }

        @Override
        public long creationTime() {
            return this.creationTime;
        }

        @Override
        public void onResume(ClientContext context) {
            throw new IllegalStateException();
        }

        @Override
        public void storeTo(DataOutputStream dos) throws IOException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LockableRandomAccessBuffer toRandomAccessBuffer() throws IOException {
            TempBucket tempBucket = this;
            synchronized (tempBucket) {
                if (this.hasBeenFreed) {
                    throw new IOException("Already freed");
                }
                if (this.os != null) {
                    throw new IOException("Can't migrate with open OutputStream's");
                }
                if (!this.tbis.isEmpty()) {
                    throw new IOException("Can't migrate with open InputStream's");
                }
                this.setReadOnly();
                TempRandomAccessBuffer raf = new TempRandomAccessBuffer(this.currentBucket.toRandomAccessBuffer(), this.creationTime, !this.isRAMBucket(), this);
                if (this.isRAMBucket()) {
                    Queue queue = TempBucketFactory.this.ramBucketQueue;
                    synchronized (queue) {
                        TempBucketFactory.this.ramBucketQueue.remove(this.getReference());
                        TempBucketFactory.this.ramBucketQueue.add(raf.getReference());
                    }
                }
                this.currentBucket = new RAFBucket(raf);
                return raf;
            }
        }

        synchronized Bucket getUnderlying() {
            return this.currentBucket;
        }

        private class TempBucketInputStream
        extends InputStream {
            private InputStream currentIS;
            private long index = 0L;
            private final short idx;

            TempBucketInputStream(short idx) throws IOException {
                this.idx = idx;
                this.currentIS = TempBucket.this.currentBucket.getInputStreamUnbuffered();
            }

            public void _maybeResetInputStream() throws IOException {
                if (this.idx != TempBucket.this.osIndex) {
                    this.close();
                } else {
                    Closer.close(this.currentIS);
                    this.currentIS = TempBucket.this.currentBucket.getInputStreamUnbuffered();
                    for (long toSkip = this.index; toSkip > 0L; toSkip -= this.currentIS.skip(toSkip)) {
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final int read() throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    if (TempBucket.this.hasBeenFreed) {
                        throw new IOException("Already freed");
                    }
                    int toReturn = this.currentIS.read();
                    if (toReturn != -1) {
                        ++this.index;
                    }
                    return toReturn;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read(byte[] b) throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    if (TempBucket.this.hasBeenFreed) {
                        throw new IOException("Already freed");
                    }
                    return this.read(b, 0, b.length);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    if (TempBucket.this.hasBeenFreed) {
                        throw new IOException("Already freed");
                    }
                    int toReturn = this.currentIS.read(b, off, len);
                    if (toReturn > 0) {
                        this.index += (long)toReturn;
                    }
                    return toReturn;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long skip(long n) throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    if (TempBucket.this.hasBeenFreed) {
                        throw new IOException("Already freed");
                    }
                    long skipped = this.currentIS.skip(n);
                    this.index += skipped;
                    return skipped;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int available() throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    if (TempBucket.this.hasBeenFreed) {
                        throw new IOException("Already freed");
                    }
                    return this.currentIS.available();
                }
            }

            @Override
            public boolean markSupported() {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void close() throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    Closer.close(this.currentIS);
                    TempBucket.this.tbis.remove(this);
                }
            }
        }

        private class TempBucketOutputStream
        extends OutputStream {
            long lastCheckedSize = 0L;
            long CHECK_DISK_EVERY = 4096L;
            boolean closed = false;

            TempBucketOutputStream(short idx) throws IOException {
                if (TempBucket.this.os == null) {
                    TempBucket.this.os = TempBucket.this.currentBucket.getOutputStreamUnbuffered();
                }
            }

            private void _maybeMigrateRamBucket(long futureSize) throws IOException {
                if (this.closed) {
                    return;
                }
                if (TempBucket.this.isRAMBucket()) {
                    boolean shouldMigrate = false;
                    boolean isOversized = false;
                    if (futureSize >= Math.min(Integer.MAX_VALUE, TempBucketFactory.this.maxRAMBucketSize * 4L)) {
                        isOversized = true;
                        shouldMigrate = true;
                    } else if (futureSize - TempBucket.this.currentSize + TempBucketFactory.this.bytesInUse >= TempBucketFactory.this.maxRamUsed) {
                        shouldMigrate = true;
                    }
                    if (shouldMigrate) {
                        if (logMINOR) {
                            if (isOversized) {
                                Logger.minor(this, "The bucket " + TempBucket.this + " is over " + SizeUtil.formatSize(TempBucketFactory.this.maxRAMBucketSize * 4L) + ": we will force-migrate it to disk.");
                            } else {
                                Logger.minor(this, "The bucketpool is full: force-migrate before we go over the limit");
                            }
                        }
                        TempBucket.this.migrateToDisk();
                    }
                } else if (futureSize - this.lastCheckedSize >= this.CHECK_DISK_EVERY) {
                    if (TempBucketFactory.this.filenameGenerator.getDir().getUsableSpace() + (futureSize - TempBucket.this.currentSize) < TempBucketFactory.this.minDiskSpace) {
                        throw new InsufficientDiskSpaceException();
                    }
                    this.lastCheckedSize = futureSize;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void write(int b) throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    if (TempBucket.this.hasBeenFreed) {
                        throw new IOException("Already freed");
                    }
                    long futureSize = TempBucket.this.currentSize + 1L;
                    this._maybeMigrateRamBucket(futureSize);
                    TempBucket.this.os.write(b);
                    TempBucket.this.currentSize = futureSize;
                    if (TempBucket.this.isRAMBucket()) {
                        TempBucketFactory.this._hasTaken(1L);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void write(byte[] b, int off, int len) throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    if (TempBucket.this.hasBeenFreed) {
                        throw new IOException("Already freed");
                    }
                    long futureSize = TempBucket.this.currentSize + (long)len;
                    this._maybeMigrateRamBucket(futureSize);
                    TempBucket.this.os.write(b, off, len);
                    TempBucket.this.currentSize = futureSize;
                    if (TempBucket.this.isRAMBucket()) {
                        TempBucketFactory.this._hasTaken(len);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void flush() throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    if (TempBucket.this.hasBeenFreed) {
                        return;
                    }
                    this._maybeMigrateRamBucket(TempBucket.this.currentSize);
                    if (!this.closed) {
                        TempBucket.this.os.flush();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void close() throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    if (this.closed) {
                        return;
                    }
                    this._maybeMigrateRamBucket(TempBucket.this.currentSize);
                    TempBucket.this.os.flush();
                    TempBucket.this.os.close();
                    TempBucket.this.os = null;
                    this.closed = true;
                }
            }
        }
    }

    private static interface Migratable {
        public long creationTime();

        public boolean migrateToDisk() throws IOException;
    }
}

