/*
 * Decompiled with CFR 0.152.
 */
package freenet.tools;

import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.SimpleFieldSet;
import freenet.support.io.Closer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;

public class CleanupTranslations {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, LoggerHook.InvalidThresholdException {
        File[] translations;
        Logger.setupStdoutLogging(Logger.LogLevel.ERROR, "");
        File engFile = new File("src/freenet/l10n/freenet.l10n.en.properties");
        SimpleFieldSet english = SimpleFieldSet.readFrom(engFile, false, true);
        for (File f : translations = new File("src/freenet/l10n").listFiles()) {
            String name = f.getName();
            if (!name.startsWith("freenet.l10n.") || name.equals("freenet.1l0n.en.properties")) continue;
            FileInputStream fis = new FileInputStream(f);
            InputStreamReader isr = new InputStreamReader((InputStream)new BufferedInputStream(fis), "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            StringWriter sw = new StringWriter();
            boolean changed = false;
            while (true) {
                int idx;
                String line;
                if ((line = br.readLine()) == null) {
                    System.err.println("File does not end in End: " + f);
                    System.exit(4);
                }
                if ((idx = line.indexOf(61)) == -1) {
                    if (!line.equals("End")) {
                        System.err.println("Line with no equals (file does not end in End???): " + f + " - \"" + line + "\"");
                        System.exit(1);
                    }
                    sw.append(line + "\n");
                    line = br.readLine();
                    if (line == null) break;
                    System.err.println("Content after End: \"" + line + "\"");
                    System.exit(2);
                    break;
                }
                String before = line.substring(0, idx);
                String s = english.get(before);
                if (s == null) {
                    System.err.println("Orphaned string: \"" + before + "\" in " + f);
                    changed = true;
                    continue;
                }
                sw.append(line + "\n");
            }
            Closer.close(fis);
            Closer.close(isr);
            Closer.close(br);
            if (!changed) continue;
            FileOutputStream fos = new FileOutputStream(f);
            try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");){
                osw.write(sw.toString());
            }
            System.out.println("Rewritten " + f);
        }
    }
}

