/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.DTrace;
import com.db4o.ext.Db4oIOException;

public abstract class IoAdapter {
    private static final int COPY_SIZE = 4096;
    private int _blockSize;

    protected final long regularAddress(int blockAddress, int blockAddressOffset) {
        if (0 == this._blockSize) {
            throw new IllegalStateException();
        }
        return (long)blockAddress * (long)this._blockSize + (long)blockAddressOffset;
    }

    public void blockCopy(int oldAddress, int oldAddressOffset, int newAddress, int newAddressOffset, int length) throws Db4oIOException {
        this.copy(this.regularAddress(oldAddress, oldAddressOffset), this.regularAddress(newAddress, newAddressOffset), length);
    }

    public void blockSeek(int address) throws Db4oIOException {
        this.blockSeek(address, 0);
    }

    public void blockSeek(int address, int offset) throws Db4oIOException {
        this.seek(this.regularAddress(address, offset));
    }

    public void blockSize(int blockSize) {
        if (blockSize < 1) {
            throw new IllegalArgumentException();
        }
        this._blockSize = blockSize;
    }

    public abstract void close() throws Db4oIOException;

    public void copy(long oldAddress, long newAddress, int length) throws Db4oIOException {
        if (DTrace.enabled) {
            DTrace.IO_COPY.logLength(newAddress, length);
        }
        if (length > 4096) {
            byte[] buffer = new byte[4096];
            int pos = 0;
            while (pos + 4096 < length) {
                this.copy(buffer, oldAddress + (long)pos, newAddress + (long)pos);
                pos += 4096;
            }
            oldAddress += (long)pos;
            newAddress += (long)pos;
            length -= pos;
        }
        this.copy(new byte[length], oldAddress, newAddress);
    }

    private void copy(byte[] buffer, long oldAddress, long newAddress) throws Db4oIOException {
        this.seek(oldAddress);
        this.read(buffer);
        this.seek(newAddress);
        this.write(buffer);
    }

    public abstract void delete(String var1);

    public abstract boolean exists(String var1);

    public abstract long getLength() throws Db4oIOException;

    public abstract IoAdapter open(String var1, boolean var2, long var3, boolean var5) throws Db4oIOException;

    public int read(byte[] buffer) throws Db4oIOException {
        return this.read(buffer, buffer.length);
    }

    public abstract int read(byte[] var1, int var2) throws Db4oIOException;

    public abstract void seek(long var1) throws Db4oIOException;

    public abstract void sync() throws Db4oIOException;

    public void write(byte[] bytes) throws Db4oIOException {
        this.write(bytes, bytes.length);
    }

    public abstract void write(byte[] var1, int var2) throws Db4oIOException;

    public int blockSize() {
        return this._blockSize;
    }

    public IoAdapter delegatedIoAdapter() {
        return this;
    }
}

