/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.utilities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.spaceroots.mantissa.utilities.Interval;

public class IntervalsList {
    private List intervals;

    public IntervalsList() {
        this.intervals = new ArrayList();
    }

    public IntervalsList(double a, double b) {
        this.intervals = new ArrayList();
        this.intervals.add(new Interval(a, b));
    }

    public IntervalsList(Interval i) {
        this.intervals = new ArrayList();
        this.intervals.add(i);
    }

    public IntervalsList(Interval i1, Interval i2) {
        this.intervals = new ArrayList();
        if (i1.intersects(i2)) {
            this.intervals.add(new Interval(Math.min(i1.getInf(), i2.getInf()), Math.max(i1.getSup(), i2.getSup())));
        } else if (i1.getSup() < i2.getInf()) {
            this.intervals.add(i1);
            this.intervals.add(i2);
        } else {
            this.intervals.add(i2);
            this.intervals.add(i1);
        }
    }

    public IntervalsList(IntervalsList list) {
        this.intervals = new ArrayList(list.intervals.size());
        Iterator iterator = list.intervals.iterator();
        while (iterator.hasNext()) {
            this.intervals.add(new Interval((Interval)iterator.next()));
        }
    }

    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public boolean isConnex() {
        return this.intervals.size() == 1;
    }

    public double getInf() {
        return this.intervals.isEmpty() ? Double.NaN : ((Interval)this.intervals.get(0)).getInf();
    }

    public double getSup() {
        return this.intervals.isEmpty() ? Double.NaN : ((Interval)this.intervals.get(this.intervals.size() - 1)).getSup();
    }

    public int getSize() {
        return this.intervals.size();
    }

    public Interval getInterval(int i) {
        return (Interval)this.intervals.get(i);
    }

    public List getIntervals() {
        return this.intervals;
    }

    public boolean contains(double x) {
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            if (!((Interval)iterator.next()).contains(x)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Interval i) {
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            if (!((Interval)iterator.next()).contains(i)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(Interval i) {
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            if (!((Interval)iterator.next()).intersects(i)) continue;
            return true;
        }
        return false;
    }

    public void addToSelf(Interval i) {
        ArrayList<Interval> newIntervals = new ArrayList<Interval>();
        double inf = Double.NaN;
        double sup = Double.NaN;
        boolean pending = false;
        boolean processed = false;
        for (Interval local : this.intervals) {
            if (local.getSup() < i.getInf()) {
                newIntervals.add(local);
                continue;
            }
            if (local.getInf() < i.getSup()) {
                if (!pending) {
                    inf = Math.min(local.getInf(), i.getInf());
                    pending = true;
                    processed = true;
                }
                sup = Math.max(local.getSup(), i.getSup());
                continue;
            }
            if (pending) {
                newIntervals.add(new Interval(inf, sup));
                pending = false;
            } else if (!processed) {
                newIntervals.add(i);
            }
            processed = true;
            newIntervals.add(local);
        }
        if (pending) {
            newIntervals.add(new Interval(inf, sup));
        } else if (!processed) {
            newIntervals.add(i);
        }
        this.intervals = newIntervals;
    }

    public static IntervalsList add(IntervalsList list, Interval i) {
        IntervalsList copy = new IntervalsList(list);
        copy.addToSelf(i);
        return copy;
    }

    public void subtractFromSelf(Interval i) {
        double a = Math.min(this.getInf(), i.getInf());
        double b = Math.max(this.getSup(), i.getSup());
        this.intersectSelf(new IntervalsList(new Interval(a - 1.0, i.getInf()), new Interval(i.getSup(), b + 1.0)));
    }

    public static IntervalsList subtract(IntervalsList list, Interval i) {
        IntervalsList copy = new IntervalsList(list);
        copy.subtractFromSelf(i);
        return copy;
    }

    public void intersectSelf(Interval i) {
        ArrayList<Interval> newIntervals = new ArrayList<Interval>();
        for (Interval local : this.intervals) {
            if (!local.intersects(i)) continue;
            newIntervals.add(Interval.intersection(local, i));
        }
        this.intervals = newIntervals;
    }

    public static IntervalsList intersection(IntervalsList list, Interval i) {
        IntervalsList copy = new IntervalsList(list);
        copy.intersectSelf(i);
        return copy;
    }

    public void addToSelf(IntervalsList list) {
        Iterator iterator = list.intervals.iterator();
        while (iterator.hasNext()) {
            this.addToSelf((Interval)iterator.next());
        }
    }

    public static IntervalsList add(IntervalsList list1, IntervalsList list2) {
        IntervalsList copy = new IntervalsList(list1);
        copy.addToSelf(list2);
        return copy;
    }

    public void subtractFromSelf(IntervalsList list) {
        Iterator iterator = list.intervals.iterator();
        while (iterator.hasNext()) {
            this.subtractFromSelf((Interval)iterator.next());
        }
    }

    public static IntervalsList subtract(IntervalsList list1, IntervalsList list2) {
        IntervalsList copy = new IntervalsList(list1);
        copy.subtractFromSelf(list2);
        return copy;
    }

    public void intersectSelf(IntervalsList list) {
        this.intervals = IntervalsList.intersection((IntervalsList)this, (IntervalsList)list).intervals;
    }

    public static IntervalsList intersection(IntervalsList list1, IntervalsList list2) {
        IntervalsList list = new IntervalsList();
        Iterator iterator = list2.intervals.iterator();
        while (iterator.hasNext()) {
            list.addToSelf(IntervalsList.intersection(list1, (Interval)iterator.next()));
        }
        return list;
    }
}

