/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.InsertException;
import freenet.clients.fcp.ClientPut;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.UploadRequestStatus;
import freenet.keys.FreenetURI;
import java.io.File;
import java.util.Date;

public class UploadFileRequestStatus
extends UploadRequestStatus {
    private final long dataSize;
    private final String mimeType;
    private final File origFilename;
    private ClientPut.COMPRESS_STATE compressing;

    UploadFileRequestStatus(String identifier, ClientRequest.Persistence persistence, boolean started, boolean finished, boolean success, int total, int min, int fetched, Date latestSuccess, int fatal, int failed, Date latestFailure, boolean totalFinalized, short prio, FreenetURI finalURI, FreenetURI targetURI, InsertException.InsertExceptionMode failureCode, String failureReasonShort, String failureReasonLong, long dataSize, String mimeType, File origFilename, ClientPut.COMPRESS_STATE compressing) {
        super(identifier, persistence, started, finished, success, total, min, fetched, latestSuccess, fatal, failed, latestFailure, totalFinalized, prio, finalURI, targetURI, failureCode, failureReasonShort, failureReasonLong);
        this.dataSize = dataSize;
        this.mimeType = mimeType;
        this.origFilename = origFilename;
        this.compressing = compressing;
    }

    @Override
    public long getDataSize() {
        return this.dataSize;
    }

    public String getMIMEType() {
        return this.mimeType;
    }

    public File getOrigFilename() {
        return this.origFilename;
    }

    public ClientPut.COMPRESS_STATE isCompressing() {
        return this.compressing;
    }

    synchronized void updateCompressionStatus(ClientPut.COMPRESS_STATE status) {
        this.compressing = status;
    }

    @Override
    public String getPreferredFilename() {
        String s = super.getPreferredFilename();
        if (s == null && this.origFilename != null) {
            return this.origFilename.getName();
        }
        return s;
    }
}

