/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.client.async.ClientContext;
import freenet.crypt.CryptByteBuffer;
import freenet.crypt.EncryptedRandomAccessBuffer;
import freenet.crypt.EncryptedRandomAccessBufferType;
import freenet.crypt.KeyGenUtils;
import freenet.crypt.MasterSecret;
import freenet.crypt.MessageAuthCode;
import freenet.support.Fields;
import freenet.support.Logger;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.BucketTools;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.NullInputStream;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class EncryptedRandomAccessBucket
implements RandomAccessBucket,
Serializable {
    private static final long serialVersionUID = 1L;
    private final EncryptedRandomAccessBufferType type;
    private final RandomAccessBucket underlying;
    private transient ParametersWithIV cipherParams;
    private transient SecretKey headerMacKey;
    private volatile transient boolean isFreed = false;
    private transient SecretKey unencryptedBaseKey;
    private transient SecretKey headerEncKey;
    private transient byte[] headerEncIV;
    private int version;
    private transient MasterSecret masterKey;
    private static final long END_MAGIC = 3176597310644858067L;
    private static final int VERSION_AND_MAGIC_LENGTH = 12;
    public static final int MAGIC = -658879362;

    public EncryptedRandomAccessBucket(EncryptedRandomAccessBufferType type, RandomAccessBucket underlying, MasterSecret masterKey) {
        this.type = type;
        this.underlying = underlying;
        this.masterKey = masterKey;
        this.baseSetup(masterKey);
    }

    private void baseSetup(MasterSecret masterKey) {
        MasterSecret masterSecret = masterKey;
        this.headerEncKey = masterSecret.deriveKey(this.type.encryptKey);
        this.headerMacKey = masterSecret.deriveKey(this.type.macKey);
        this.version = this.type.bitmask;
    }

    private SkippingStreamCipher setup(OutputStream os) throws GeneralSecurityException, IOException {
        this.headerEncIV = KeyGenUtils.genIV(this.type.encryptType.ivSize).getIV();
        this.unencryptedBaseKey = KeyGenUtils.genSecretKey(this.type.encryptKey);
        this.writeHeader(os);
        this.setupKeys();
        SkippingStreamCipher cipherWrite = this.type.get();
        cipherWrite.init(true, (CipherParameters)this.cipherParams);
        return cipherWrite;
    }

    private void writeHeader(OutputStream os) throws GeneralSecurityException, IOException {
        byte[] macResult;
        byte[] header = new byte[this.type.headerLen];
        int offset = 0;
        int ivLen = this.headerEncIV.length;
        System.arraycopy(this.headerEncIV, 0, header, offset, ivLen);
        offset += ivLen;
        byte[] encryptedKey = null;
        try {
            CryptByteBuffer crypt = new CryptByteBuffer(this.type.encryptType, this.headerEncKey, this.headerEncIV);
            encryptedKey = crypt.encryptCopy(this.unencryptedBaseKey.getEncoded());
        }
        catch (InvalidKeyException e) {
            throw new GeneralSecurityException("Something went wrong with key generation. please report", e.fillInStackTrace());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new GeneralSecurityException("Something went wrong with key generation. please report", e.fillInStackTrace());
        }
        System.arraycopy(encryptedKey, 0, header, offset, encryptedKey.length);
        offset += encryptedKey.length;
        byte[] ver = ByteBuffer.allocate(4).putInt(this.version).array();
        try {
            MessageAuthCode mac = new MessageAuthCode(this.type.macType, this.headerMacKey);
            macResult = Fields.copyToArray(mac.genMac(this.headerEncIV, this.unencryptedBaseKey.getEncoded(), ver));
            System.arraycopy(macResult, 0, header, offset, macResult.length);
        }
        catch (InvalidKeyException e) {
            throw new GeneralSecurityException("Something went wrong with key generation. please report", e.fillInStackTrace());
        }
        System.arraycopy(ver, 0, header, offset += macResult.length, ver.length);
        byte[] magic = ByteBuffer.allocate(8).putLong(3176597310644858067L).array();
        System.arraycopy(magic, 0, header, offset += ver.length, magic.length);
        os.write(header);
    }

    private SkippingStreamCipher setup(InputStream is) throws IOException, GeneralSecurityException {
        byte[] fullHeader = new byte[this.type.headerLen];
        try {
            new DataInputStream(is).readFully(fullHeader);
        }
        catch (EOFException e) {
            throw new IOException("Underlying RandomAccessBuffer is not long enough to include the footer.");
        }
        byte[] header = Arrays.copyOfRange(fullHeader, fullHeader.length - 12, fullHeader.length);
        int offset = 0;
        int readVersion = ByteBuffer.wrap(header, offset, 4).getInt();
        long magic = ByteBuffer.wrap(header, offset += 4, 8).getLong();
        if (3176597310644858067L != magic) {
            throw new IOException("This is not an EncryptedRandomAccessBuffer!");
        }
        if (readVersion != this.version) {
            throw new IOException("Version of the underlying RandomAccessBuffer is incompatible with this ERATType");
        }
        if (!this.verifyHeader(fullHeader)) {
            throw new GeneralSecurityException("MAC is incorrect");
        }
        this.setupKeys();
        SkippingStreamCipher cipherRead = this.type.get();
        cipherRead.init(false, (CipherParameters)this.cipherParams);
        return cipherRead;
    }

    private boolean verifyHeader(byte[] fullHeader) throws IOException, InvalidKeyException {
        byte[] footer = Arrays.copyOfRange(fullHeader, 0, fullHeader.length - 12);
        int offset = 0;
        this.headerEncIV = new byte[this.type.encryptType.ivSize.intValue()];
        System.arraycopy(footer, offset, this.headerEncIV, 0, this.headerEncIV.length);
        int keySize = this.type.encryptKey.keySize >> 3;
        byte[] encryptedKey = new byte[keySize];
        System.arraycopy(footer, offset += this.headerEncIV.length, encryptedKey, 0, keySize);
        offset += keySize;
        try {
            CryptByteBuffer crypt = new CryptByteBuffer(this.type.encryptType, this.headerEncKey, this.headerEncIV);
            this.unencryptedBaseKey = KeyGenUtils.getSecretKey(this.type.encryptKey, crypt.decryptCopy(encryptedKey));
        }
        catch (InvalidKeyException e) {
            throw new IOException("Error reading encryption keys from header.");
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException("Error reading encryption keys from header.");
        }
        byte[] mac = new byte[this.type.macLen];
        System.arraycopy(footer, offset, mac, 0, this.type.macLen);
        byte[] ver = ByteBuffer.allocate(4).putInt(this.version).array();
        MessageAuthCode authcode = new MessageAuthCode(this.type.macType, this.headerMacKey);
        return authcode.verifyData(mac, this.headerEncIV, this.unencryptedBaseKey.getEncoded(), ver);
    }

    private void setupKeys() {
        ParametersWithIV tempPram = null;
        try {
            KeyParameter cipherKey = new KeyParameter(KeyGenUtils.deriveSecretKey(this.unencryptedBaseKey, EncryptedRandomAccessBuffer.class, EncryptedRandomAccessBuffer.kdfInput.underlyingKey.input, this.type.encryptKey).getEncoded());
            tempPram = new ParametersWithIV((CipherParameters)cipherKey, KeyGenUtils.deriveIvParameterSpec(this.unencryptedBaseKey, EncryptedRandomAccessBuffer.class, EncryptedRandomAccessBuffer.kdfInput.underlyingIV.input, this.type.encryptKey).getIV());
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        this.cipherParams = tempPram;
    }

    @Override
    public OutputStream getOutputStreamUnbuffered() throws IOException {
        if (this.isFreed) {
            throw new IOException("This RandomAccessBuffer has already been closed. This should not happen.");
        }
        OutputStream uos = this.underlying.getOutputStreamUnbuffered();
        try {
            return new MyOutputStream(uos, this.setup(uos));
        }
        catch (GeneralSecurityException e) {
            Logger.error(this, "Unable to create encrypted bucket: " + e, (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public InputStream getInputStreamUnbuffered() throws IOException {
        if (this.size() == 0L) {
            return new NullInputStream();
        }
        if (this.isFreed) {
            throw new IOException("This RandomAccessBuffer has already been closed. This should not happen.");
        }
        InputStream is = this.underlying.getInputStreamUnbuffered();
        try {
            return new MyInputStream(is, this.setup(is));
        }
        catch (GeneralSecurityException e) {
            Logger.error(this, "Unable to read encrypted bucket: " + e, (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName() + ":" + this.underlying.getName();
    }

    @Override
    public long size() {
        long size = this.underlying.size();
        if (size == 0L) {
            return 0L;
        }
        return size - (long)this.type.headerLen;
    }

    @Override
    public boolean isReadOnly() {
        return this.underlying.isReadOnly();
    }

    @Override
    public void setReadOnly() {
        this.underlying.setReadOnly();
    }

    @Override
    public void free() {
        if (this.isFreed) {
            return;
        }
        this.isFreed = true;
        this.underlying.free();
    }

    @Override
    public RandomAccessBucket createShadow() {
        RandomAccessBucket copy = this.underlying.createShadow();
        return new EncryptedRandomAccessBucket(this.type, copy, this.masterKey);
    }

    @Override
    public LockableRandomAccessBuffer toRandomAccessBuffer() throws IOException {
        if (this.underlying.size() < (long)this.type.headerLen) {
            throw new IOException("Converting empty bucket");
        }
        this.underlying.setReadOnly();
        LockableRandomAccessBuffer r = this.underlying.toRandomAccessBuffer();
        try {
            return new EncryptedRandomAccessBuffer(this.type, r, this.masterKey, false);
        }
        catch (GeneralSecurityException e) {
            Logger.error(this, "Unable to convert encrypted bucket: " + e, (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new BufferedOutputStream(this.getOutputStreamUnbuffered());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(this.getInputStreamUnbuffered());
    }

    @Override
    public void onResume(ClientContext context) throws ResumeFailedException {
        this.underlying.onResume(context);
        this.masterKey = context.getPersistentMasterSecret();
        this.baseSetup(this.masterKey);
    }

    @Override
    public void storeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(-658879362);
        dos.writeInt(this.type.bitmask);
        this.underlying.storeTo(dos);
    }

    public EncryptedRandomAccessBucket(DataInputStream dis, FilenameGenerator fg, PersistentFileTracker persistentFileTracker, MasterSecret masterKey2) throws IOException, ResumeFailedException, StorageFormatException {
        this.type = EncryptedRandomAccessBufferType.getByBitmask(dis.readInt());
        if (this.type == null) {
            throw new ResumeFailedException("Unknown EncryptedRandomAccessBucket type");
        }
        this.underlying = (RandomAccessBucket)BucketTools.restoreFrom(dis, fg, persistentFileTracker, masterKey2);
        this.baseSetup(masterKey2);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.underlying.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EncryptedRandomAccessBucket other = (EncryptedRandomAccessBucket)obj;
        if (this.type != other.type) {
            return false;
        }
        return this.underlying.equals(other.underlying);
    }

    public RandomAccessBucket getUnderlying() {
        return this.underlying;
    }

    class MyInputStream
    extends FilterInputStream {
        private final SkippingStreamCipher cipherRead;
        private byte[] one;

        public MyInputStream(InputStream in, SkippingStreamCipher cipher) {
            super(in);
            this.one = new byte[1];
            this.cipherRead = cipher;
        }

        @Override
        public int read() throws IOException {
            int readBytes = this.read(this.one);
            if (readBytes <= 0) {
                return readBytes;
            }
            return this.one[0] & 0xFF;
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            int readBytes = this.in.read(buf, offset, length);
            if (readBytes <= 0) {
                return readBytes;
            }
            this.cipherRead.processBytes(buf, offset, readBytes, buf, offset);
            return readBytes;
        }
    }

    class MyOutputStream
    extends FilterOutputStream {
        private final SkippingStreamCipher cipherWrite;
        private final byte[] one;

        public MyOutputStream(OutputStream out, SkippingStreamCipher cipher) {
            super(out);
            this.one = new byte[1];
            this.cipherWrite = cipher;
        }

        @Override
        public void write(int x) throws IOException {
            this.one[0] = (byte)x;
            this.write(this.one);
        }

        @Override
        public void write(byte[] buf) throws IOException {
            this.write(buf, 0, buf.length);
        }

        @Override
        public void write(byte[] buf, int offset, int length) throws IOException {
            byte[] ciphertext = new byte[length];
            this.cipherWrite.processBytes(buf, offset, length, ciphertext, 0);
            this.out.write(ciphertext);
        }
    }
}

