/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import com.sun.jndi.toolkit.url.UrlUtil;
import java.io.IOException;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.applet.PluginAppletViewer;
import sun.applet.PluginStreamHandler;

public class PluginCookieManager
extends CookieManager {
    private PluginStreamHandler streamHandler;

    public PluginCookieManager(PluginStreamHandler streamHandler) {
        this.streamHandler = streamHandler;
    }

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        if (uri == null || requestHeaders == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        HashMap cookieMap = new HashMap();
        String cookies = (String)PluginAppletViewer.requestPluginCookieInfo(uri);
        ArrayList<String> cookieHeader = new ArrayList<String>();
        if (cookies != null && cookies.length() > 0) {
            cookieHeader.add(cookies);
        }
        for (HttpCookie cookie : this.getCookieStore().get(uri)) {
            if (!this.pathMatches(uri.getPath(), cookie.getPath())) continue;
            cookieHeader.add(cookie.toString());
        }
        cookieMap.put("Cookie", cookieHeader);
        return Collections.unmodifiableMap(cookieMap);
    }

    private boolean pathMatches(String path, String pathToMatchWith) {
        if (path == pathToMatchWith) {
            return true;
        }
        if (path == null || pathToMatchWith == null) {
            return false;
        }
        return path.startsWith(pathToMatchWith);
    }

    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        super.put(uri, responseHeaders);
        for (Map.Entry<String, List<String>> headerEntry : responseHeaders.entrySet()) {
            String type = headerEntry.getKey();
            if (!"Set-Cookie".equalsIgnoreCase(type) && !"Set-Cookie2".equalsIgnoreCase(type)) continue;
            List<String> cookies = headerEntry.getValue();
            for (String cookie : cookies) {
                this.streamHandler.write("plugin PluginSetCookie reference -1 " + UrlUtil.encode(uri.toString(), "UTF-8") + " " + cookie);
            }
        }
    }
}

