"""Main IDJC python package initialiser.

Generated from file __init__.py.in.in -- edit the original.
"""

#   Copyright (C) 2011, 2012 Stephen Fairchild (s-fairchild@users.sourceforge.net)
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program in the file entitled COPYING.
#   If not, see <http://www.gnu.org/licenses/>.


import os
import gettext
import ctypes

import pygtk
pygtk.require("2.0")
import glib

from .utils import FixedAttributes
from .utils import PolicedAttributes
from .utils import PathStr


def lib_probe(at_runtime, names, extension):
    if at_runtime:
        for name in names.split():
            name += extension
            try:
                ctypes.CDLL(name)
            except Exception:
                continue
            else:
                return True, name
        else:
            return False, ""
    else:
        return True, ""


class FGlobs(object):
    """Namespace class of variables which cannot be altered.

    These are set by the build process.
    """

    __metaclass__ = FixedAttributes

    datarootdir = PathStr("""/usr/share""")
    libdir = PathStr("""/usr/lib""")
    pkglibdir = PathStr("""/usr/lib/idjc""")
    pkgdatadir = PathStr("""/usr/share/idjc""")
    localedir = PathStr("""/usr/share/locale""")
    bindir = PathStr("""/usr/bin""")
    avenabled = (0, 1)[1 and 1 and 1]
    flacenabled = 1
    oggflacenabled = 1
    opusenabled = 1
    speexenabled = 1
    twolameenabled = 1
    shouttlsenabled = 1
    
    have_libmp3lame, libmp3lame_filename = lib_probe(0,
                                "libmp3lame liblame", """.so""")
    
    have_libmpg123, libmpg123_filename = lib_probe(1,
                                        "libmpg123", """.so""")
        
    package_name = """idjc"""
    package_version = """0.8.16"""
    backend = PathStr("""/usr/lib/idjc""") / ("idjc" + """.so""")


_ = gettext.translation(FGlobs.package_name, FGlobs.localedir,
                                                        fallback=True).gettext


class PGlobs(object):
    """Values which cannot be changed once they have been read."""
      
    __metaclass__ = PolicedAttributes

    config_dir = PathStr(glib.get_user_config_dir()) / FGlobs.package_name
    #config_dir = PathStr(os.path.expanduser("~")) / ("." + FGlobs.package_name)
    profile_dir = config_dir / "profiles"
    dbus_bus_basename = "net.sf." + FGlobs.package_name
    dbus_objects_basename = "/net/sf/" + FGlobs.package_name
    app_shortform = "IDJC"
    app_longform = "Internet DJ Console"
    default_icon = FGlobs.pkgdatadir / "icon.png"
    autoload_profile_pathname = config_dir / "autoload-profile"
    copyright = _("Copyright 2005-%s Stephen Fairchild and others."
                                                    ) % """2016"""
    license = _("Released under the GNU General Public License V2.0+.")
    num_micpairs = 2
    num_streamers = 6
    num_encoders = 6
    num_recorders = 2
    num_effects = 24
    num_panpresets = 3


def main():
    """Package execution entry point."""

    from .prelims import ProfileManager  # pylint: disable=W0404
    ProfileManager()

    from . import maingui  # pylint: disable=W0404
    return maingui.main()
