/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.cli.UnrecognizedOptionException;

public class AmbiguousOptionException
extends UnrecognizedOptionException {
    private static final long serialVersionUID = 5829816121277947229L;
    private final Collection<String> matchingOptions;

    public AmbiguousOptionException(String string, Collection<String> collection) {
        super(AmbiguousOptionException.createMessage(string, collection), string);
        this.matchingOptions = collection;
    }

    public Collection<String> getMatchingOptions() {
        return this.matchingOptions;
    }

    private static String createMessage(String string, Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder("Ambiguous option: '");
        stringBuilder.append(string);
        stringBuilder.append("'  (could be: ");
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append("'");
            stringBuilder.append(iterator.next());
            stringBuilder.append("'");
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

