/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPCommand;
import org.apache.commons.net.ftp.FTPSServerSocketFactory;
import org.apache.commons.net.ftp.FTPSSocketFactory;
import org.apache.commons.net.util.Base64;
import org.apache.commons.net.util.SSLContextUtils;
import org.apache.commons.net.util.SSLSocketUtils;
import org.apache.commons.net.util.TrustManagerUtils;

public class FTPSClient
extends FTPClient {
    public static final int DEFAULT_FTPS_DATA_PORT = 989;
    public static final int DEFAULT_FTPS_PORT = 990;
    private static final String[] PROT_COMMAND_VALUE = new String[]{"C", "E", "S", "P"};
    private static final String DEFAULT_PROT = "C";
    private static final String DEFAULT_PROTOCOL = "TLS";
    private static final String CMD_AUTH = "AUTH";
    private static final String CMD_ADAT = "ADAT";
    private static final String CMD_PROT = "PROT";
    private static final String CMD_PBSZ = "PBSZ";
    private static final String CMD_MIC = "MIC";
    private static final String CMD_CONF = "CONF";
    private static final String CMD_ENC = "ENC";
    private static final String CMD_CCC = "CCC";
    private final boolean isImplicit;
    private final String protocol;
    private String auth = "TLS";
    private SSLContext context;
    private Socket plainSocket;
    private boolean isCreation = true;
    private boolean isClientMode = true;
    private boolean isNeedClientAuth = false;
    private boolean isWantClientAuth = false;
    private String[] suites = null;
    private String[] protocols = null;
    private TrustManager trustManager = TrustManagerUtils.getValidateServerCertificateTrustManager();
    private KeyManager keyManager = null;
    private HostnameVerifier hostnameVerifier = null;
    private boolean tlsEndpointChecking;
    @Deprecated
    public static String KEYSTORE_ALGORITHM;
    @Deprecated
    public static String TRUSTSTORE_ALGORITHM;
    @Deprecated
    public static String PROVIDER;
    @Deprecated
    public static String STORE_TYPE;

    public FTPSClient() {
        this(DEFAULT_PROTOCOL, false);
    }

    public FTPSClient(boolean bl) {
        this(DEFAULT_PROTOCOL, bl);
    }

    public FTPSClient(String string) {
        this(string, false);
    }

    public FTPSClient(String string, boolean bl) {
        this.protocol = string;
        this.isImplicit = bl;
        if (bl) {
            this.setDefaultPort(990);
        }
    }

    public FTPSClient(boolean bl, SSLContext sSLContext) {
        this(DEFAULT_PROTOCOL, bl);
        this.context = sSLContext;
    }

    public FTPSClient(SSLContext sSLContext) {
        this(false, sSLContext);
    }

    public void setAuthValue(String string) {
        this.auth = string;
    }

    public String getAuthValue() {
        return this.auth;
    }

    @Override
    protected void _connectAction_() throws IOException {
        if (this.isImplicit) {
            this.sslNegotiation();
        }
        super._connectAction_();
        if (!this.isImplicit) {
            this.execAUTH();
            this.sslNegotiation();
        }
    }

    protected void execAUTH() throws SSLException, IOException {
        int n = this.sendCommand(CMD_AUTH, this.auth);
        if (334 != n && 234 != n) {
            throw new SSLException(this.getReplyString());
        }
    }

    private void initSslContext() throws IOException {
        if (this.context == null) {
            this.context = SSLContextUtils.createSSLContext(this.protocol, this.getKeyManager(), this.getTrustManager());
        }
    }

    protected void sslNegotiation() throws IOException {
        this.plainSocket = this._socket_;
        this.initSslContext();
        SSLSocketFactory sSLSocketFactory = this.context.getSocketFactory();
        String string = this._hostname_ != null ? this._hostname_ : this.getRemoteAddress().getHostAddress();
        int n = this._socket_.getPort();
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this._socket_, string, n, false);
        sSLSocket.setEnableSessionCreation(this.isCreation);
        sSLSocket.setUseClientMode(this.isClientMode);
        if (this.isClientMode) {
            if (this.tlsEndpointChecking) {
                SSLSocketUtils.enableEndpointNameVerification(sSLSocket);
            }
        } else {
            sSLSocket.setNeedClientAuth(this.isNeedClientAuth);
            sSLSocket.setWantClientAuth(this.isWantClientAuth);
        }
        if (this.protocols != null) {
            sSLSocket.setEnabledProtocols(this.protocols);
        }
        if (this.suites != null) {
            sSLSocket.setEnabledCipherSuites(this.suites);
        }
        sSLSocket.startHandshake();
        this._socket_ = sSLSocket;
        this._controlInput_ = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream(), this.getControlEncoding()));
        this._controlOutput_ = new BufferedWriter(new OutputStreamWriter(sSLSocket.getOutputStream(), this.getControlEncoding()));
        if (this.isClientMode && this.hostnameVerifier != null && !this.hostnameVerifier.verify(string, sSLSocket.getSession())) {
            throw new SSLHandshakeException("Hostname doesn't match certificate");
        }
    }

    private KeyManager getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public void setEnabledSessionCreation(boolean bl) {
        this.isCreation = bl;
    }

    public boolean getEnableSessionCreation() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getEnableSessionCreation();
        }
        return false;
    }

    public void setNeedClientAuth(boolean bl) {
        this.isNeedClientAuth = bl;
    }

    public boolean getNeedClientAuth() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getNeedClientAuth();
        }
        return false;
    }

    public void setWantClientAuth(boolean bl) {
        this.isWantClientAuth = bl;
    }

    public boolean getWantClientAuth() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getWantClientAuth();
        }
        return false;
    }

    public void setUseClientMode(boolean bl) {
        this.isClientMode = bl;
    }

    public boolean getUseClientMode() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getUseClientMode();
        }
        return false;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.suites = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.suites, 0, stringArray.length);
    }

    public String[] getEnabledCipherSuites() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getEnabledCipherSuites();
        }
        return null;
    }

    public void setEnabledProtocols(String[] stringArray) {
        this.protocols = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.protocols, 0, stringArray.length);
    }

    public String[] getEnabledProtocols() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getEnabledProtocols();
        }
        return null;
    }

    public void execPBSZ(long l) throws SSLException, IOException {
        if (l < 0L || 0xFFFFFFFFL < l) {
            throw new IllegalArgumentException();
        }
        int n = this.sendCommand(CMD_PBSZ, String.valueOf(l));
        if (200 != n) {
            throw new SSLException(this.getReplyString());
        }
    }

    public long parsePBSZ(long l) throws SSLException, IOException {
        long l2;
        this.execPBSZ(l);
        long l3 = l;
        String string = this.extractPrefixedData("PBSZ=", this.getReplyString());
        if (string != null && (l2 = Long.parseLong(string)) < l3) {
            l3 = l2;
        }
        return l3;
    }

    public void execPROT(String string) throws SSLException, IOException {
        if (string == null) {
            string = DEFAULT_PROT;
        }
        if (!this.checkPROTValue(string)) {
            throw new IllegalArgumentException();
        }
        if (200 != this.sendCommand(CMD_PROT, string)) {
            throw new SSLException(this.getReplyString());
        }
        if (DEFAULT_PROT.equals(string)) {
            this.setSocketFactory(null);
            this.setServerSocketFactory(null);
        } else {
            this.setSocketFactory(new FTPSSocketFactory(this.context));
            this.setServerSocketFactory(new FTPSServerSocketFactory(this.context));
            this.initSslContext();
        }
    }

    private boolean checkPROTValue(String string) {
        for (String string2 : PROT_COMMAND_VALUE) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int sendCommand(String string, String string2) throws IOException {
        int n = super.sendCommand(string, string2);
        if (CMD_CCC.equals(string)) {
            if (200 == n) {
                this._socket_.close();
                this._socket_ = this.plainSocket;
                this._controlInput_ = new BufferedReader(new InputStreamReader(this._socket_.getInputStream(), this.getControlEncoding()));
                this._controlOutput_ = new BufferedWriter(new OutputStreamWriter(this._socket_.getOutputStream(), this.getControlEncoding()));
            } else {
                throw new SSLException(this.getReplyString());
            }
        }
        return n;
    }

    @Override
    @Deprecated
    protected Socket _openDataConnection_(int n, String string) throws IOException {
        return this._openDataConnection_(FTPCommand.getCommand(n), string);
    }

    @Override
    protected Socket _openDataConnection_(String string, String string2) throws IOException {
        Socket socket = super._openDataConnection_(string, string2);
        this._prepareDataSocket_(socket);
        if (socket instanceof SSLSocket) {
            SSLSocket sSLSocket = (SSLSocket)socket;
            sSLSocket.setUseClientMode(this.isClientMode);
            sSLSocket.setEnableSessionCreation(this.isCreation);
            if (!this.isClientMode) {
                sSLSocket.setNeedClientAuth(this.isNeedClientAuth);
                sSLSocket.setWantClientAuth(this.isWantClientAuth);
            }
            if (this.suites != null) {
                sSLSocket.setEnabledCipherSuites(this.suites);
            }
            if (this.protocols != null) {
                sSLSocket.setEnabledProtocols(this.protocols);
            }
            sSLSocket.startHandshake();
        }
        return socket;
    }

    protected void _prepareDataSocket_(Socket socket) throws IOException {
    }

    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    public void setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public boolean isEndpointCheckingEnabled() {
        return this.tlsEndpointChecking;
    }

    public void setEndpointCheckingEnabled(boolean bl) {
        this.tlsEndpointChecking = bl;
    }

    @Override
    public void disconnect() throws IOException {
        super.disconnect();
        this.setSocketFactory(null);
        this.setServerSocketFactory(null);
    }

    public int execAUTH(String string) throws IOException {
        return this.sendCommand(CMD_AUTH, string);
    }

    public int execADAT(byte[] byArray) throws IOException {
        if (byArray != null) {
            return this.sendCommand(CMD_ADAT, Base64.encodeBase64StringUnChunked(byArray));
        }
        return this.sendCommand(CMD_ADAT);
    }

    public int execCCC() throws IOException {
        int n = this.sendCommand(CMD_CCC);
        return n;
    }

    public int execMIC(byte[] byArray) throws IOException {
        if (byArray != null) {
            return this.sendCommand(CMD_MIC, Base64.encodeBase64StringUnChunked(byArray));
        }
        return this.sendCommand(CMD_MIC, "");
    }

    public int execCONF(byte[] byArray) throws IOException {
        if (byArray != null) {
            return this.sendCommand(CMD_CONF, Base64.encodeBase64StringUnChunked(byArray));
        }
        return this.sendCommand(CMD_CONF, "");
    }

    public int execENC(byte[] byArray) throws IOException {
        if (byArray != null) {
            return this.sendCommand(CMD_ENC, Base64.encodeBase64StringUnChunked(byArray));
        }
        return this.sendCommand(CMD_ENC, "");
    }

    public byte[] parseADATReply(String string) {
        if (string == null) {
            return null;
        }
        return Base64.decodeBase64(this.extractPrefixedData("ADAT=", string));
    }

    private String extractPrefixedData(String string, String string2) {
        int n = string2.indexOf(string);
        if (n == -1) {
            return null;
        }
        return string2.substring(n + string.length()).trim();
    }
}

