/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.pop3;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.net.io.CRLFLineReader;
import org.apache.commons.net.pop3.POP3Client;
import org.apache.commons.net.util.SSLContextUtils;
import org.apache.commons.net.util.SSLSocketUtils;

public class POP3SClient
extends POP3Client {
    private static final int DEFAULT_POP3S_PORT = 995;
    private static final String DEFAULT_PROTOCOL = "TLS";
    private final boolean isImplicit;
    private final String protocol;
    private SSLContext context = null;
    private String[] suites = null;
    private String[] protocols = null;
    private TrustManager trustManager = null;
    private KeyManager keyManager = null;
    private HostnameVerifier hostnameVerifier = null;
    private boolean tlsEndpointChecking;

    public POP3SClient() {
        this(DEFAULT_PROTOCOL, false);
    }

    public POP3SClient(boolean bl) {
        this(DEFAULT_PROTOCOL, bl);
    }

    public POP3SClient(String string) {
        this(string, false);
    }

    public POP3SClient(String string, boolean bl) {
        this(string, bl, null);
    }

    public POP3SClient(String string, boolean bl, SSLContext sSLContext) {
        this.protocol = string;
        this.isImplicit = bl;
        this.context = sSLContext;
        if (this.isImplicit) {
            this.setDefaultPort(995);
        }
    }

    public POP3SClient(boolean bl, SSLContext sSLContext) {
        this(DEFAULT_PROTOCOL, bl, sSLContext);
    }

    public POP3SClient(SSLContext sSLContext) {
        this(false, sSLContext);
    }

    @Override
    protected void _connectAction_() throws IOException {
        if (this.isImplicit) {
            this.performSSLNegotiation();
        }
        super._connectAction_();
    }

    private void initSSLContext() throws IOException {
        if (this.context == null) {
            this.context = SSLContextUtils.createSSLContext(this.protocol, this.getKeyManager(), this.getTrustManager());
        }
    }

    private void performSSLNegotiation() throws IOException {
        this.initSSLContext();
        SSLSocketFactory sSLSocketFactory = this.context.getSocketFactory();
        String string = this._hostname_ != null ? this._hostname_ : this.getRemoteAddress().getHostAddress();
        int n = this.getRemotePort();
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this._socket_, string, n, true);
        sSLSocket.setEnableSessionCreation(true);
        sSLSocket.setUseClientMode(true);
        if (this.tlsEndpointChecking) {
            SSLSocketUtils.enableEndpointNameVerification(sSLSocket);
        }
        if (this.protocols != null) {
            sSLSocket.setEnabledProtocols(this.protocols);
        }
        if (this.suites != null) {
            sSLSocket.setEnabledCipherSuites(this.suites);
        }
        sSLSocket.startHandshake();
        this._socket_ = sSLSocket;
        this._input_ = sSLSocket.getInputStream();
        this._output_ = sSLSocket.getOutputStream();
        this._reader = new CRLFLineReader(new InputStreamReader(this._input_, "ISO-8859-1"));
        this._writer = new BufferedWriter(new OutputStreamWriter(this._output_, "ISO-8859-1"));
        if (this.hostnameVerifier != null && !this.hostnameVerifier.verify(string, sSLSocket.getSession())) {
            throw new SSLHandshakeException("Hostname doesn't match certificate");
        }
    }

    private KeyManager getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.suites = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.suites, 0, stringArray.length);
    }

    public String[] getEnabledCipherSuites() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getEnabledCipherSuites();
        }
        return null;
    }

    public void setEnabledProtocols(String[] stringArray) {
        this.protocols = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.protocols, 0, stringArray.length);
    }

    public String[] getEnabledProtocols() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getEnabledProtocols();
        }
        return null;
    }

    public boolean execTLS() throws SSLException, IOException {
        if (this.sendCommand("STLS") != 0) {
            return false;
        }
        this.performSSLNegotiation();
        return true;
    }

    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    public void setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public boolean isEndpointCheckingEnabled() {
        return this.tlsEndpointChecking;
    }

    public void setEndpointCheckingEnabled(boolean bl) {
        this.tlsEndpointChecking = bl;
    }
}

