/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.annotation.NoClass;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public final class ClassUtil {
    private static final Class<?> CLS_OBJECT = Object.class;
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private static final Ctor[] NO_CTORS = new Ctor[0];
    private static final EmptyIterator<?> EMPTY_ITERATOR = new EmptyIterator();

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static List<JavaType> findSuperTypes(JavaType javaType, Class<?> clazz, boolean bl) {
        if (javaType == null || javaType.hasRawClass(clazz) || javaType.hasRawClass(Object.class)) {
            return Collections.emptyList();
        }
        ArrayList<JavaType> arrayList = new ArrayList<JavaType>(8);
        ClassUtil._addSuperTypes(javaType, clazz, arrayList, bl);
        return arrayList;
    }

    public static List<Class<?>> findRawSuperTypes(Class<?> clazz, Class<?> clazz2, boolean bl) {
        if (clazz == null || clazz == clazz2 || clazz == Object.class) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList(8);
        ClassUtil._addRawSuperTypes(clazz, clazz2, arrayList, bl);
        return arrayList;
    }

    public static List<Class<?>> findSuperClasses(Class<?> clazz, Class<?> clazz2, boolean bl) {
        LinkedList linkedList = new LinkedList();
        if (clazz != null && clazz != clazz2) {
            if (bl) {
                linkedList.add(clazz);
            }
            while ((clazz = clazz.getSuperclass()) != null && clazz != clazz2) {
                linkedList.add(clazz);
            }
        }
        return linkedList;
    }

    @Deprecated
    public static List<Class<?>> findSuperTypes(Class<?> clazz, Class<?> clazz2) {
        return ClassUtil.findSuperTypes(clazz, clazz2, new ArrayList(8));
    }

    @Deprecated
    public static List<Class<?>> findSuperTypes(Class<?> clazz, Class<?> clazz2, List<Class<?>> list) {
        ClassUtil._addRawSuperTypes(clazz, clazz2, list, false);
        return list;
    }

    private static void _addSuperTypes(JavaType javaType, Class<?> clazz, Collection<JavaType> collection, boolean bl) {
        if (javaType == null) {
            return;
        }
        Class<?> clazz2 = javaType.getRawClass();
        if (clazz2 == clazz || clazz2 == Object.class) {
            return;
        }
        if (bl) {
            if (collection.contains(javaType)) {
                return;
            }
            collection.add(javaType);
        }
        for (JavaType javaType2 : javaType.getInterfaces()) {
            ClassUtil._addSuperTypes(javaType2, clazz, collection, true);
        }
        ClassUtil._addSuperTypes(javaType.getSuperClass(), clazz, collection, true);
    }

    private static void _addRawSuperTypes(Class<?> clazz, Class<?> clazz2, Collection<Class<?>> collection, boolean bl) {
        if (clazz == clazz2 || clazz == null || clazz == Object.class) {
            return;
        }
        if (bl) {
            if (collection.contains(clazz)) {
                return;
            }
            collection.add(clazz);
        }
        for (Class<?> clazz3 : ClassUtil._interfaces(clazz)) {
            ClassUtil._addRawSuperTypes(clazz3, clazz2, collection, true);
        }
        ClassUtil._addRawSuperTypes(clazz.getSuperclass(), clazz2, collection, true);
    }

    public static String canBeABeanType(Class<?> clazz) {
        if (clazz.isAnnotation()) {
            return "annotation";
        }
        if (clazz.isArray()) {
            return "array";
        }
        if (clazz.isEnum()) {
            return "enum";
        }
        if (clazz.isPrimitive()) {
            return "primitive";
        }
        return null;
    }

    public static String isLocalType(Class<?> clazz, boolean bl) {
        try {
            if (ClassUtil.hasEnclosingMethod(clazz)) {
                return "local/anonymous";
            }
            if (!bl && !Modifier.isStatic(clazz.getModifiers()) && ClassUtil.getEnclosingClass(clazz) != null) {
                return "non-static member class";
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static Class<?> getOuterClass(Class<?> clazz) {
        try {
            if (ClassUtil.hasEnclosingMethod(clazz)) {
                return null;
            }
            if (!Modifier.isStatic(clazz.getModifiers())) {
                return ClassUtil.getEnclosingClass(clazz);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isProxyType(Class<?> clazz) {
        String string = clazz.getName();
        return string.startsWith("net.sf.cglib.proxy.") || string.startsWith("org.hibernate.proxy.");
    }

    public static boolean isConcrete(Class<?> clazz) {
        int n = clazz.getModifiers();
        return (n & 0x600) == 0;
    }

    public static boolean isConcrete(Member member) {
        int n = member.getModifiers();
        return (n & 0x600) == 0;
    }

    public static boolean isCollectionMapOrArray(Class<?> clazz) {
        if (clazz.isArray()) {
            return true;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Map.class.isAssignableFrom(clazz);
    }

    public static String getClassDescription(Object object) {
        if (object == null) {
            return "unknown";
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        return clazz.getName();
    }

    @Deprecated
    public static Class<?> findClass(String string) throws ClassNotFoundException {
        if (string.indexOf(46) < 0) {
            if ("int".equals(string)) {
                return Integer.TYPE;
            }
            if ("long".equals(string)) {
                return Long.TYPE;
            }
            if ("float".equals(string)) {
                return Float.TYPE;
            }
            if ("double".equals(string)) {
                return Double.TYPE;
            }
            if ("boolean".equals(string)) {
                return Boolean.TYPE;
            }
            if ("byte".equals(string)) {
                return Byte.TYPE;
            }
            if ("char".equals(string)) {
                return Character.TYPE;
            }
            if ("short".equals(string)) {
                return Short.TYPE;
            }
            if ("void".equals(string)) {
                return Void.TYPE;
            }
        }
        Throwable throwable = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                return Class.forName(string, true, classLoader);
            }
            catch (Exception exception) {
                throwable = ClassUtil.getRootCause(exception);
            }
        }
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            if (throwable == null) {
                throwable = ClassUtil.getRootCause(exception);
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new ClassNotFoundException(throwable.getMessage(), throwable);
        }
    }

    @Deprecated
    public static boolean hasGetterSignature(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray != null && classArray.length != 0) {
            return false;
        }
        return Void.TYPE != method.getReturnType();
    }

    public static Throwable getRootCause(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static void throwRootCause(Throwable throwable) throws Exception {
        if ((throwable = ClassUtil.getRootCause(throwable)) instanceof Exception) {
            throw (Exception)throwable;
        }
        throw (Error)throwable;
    }

    public static Throwable throwRootCauseIfIOE(Throwable throwable) throws IOException {
        if ((throwable = ClassUtil.getRootCause(throwable)) instanceof IOException) {
            throw (IOException)throwable;
        }
        return throwable;
    }

    public static void throwAsIAE(Throwable throwable) {
        ClassUtil.throwAsIAE(throwable, throwable.getMessage());
    }

    public static void throwAsIAE(Throwable throwable, String string) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new IllegalArgumentException(string, throwable);
    }

    public static void unwrapAndThrowAsIAE(Throwable throwable) {
        ClassUtil.throwAsIAE(ClassUtil.getRootCause(throwable));
    }

    public static void unwrapAndThrowAsIAE(Throwable throwable, String string) {
        ClassUtil.throwAsIAE(ClassUtil.getRootCause(throwable), string);
    }

    public static void closeOnFailAndThrowAsIAE(JsonGenerator jsonGenerator, Exception exception) throws IOException {
        jsonGenerator.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
        try {
            jsonGenerator.close();
        }
        catch (Exception exception2) {
            exception.addSuppressed(exception2);
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    public static void closeOnFailAndThrowAsIAE(JsonGenerator jsonGenerator, Closeable closeable, Exception exception) throws IOException {
        if (jsonGenerator != null) {
            jsonGenerator.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
            try {
                jsonGenerator.close();
            }
            catch (Exception exception2) {
                exception.addSuppressed(exception2);
            }
        }
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception3) {
                exception.addSuppressed(exception3);
            }
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    public static <T> T createInstance(Class<T> clazz, boolean bl) throws IllegalArgumentException {
        Constructor<T> constructor = ClassUtil.findConstructor(clazz, bl);
        if (constructor == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " has no default (no arg) constructor");
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            ClassUtil.unwrapAndThrowAsIAE(exception, "Failed to instantiate class " + clazz.getName() + ", problem: " + exception.getMessage());
            return null;
        }
    }

    public static <T> Constructor<T> findConstructor(Class<T> clazz, boolean bl) throws IllegalArgumentException {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (bl) {
                ClassUtil.checkAndFixAccess(constructor);
            } else if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new IllegalArgumentException("Default constructor for " + clazz.getName() + " is not accessible (non-public?): not allowed to try modify access via Reflection: can not instantiate type");
            }
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            ClassUtil.unwrapAndThrowAsIAE(exception, "Failed to find default constructor of class " + clazz.getName() + ", problem: " + exception.getMessage());
        }
        return null;
    }

    public static Object defaultValue(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        throw new IllegalArgumentException("Class " + clazz.getName() + " is not a primitive type");
    }

    public static Class<?> wrapperType(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        throw new IllegalArgumentException("Class " + clazz.getName() + " is not a primitive type");
    }

    public static Class<?> primitiveType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        return null;
    }

    @Deprecated
    public static void checkAndFixAccess(Member member) {
        ClassUtil.checkAndFixAccess(member, false);
    }

    public static void checkAndFixAccess(Member member, boolean bl) {
        block3: {
            AccessibleObject accessibleObject = (AccessibleObject)((Object)member);
            try {
                if (bl || !Modifier.isPublic(member.getModifiers()) || !Modifier.isPublic(member.getDeclaringClass().getModifiers())) {
                    accessibleObject.setAccessible(true);
                }
            }
            catch (SecurityException securityException) {
                if (accessibleObject.isAccessible()) break block3;
                Class<?> clazz = member.getDeclaringClass();
                throw new IllegalArgumentException("Can not access " + member + " (from class " + clazz.getName() + "; failed to set access: " + securityException.getMessage());
            }
        }
    }

    public static Class<? extends Enum<?>> findEnumType(EnumSet<?> enumSet) {
        if (!enumSet.isEmpty()) {
            return ClassUtil.findEnumType((Enum)enumSet.iterator().next());
        }
        return EnumTypeLocator.instance.enumTypeFor(enumSet);
    }

    public static Class<? extends Enum<?>> findEnumType(EnumMap<?, ?> enumMap) {
        if (!enumMap.isEmpty()) {
            return ClassUtil.findEnumType((Enum)enumMap.keySet().iterator().next());
        }
        return EnumTypeLocator.instance.enumTypeFor(enumMap);
    }

    public static Class<? extends Enum<?>> findEnumType(Enum<?> enum_) {
        Class<?> clazz = enum_.getClass();
        if (clazz.getSuperclass() != Enum.class) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static Class<? extends Enum<?>> findEnumType(Class<?> clazz) {
        if (clazz.getSuperclass() != Enum.class) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static <T extends Annotation> Enum<?> findFirstAnnotatedEnumValue(Class<Enum<?>> clazz, Class<T> clazz2) {
        Field[] fieldArray;
        for (Field field : fieldArray = ClassUtil.getDeclaredFields(clazz)) {
            T t;
            if (!field.isEnumConstant() || (t = field.getAnnotation(clazz2)) == null) continue;
            String string = field.getName();
            for (Enum<?> enum_ : clazz.getEnumConstants()) {
                if (!string.equals(enum_.name())) continue;
                return enum_;
            }
        }
        return null;
    }

    public static boolean isJacksonStdImpl(Object object) {
        return object != null && ClassUtil.isJacksonStdImpl(object.getClass());
    }

    public static boolean isJacksonStdImpl(Class<?> clazz) {
        return clazz.getAnnotation(JacksonStdImpl.class) != null;
    }

    public static boolean isBogusClass(Class<?> clazz) {
        return clazz == Void.class || clazz == Void.TYPE || clazz == NoClass.class;
    }

    public static boolean isNonStaticInnerClass(Class<?> clazz) {
        return !Modifier.isStatic(clazz.getModifiers()) && ClassUtil.getEnclosingClass(clazz) != null;
    }

    public static boolean isObjectOrPrimitive(Class<?> clazz) {
        return clazz == CLS_OBJECT || clazz.isPrimitive();
    }

    public static String getPackageName(Class<?> clazz) {
        Package package_ = clazz.getPackage();
        return package_ == null ? null : package_.getName();
    }

    public static boolean hasEnclosingMethod(Class<?> clazz) {
        return !ClassUtil.isObjectOrPrimitive(clazz) && clazz.getEnclosingMethod() != null;
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        return clazz.getDeclaredFields();
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return clazz.getDeclaredMethods();
    }

    public static Annotation[] findClassAnnotations(Class<?> clazz) {
        if (ClassUtil.isObjectOrPrimitive(clazz)) {
            return NO_ANNOTATIONS;
        }
        return clazz.getDeclaredAnnotations();
    }

    public static Ctor[] getConstructors(Class<?> clazz) {
        if (clazz.isInterface() || ClassUtil.isObjectOrPrimitive(clazz)) {
            return NO_CTORS;
        }
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        int n = constructorArray.length;
        Ctor[] ctorArray = new Ctor[n];
        for (int i = 0; i < n; ++i) {
            ctorArray[i] = new Ctor(constructorArray[i]);
        }
        return ctorArray;
    }

    public static Class<?> getDeclaringClass(Class<?> clazz) {
        return ClassUtil.isObjectOrPrimitive(clazz) ? null : clazz.getDeclaringClass();
    }

    public static Type getGenericSuperclass(Class<?> clazz) {
        return clazz.getGenericSuperclass();
    }

    public static Type[] getGenericInterfaces(Class<?> clazz) {
        return clazz.getGenericInterfaces();
    }

    public static Class<?> getEnclosingClass(Class<?> clazz) {
        return ClassUtil.isObjectOrPrimitive(clazz) ? null : clazz.getEnclosingClass();
    }

    private static Class<?>[] _interfaces(Class<?> clazz) {
        return clazz.getInterfaces();
    }

    public static final class Ctor {
        public final Constructor<?> _ctor;
        private Annotation[] _annotations;
        private Annotation[][] _paramAnnotations;
        private int _paramCount = -1;

        public Ctor(Constructor<?> constructor) {
            this._ctor = constructor;
        }

        public Constructor<?> getConstructor() {
            return this._ctor;
        }

        public int getParamCount() {
            int n = this._paramCount;
            if (n < 0) {
                this._paramCount = n = this._ctor.getParameterTypes().length;
            }
            return n;
        }

        public Class<?> getDeclaringClass() {
            return this._ctor.getDeclaringClass();
        }

        public Annotation[] getDeclaredAnnotations() {
            Annotation[] annotationArray = this._annotations;
            if (annotationArray == null) {
                annotationArray = this._ctor.getDeclaredAnnotations();
                this._annotations = annotationArray;
            }
            return annotationArray;
        }

        public Annotation[][] getParameterAnnotations() {
            Annotation[][] annotationArray = this._paramAnnotations;
            if (annotationArray == null) {
                annotationArray = this._ctor.getParameterAnnotations();
                this._paramAnnotations = annotationArray;
            }
            return annotationArray;
        }
    }

    private static class EnumTypeLocator {
        static final EnumTypeLocator instance = new EnumTypeLocator();
        private final Field enumSetTypeField = EnumTypeLocator.locateField(EnumSet.class, "elementType", Class.class);
        private final Field enumMapTypeField = EnumTypeLocator.locateField(EnumMap.class, "elementType", Class.class);

        private EnumTypeLocator() {
        }

        public Class<? extends Enum<?>> enumTypeFor(EnumSet<?> enumSet) {
            if (this.enumSetTypeField != null) {
                return (Class)this.get(enumSet, this.enumSetTypeField);
            }
            throw new IllegalStateException("Can not figure out type for EnumSet (odd JDK platform?)");
        }

        public Class<? extends Enum<?>> enumTypeFor(EnumMap<?, ?> enumMap) {
            if (this.enumMapTypeField != null) {
                return (Class)this.get(enumMap, this.enumMapTypeField);
            }
            throw new IllegalStateException("Can not figure out type for EnumMap (odd JDK platform?)");
        }

        private Object get(Object object, Field field) {
            try {
                return field.get(object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        }

        private static Field locateField(Class<?> clazz, String string, Class<?> clazz2) {
            Field[] fieldArray;
            Field field = null;
            for (Field field2 : fieldArray = ClassUtil.getDeclaredFields(clazz)) {
                if (!string.equals(field2.getName()) || field2.getType() != clazz2) continue;
                field = field2;
                break;
            }
            if (field == null) {
                for (Field field2 : fieldArray) {
                    if (field2.getType() != clazz2) continue;
                    if (field != null) {
                        return null;
                    }
                    field = field2;
                }
            }
            if (field != null) {
                try {
                    field.setAccessible(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return field;
        }
    }

    private static final class EmptyIterator<T>
    implements Iterator<T> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

