/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.JavaClassParent;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.parser.structs.TypeDef;
import com.thoughtworks.qdox.parser.structs.TypeVariableDef;

public class TypeVariable
extends Type {
    public static final TypeVariable[] EMPTY_ARRAY = new TypeVariable[0];
    private Type[] bounds;

    public TypeVariable(String string, TypeVariableDef typeVariableDef, JavaClassParent javaClassParent) {
        super(string, typeVariableDef.name, 0, javaClassParent);
        if (typeVariableDef.bounds != null && !typeVariableDef.bounds.isEmpty()) {
            this.bounds = new Type[typeVariableDef.bounds.size()];
            for (int i = 0; i < typeVariableDef.bounds.size(); ++i) {
                this.bounds[i] = TypeVariable.createUnresolved((TypeDef)typeVariableDef.bounds.get(i), javaClassParent);
            }
        }
    }

    public static TypeVariable createUnresolved(TypeVariableDef typeVariableDef, JavaClassParent javaClassParent) {
        return new TypeVariable(null, typeVariableDef, javaClassParent);
    }

    @Override
    public String getValue() {
        return this.bounds == null || this.bounds.length == 0 ? "" : this.bounds[0].getValue();
    }

    @Override
    public String getGenericValue() {
        StringBuffer stringBuffer = new StringBuffer("<");
        stringBuffer.append(super.getValue());
        if (this.bounds != null && this.bounds.length > 0) {
            stringBuffer.append(" extends ");
            for (int i = 0; i < this.bounds.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.bounds[i].getGenericValue());
            }
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public String getName() {
        return super.getValue();
    }
}

