/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlgraphics.image.loader.cache.ImageCacheListener;
import org.apache.xmlgraphics.image.loader.cache.ImageKey;

public class ImageCacheStatistics
implements ImageCacheListener {
    private int invalidHits;
    private int imageInfoCacheHits;
    private int imageInfoCacheMisses;
    private int imageCacheHits;
    private int imageCacheMisses;
    private Map imageCacheHitMap;
    private Map imageCacheMissMap;

    public ImageCacheStatistics(boolean bl) {
        if (bl) {
            this.imageCacheHitMap = new HashMap();
            this.imageCacheMissMap = new HashMap();
        }
    }

    public void reset() {
        this.imageInfoCacheHits = 0;
        this.imageInfoCacheMisses = 0;
        this.invalidHits = 0;
    }

    @Override
    public void invalidHit(String string) {
        ++this.invalidHits;
    }

    @Override
    public void cacheHitImageInfo(String string) {
        ++this.imageInfoCacheHits;
    }

    @Override
    public void cacheMissImageInfo(String string) {
        ++this.imageInfoCacheMisses;
    }

    private void increaseEntry(Map map, Object object) {
        Integer n = (Integer)map.get(object);
        if (n == null) {
            n = 1;
        } else {
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
        }
        map.put(object, n);
    }

    @Override
    public void cacheHitImage(ImageKey imageKey) {
        ++this.imageCacheHits;
        if (this.imageCacheHitMap != null) {
            this.increaseEntry(this.imageCacheHitMap, imageKey);
        }
    }

    @Override
    public void cacheMissImage(ImageKey imageKey) {
        ++this.imageCacheMisses;
        if (this.imageCacheMissMap != null) {
            this.increaseEntry(this.imageCacheMissMap, imageKey);
        }
    }

    public int getInvalidHits() {
        return this.invalidHits;
    }

    public int getImageInfoCacheHits() {
        return this.imageInfoCacheHits;
    }

    public int getImageInfoCacheMisses() {
        return this.imageInfoCacheMisses;
    }

    public int getImageCacheHits() {
        return this.imageCacheHits;
    }

    public int getImageCacheMisses() {
        return this.imageCacheMisses;
    }

    public Map getImageCacheHitMap() {
        return Collections.unmodifiableMap(this.imageCacheHitMap);
    }

    public Map getImageCacheMissMap() {
        return Collections.unmodifiableMap(this.imageCacheMissMap);
    }
}

