/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.xmlgraphics.xmp.Metadata;
import org.apache.xmlgraphics.xmp.XMPParser;

public final class XMPPacketParser {
    private static final byte[] PACKET_HEADER;
    private static final byte[] PACKET_HEADER_END;
    private static final byte[] PACKET_TRAILER;

    private XMPPacketParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Metadata parse(InputStream inputStream) throws IOException, TransformerException {
        Metadata metadata;
        boolean bl;
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(bl = XMPPacketParser.skipAfter(inputStream, PACKET_HEADER))) {
            return null;
        }
        if (!XMPPacketParser.skipAfter(inputStream, PACKET_HEADER_END)) {
            throw new IOException("Invalid XMP packet header!");
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            if (!XMPPacketParser.skipAfter(inputStream, PACKET_TRAILER, (OutputStream)byteArrayOutputStream)) {
                throw new IOException("XMP packet not properly terminated!");
            }
            metadata = XMPParser.parseXMP(new StreamSource(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
        }
        finally {
            IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
        }
        return metadata;
    }

    private static boolean skipAfter(InputStream inputStream, byte[] byArray) throws IOException {
        return XMPPacketParser.skipAfter(inputStream, byArray, null);
    }

    private static boolean skipAfter(InputStream inputStream, byte[] byArray, OutputStream outputStream) throws IOException {
        int n;
        int n2 = 0;
        int n3 = byArray.length;
        while ((n = inputStream.read()) >= 0) {
            if (n == byArray[n2]) {
                if (++n2 != n3) continue;
                return true;
            }
            if (outputStream != null) {
                if (n2 > 0) {
                    outputStream.write(byArray, 0, n2);
                }
                outputStream.write(n);
            }
            n2 = 0;
        }
        return false;
    }

    static {
        try {
            PACKET_HEADER = "<?xpacket begin=".getBytes("US-ASCII");
            PACKET_HEADER_END = "?>".getBytes("US-ASCII");
            PACKET_TRAILER = "<?xpacket".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Incompatible JVM! US-ASCII encoding not supported.");
        }
    }
}

