/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullBufferStream;
import javax.media.protocol.SourceStream;
import net.sf.fmj.media.parser.RawPullStreamParser;

public class RawPullBufferParser
extends RawPullStreamParser {
    static final String NAME = "Raw pull stream parser";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void open() {
        if (this.tracks != null) {
            return;
        }
        this.tracks = new Track[this.streams.length];
        for (int i = 0; i < this.streams.length; ++i) {
            this.tracks[i] = new FrameTrack(this, (PullBufferStream)this.streams[i]);
        }
    }

    @Override
    public void setSource(DataSource source) throws IncompatibleSourceException, IOException {
        if (!(source instanceof PullBufferDataSource)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        SourceStream[] streams = ((PullBufferDataSource)source).getStreams();
        if (streams == null) {
            throw new IOException("Got a null stream from the DataSource");
        }
        if (streams.length == 0) {
            throw new IOException("Got a empty stream array from the DataSource");
        }
        if (!this.supports(streams)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        this.source = source;
        this.streams = streams;
    }

    @Override
    protected boolean supports(SourceStream[] streams) {
        return streams[0] != null && streams[0] instanceof PullBufferStream;
    }

    class FrameTrack
    implements Track {
        Demultiplexer parser;
        PullBufferStream pbs;
        boolean enabled = true;
        Format format = null;
        TrackListener listener;
        Integer stateReq = new Integer(0);

        public FrameTrack(Demultiplexer parser, PullBufferStream pbs) {
            this.pbs = pbs;
            this.format = pbs.getFormat();
        }

        @Override
        public Time getDuration() {
            return this.parser.getDuration();
        }

        @Override
        public Format getFormat() {
            return this.format;
        }

        @Override
        public Time getStartTime() {
            return new Time(0L);
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public Time mapFrameToTime(int frameNumber) {
            return new Time(0L);
        }

        @Override
        public int mapTimeToFrame(Time t) {
            return -1;
        }

        @Override
        public void readFrame(Buffer buffer) {
            if (buffer.getData() == null) {
                buffer.setData(new byte[500]);
            }
            try {
                this.pbs.read(buffer);
            }
            catch (IOException e) {
                buffer.setDiscard(true);
            }
        }

        @Override
        public void setEnabled(boolean t) {
            this.enabled = t;
        }

        @Override
        public void setTrackListener(TrackListener l) {
            this.listener = l;
        }
    }
}

