/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ImEncodedString;
import net.kano.joscar.ImEncodingParams;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.AbstractIcbm;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.icbm.InstantMessage;
import net.kano.joscar.snaccmd.icbm.OldIconHashInfo;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractImIcbm
extends AbstractIcbm {
    private static final ByteBlock ENCBLOCK_NULLS = ByteBlock.wrap(new byte[]{0, 0, 0, 0});
    private static final int TYPE_MESSAGE = 2;
    private static final int TYPE_ICONINFO = 8;
    private static final int TYPE_AUTORESPONSE = 4;
    private static final int TYPE_ICON_REQ = 9;
    private static final int TYPE_EXPRESSION_INFO = 13;
    private static final int TYPE_FEATURES = 1281;
    private static final int TYPE_MESSAGE_PARTS = 257;
    private static final int TYPE_ENCRYPTION_CODE = 3329;
    public static final ByteBlock FEATURES_OLD = ByteBlock.wrap(new byte[]{1, 1, 1, 2});
    public static final ByteBlock FEATURES_DEFAULT = ByteBlock.wrap(new byte[]{5, 1});
    private InstantMessage message;
    private boolean autoResponse;
    private boolean wantsIcon;
    private OldIconHashInfo iconInfo;
    private List<ExtraInfoBlock> expressionInfoBlocks;
    private ByteBlock featuresBlock;

    protected AbstractImIcbm(int command, SnacPacket packet) {
        super(4, command, packet);
    }

    protected final void processImTlvs(TlvChain chain) {
        DefensiveTools.checkNull(chain, "chain");
        Tlv messageTlv = chain.getLastTlv(2);
        Tlv iconTlv = chain.getLastTlv(8);
        Tlv expInfoTlv = chain.getLastTlv(13);
        this.autoResponse = chain.hasTlv(4);
        this.wantsIcon = chain.hasTlv(9);
        if (messageTlv != null) {
            ImmutableTlvChain msgTLVs = TlvTools.readChain(messageTlv.getData());
            Tlv featuresTlv = msgTLVs.getLastTlv(1281);
            this.featuresBlock = featuresTlv != null ? featuresTlv.getData() : null;
            if (msgTLVs.hasTlv(3329)) {
                Tlv msgDataTlv = msgTLVs.getFirstTlv(257);
                ByteBlock block = msgDataTlv.getData().subBlock(4);
                int encCode = msgTLVs.getUShort(3329);
                this.message = new InstantMessage(encCode, block);
            } else {
                String msgString;
                List<Tlv> parts = msgTLVs.getTlvs(257);
                if (parts.size() == 1) {
                    msgString = AbstractImIcbm.extractMsgFromPart(parts.get(0).getData());
                } else {
                    StringBuffer messageBuffer = new StringBuffer();
                    for (Tlv part : parts) {
                        ByteBlock partBlock = part.getData();
                        String message = AbstractImIcbm.extractMsgFromPart(partBlock);
                        messageBuffer.append(message);
                    }
                    msgString = messageBuffer.toString();
                }
                this.message = new InstantMessage(msgString);
            }
        } else {
            this.featuresBlock = null;
            this.message = null;
        }
        if (iconTlv != null) {
            ByteBlock iconData = iconTlv.getData();
            this.iconInfo = OldIconHashInfo.readIconHashFromImTlvData(iconData);
        } else {
            this.iconInfo = null;
        }
        if (expInfoTlv != null) {
            ByteBlock data = expInfoTlv.getData();
            this.expressionInfoBlocks = ExtraInfoBlock.readExtraInfoBlocks(data);
        }
    }

    private static String extractMsgFromPart(ByteBlock partBlock) {
        int charsetCode = BinaryTools.getUShort(partBlock, 0);
        int charsetSubcode = BinaryTools.getUShort(partBlock, 2);
        ByteBlock messageBlock = partBlock.subBlock(4);
        return ImEncodedString.readImEncodedString(new ImEncodingParams(charsetCode, charsetSubcode), messageBlock);
    }

    protected AbstractImIcbm(int command, long messageId, InstantMessage message, boolean autoResponse, boolean wantsIcon, OldIconHashInfo iconInfo, Collection<ExtraInfoBlock> expInfoBlocks, ByteBlock featuresBlock) {
        super(4, command, messageId, 1);
        this.message = message;
        this.autoResponse = autoResponse;
        this.wantsIcon = wantsIcon;
        this.iconInfo = iconInfo;
        this.expressionInfoBlocks = DefensiveTools.getSafeListCopy(expInfoBlocks, "expInfoBlocks");
        this.featuresBlock = featuresBlock;
    }

    public final InstantMessage getMessage() {
        return this.message;
    }

    public final boolean isAutoResponse() {
        return this.autoResponse;
    }

    public final boolean senderWantsIcon() {
        return this.wantsIcon;
    }

    public final OldIconHashInfo getIconInfo() {
        return this.iconInfo;
    }

    public final List<ExtraInfoBlock> getAimExpressionInfo() {
        return this.expressionInfoBlocks;
    }

    public final ByteBlock getFeaturesBlock() {
        return this.featuresBlock;
    }

    final void writeImTlvs(OutputStream out) throws IOException {
        InstantMessage message;
        if (this.autoResponse) {
            new Tlv(4).write(out);
        }
        if ((message = this.message) != null) {
            ByteBlock messageData;
            MutableTlvChain chain = TlvTools.createMutableChain();
            if (message.isEncrypted()) {
                Tlv encCodeTlv = Tlv.getUShortInstance(3329, message.getEncryptionCode());
                ByteBlock encBlock = ENCBLOCK_NULLS;
                ByteBlock encryptData = message.getEncryptedData();
                messageData = ByteBlock.createByteBlock(Arrays.asList(encBlock, encryptData));
                chain.addTlv(encCodeTlv);
            } else {
                ByteArrayOutputStream msgout = new ByteArrayOutputStream();
                ImEncodedString encInfo = ImEncodedString.encodeString(message.getMessage());
                ImEncodingParams encoding = encInfo.getEncoding();
                BinaryTools.writeUShort(msgout, encoding.getCharsetCode());
                BinaryTools.writeUShort(msgout, encoding.getCharsetSubcode());
                msgout.write(encInfo.getBytes());
                messageData = ByteBlock.wrap(msgout.toByteArray());
            }
            if (this.featuresBlock != null) {
                chain.addTlv(new Tlv(1281, this.featuresBlock));
            }
            chain.addTlv(new Tlv(257, messageData));
            new Tlv(2, ByteBlock.createByteBlock(chain)).write(out);
        }
        if (this.iconInfo != null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(20);
            this.iconInfo.writeToImTlv(bout);
            ByteBlock iconInfoBlock = ByteBlock.wrap(bout.toByteArray());
            new Tlv(8, iconInfoBlock).write(out);
        }
        if (this.wantsIcon) {
            new Tlv(9).write(out);
        }
        if (this.expressionInfoBlocks != null) {
            ByteBlock blocks = ByteBlock.createByteBlock(this.expressionInfoBlocks);
            new Tlv(13, blocks).write(out);
        }
    }
}

