/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreatorImpl;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.ElementMetadataImpl;
import com.google.gdata.model.ElementValidator;
import com.google.gdata.model.MetadataContext;
import com.google.gdata.model.QName;
import com.google.gdata.model.Schema;
import com.google.gdata.model.Transform;
import com.google.gdata.model.TransformKey;
import com.google.gdata.model.VirtualElementHolder;
import java.util.LinkedHashMap;
import java.util.Map;

final class ElementTransform
extends Transform {
    static final ElementTransform EMPTY = new ElementTransform();
    private final ElementMetadata.Cardinality cardinality;
    private final Boolean contentRequired;
    private final ElementValidator validator;
    private final Object properties;
    private final VirtualElementHolder virtualElementHolder;
    private final boolean flattened;
    private final Map<QName, ElementCreatorImpl.AttributeInfo> attributes;
    private final Map<QName, ElementCreatorImpl.ElementInfo> elements;
    private final Map<String, ElementKey<?, ?>> adaptations;

    static ElementTransform create(ElementCreatorImpl creator) {
        ElementTransform transform = new ElementTransform(creator);
        if (transform.isEmpty()) {
            return EMPTY;
        }
        return transform;
    }

    static ElementTransform create(ElementKey<?, ?> key, Iterable<ElementTransform> parts) {
        ElementTransform composite = new ElementTransform(key, parts);
        if (composite.isEmpty()) {
            return EMPTY;
        }
        return composite;
    }

    static ElementTransform mergeSource(Schema schema, ElementKey<?, ?> key, ElementTransform transform, MetadataContext context) {
        ElementTransform source;
        TransformKey sourceKey = transform.getSource();
        if (sourceKey != null && (source = schema.getTransform(sourceKey.getParent(), (ElementKey)sourceKey.getKey(), context)) != null) {
            return new ElementTransform(key, transform, source);
        }
        return transform;
    }

    private ElementTransform() {
        this.cardinality = null;
        this.contentRequired = null;
        this.validator = null;
        this.properties = null;
        this.virtualElementHolder = null;
        this.flattened = false;
        this.attributes = ImmutableMap.of();
        this.elements = ImmutableMap.of();
        this.adaptations = ImmutableMap.of();
    }

    private ElementTransform(ElementCreatorImpl builder) {
        super(builder);
        this.cardinality = builder.getCardinality();
        this.contentRequired = builder.getContentRequired();
        this.validator = builder.getValidator();
        this.properties = builder.getProperties();
        this.virtualElementHolder = builder.getVirtualElementHolder();
        this.flattened = builder.isFlattened();
        this.attributes = ImmutableMap.copyOf(builder.getAttributes());
        this.elements = ImmutableMap.copyOf(builder.getElements());
        this.adaptations = ImmutableMap.copyOf(builder.getAdaptations());
    }

    private ElementTransform(ElementKey<?, ?> key, Iterable<ElementTransform> parts) {
        super(parts);
        ElementMetadata.Cardinality compositeCardinality = null;
        Boolean compositeContentRequired = null;
        ElementValidator compositeValidator = null;
        Object compositeProperties = null;
        VirtualElementHolder compositeVirtualElementHolder = null;
        boolean compositeFlattened = false;
        LinkedHashMap compositeAttributes = Maps.newLinkedHashMap();
        LinkedHashMap compositeElements = Maps.newLinkedHashMap();
        LinkedHashMap compositeAdaptors = Maps.newLinkedHashMap();
        for (ElementTransform part : parts) {
            if (part.cardinality != null) {
                compositeCardinality = part.cardinality;
            }
            if (part.contentRequired != null) {
                compositeContentRequired = part.contentRequired;
            }
            if (part.validator != null) {
                compositeValidator = part.validator;
            }
            if (part.properties != null) {
                compositeProperties = part.properties;
            }
            if (part.virtualElementHolder != null) {
                compositeVirtualElementHolder = part.virtualElementHolder;
            }
            if (part.flattened) {
                compositeFlattened = true;
            }
            for (Map.Entry<QName, ElementCreatorImpl.AttributeInfo> entry : part.attributes.entrySet()) {
                QName attId = entry.getKey();
                ElementCreatorImpl.AttributeInfo attInfo = entry.getValue();
                if (attInfo.action == ElementCreatorImpl.Action.ADD) {
                    compositeAttributes.remove(attId);
                }
                compositeAttributes.put(attId, attInfo);
            }
            for (Map.Entry<QName, Object> entry : part.elements.entrySet()) {
                QName childId = entry.getKey();
                ElementCreatorImpl.ElementInfo childInfo = (ElementCreatorImpl.ElementInfo)entry.getValue();
                if (childInfo.action == ElementCreatorImpl.Action.ADD) {
                    compositeElements.remove(childId);
                }
                compositeElements.put(childId, childInfo);
            }
            for (Map.Entry<Object, Object> entry : part.adaptations.entrySet()) {
                ElementKey adaptor = (ElementKey)entry.getValue();
                if (!ElementTransform.isValidAdaptation(key, adaptor)) continue;
                compositeAdaptors.put(entry.getKey(), adaptor);
            }
        }
        this.cardinality = compositeCardinality;
        this.contentRequired = compositeContentRequired;
        this.validator = compositeValidator;
        this.properties = compositeProperties;
        this.virtualElementHolder = compositeVirtualElementHolder;
        this.flattened = compositeFlattened;
        this.attributes = ImmutableMap.copyOf((Map)compositeAttributes);
        this.elements = ImmutableMap.copyOf((Map)compositeElements);
        this.adaptations = ImmutableMap.copyOf((Map)compositeAdaptors);
    }

    private ElementTransform(ElementKey<?, ?> key, ElementTransform transform, ElementTransform source) {
        super(transform, source);
        this.cardinality = ElementTransform.first(transform.cardinality, source.cardinality);
        this.contentRequired = transform.contentRequired;
        this.validator = ElementTransform.first(transform.validator, source.validator);
        this.properties = ElementTransform.first(transform.properties, source.properties);
        this.virtualElementHolder = ElementTransform.first(transform.virtualElementHolder, source.virtualElementHolder);
        this.flattened = transform.isFlattened() || source.isFlattened();
        LinkedHashMap compositeAttributes = Maps.newLinkedHashMap();
        compositeAttributes.putAll(source.getAttributes());
        for (Map.Entry<QName, ElementCreatorImpl.AttributeInfo> entry : transform.attributes.entrySet()) {
            QName attId = entry.getKey();
            if (compositeAttributes.containsKey(attId)) continue;
            compositeAttributes.put(entry.getKey(), entry.getValue());
        }
        this.attributes = ImmutableMap.copyOf((Map)compositeAttributes);
        LinkedHashMap compositeElements = Maps.newLinkedHashMap();
        compositeElements.putAll(source.getElements());
        for (Map.Entry<QName, ElementCreatorImpl.ElementInfo> entry : transform.elements.entrySet()) {
            QName childId = entry.getKey();
            if (compositeElements.containsKey(childId)) continue;
            compositeElements.put(childId, entry.getValue());
        }
        this.elements = ImmutableMap.copyOf((Map)compositeElements);
        LinkedHashMap compositeAdaptors = Maps.newLinkedHashMap();
        compositeAdaptors.putAll(source.getAdaptations());
        for (Map.Entry<String, ElementKey<?, ?>> entry : transform.adaptations.entrySet()) {
            String kind = entry.getKey();
            ElementKey<?, ?> adaptor = entry.getValue();
            if (compositeAdaptors.containsKey(kind) || !ElementTransform.isValidAdaptation(key, adaptor)) continue;
            compositeAdaptors.put(kind, adaptor);
        }
        this.adaptations = ImmutableMap.copyOf((Map)compositeAdaptors);
    }

    private static boolean isValidAdaptation(ElementKey<?, ?> source, ElementKey<?, ?> adaptor) {
        Class<?> adaptorType;
        Class<?> sourceType = source.getElementType();
        if (sourceType == (adaptorType = adaptor.getElementType())) {
            return false;
        }
        return sourceType.isAssignableFrom(adaptorType);
    }

    <D, E extends Element> ElementMetadata<D, E> toMetadata(Schema schema, ElementKey<?, ?> parent, ElementKey<D, E> key, MetadataContext context) {
        return new ElementMetadataImpl<D, E>(schema, this, parent, key, context);
    }

    ElementMetadata.Cardinality getCardinality() {
        return this.cardinality;
    }

    Boolean getContentRequired() {
        return this.contentRequired;
    }

    ElementValidator getValidator() {
        return this.validator;
    }

    Object getProperties() {
        return this.properties;
    }

    VirtualElementHolder getVirtualElementHolder() {
        return this.virtualElementHolder;
    }

    boolean isFlattened() {
        return this.flattened;
    }

    Map<QName, ElementCreatorImpl.AttributeInfo> getAttributes() {
        return this.attributes;
    }

    Map<QName, ElementCreatorImpl.ElementInfo> getElements() {
        return this.elements;
    }

    Map<String, ElementKey<?, ?>> getAdaptations() {
        return this.adaptations;
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.cardinality == null && this.contentRequired == null && this.validator == null && this.properties == null && this.virtualElementHolder == null && !this.flattened && this.attributes.isEmpty() && this.elements.isEmpty() && this.adaptations.isEmpty();
    }
}

