/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.impl.gui.main.chat.conference.AdHocChatRoomWrapper;
import net.java.sip.communicator.service.protocol.AdHocChatRoom;
import net.java.sip.communicator.service.protocol.ProtocolIcon;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class AdHocChatRoomProviderWrapper {
    private final ProtocolProviderService protocolProvider;
    private final List<AdHocChatRoomWrapper> chatRoomsOrderedCopy = new LinkedList<AdHocChatRoomWrapper>();

    public AdHocChatRoomProviderWrapper(ProtocolProviderService protocolProvider) {
        this.protocolProvider = protocolProvider;
    }

    public String getName() {
        return this.protocolProvider.getProtocolDisplayName();
    }

    public byte[] getIcon() {
        return this.protocolProvider.getProtocolIcon().getIcon("IconSize64x64");
    }

    public byte[] getImage() {
        byte[] logoImage = null;
        ProtocolIcon protocolIcon = this.protocolProvider.getProtocolIcon();
        if (protocolIcon.isSizeSupported("IconSize64x64")) {
            logoImage = protocolIcon.getIcon("IconSize64x64");
        } else if (protocolIcon.isSizeSupported("IconSize48x48")) {
            logoImage = protocolIcon.getIcon("IconSize48x48");
        }
        return logoImage;
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.protocolProvider;
    }

    public void addAdHocChatRoom(AdHocChatRoomWrapper adHocChatRoom) {
        this.chatRoomsOrderedCopy.add(adHocChatRoom);
    }

    public void removeChatRoom(AdHocChatRoomWrapper adHocChatRoom) {
        this.chatRoomsOrderedCopy.remove(adHocChatRoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAdHocChatRoom(AdHocChatRoomWrapper adHocChatRoom) {
        List<AdHocChatRoomWrapper> list = this.chatRoomsOrderedCopy;
        synchronized (list) {
            return this.chatRoomsOrderedCopy.contains(adHocChatRoom);
        }
    }

    public AdHocChatRoomWrapper findChatRoomWrapperForAdHocChatRoom(AdHocChatRoom adHocChatRoom) {
        for (AdHocChatRoomWrapper chatRoomWrapper : this.chatRoomsOrderedCopy) {
            if (!chatRoomWrapper.getAdHocChatRoomID().equals(adHocChatRoom.getIdentifier())) continue;
            return chatRoomWrapper;
        }
        return null;
    }

    public int countAdHocChatRooms() {
        return this.chatRoomsOrderedCopy.size();
    }

    public AdHocChatRoomWrapper getAdHocChatRoom(int index) {
        return this.chatRoomsOrderedCopy.get(index);
    }

    public int indexOf(AdHocChatRoomWrapper chatRoomWrapper) {
        return this.chatRoomsOrderedCopy.indexOf(chatRoomWrapper);
    }
}

