/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.HtmlTextConstruct;
import com.google.gdata.data.ITextConstruct;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.XhtmlTextConstruct;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlBlob;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import org.xml.sax.Attributes;

public abstract class TextConstruct
implements ITextConstruct {
    protected String lang;

    @Override
    public abstract int getType();

    public abstract boolean isEmpty();

    @Override
    public abstract String getPlainText();

    public String getLang() {
        return this.lang;
    }

    public void setLang(String v) {
        this.lang = v;
    }

    public static TextConstruct create(int type, String textOrHtml, XmlBlob xhtml) {
        switch (type) {
            case 1: {
                PlainTextConstruct ptc = new PlainTextConstruct(textOrHtml);
                return ptc;
            }
            case 2: {
                HtmlTextConstruct htc = new HtmlTextConstruct(textOrHtml);
                return htc;
            }
            case 3: {
                XhtmlTextConstruct xtc = new XhtmlTextConstruct(xhtml);
                return xtc;
            }
        }
        assert (false) : "Invalid type: " + String.valueOf(type);
        return null;
    }

    public static TextConstruct plainText(String text) {
        return new PlainTextConstruct(text);
    }

    public static TextConstruct html(String html) {
        return new HtmlTextConstruct(html);
    }

    public static TextConstruct xhtml(XmlBlob div) {
        return new XhtmlTextConstruct(div);
    }

    public abstract void generateAtom(XmlWriter var1, String var2) throws IOException;

    public abstract void generateRss(XmlWriter var1, String var2, RssFormat var3) throws IOException;

    public static ChildHandlerInfo getChildHandler(Attributes attrs) throws ParseException, IOException {
        String type = attrs.getValue("", "type");
        ChildHandlerInfo childHandlerInfo = new ChildHandlerInfo();
        if (type == null || type.equals("text") || type.equals("text/plain")) {
            PlainTextConstruct ptc = new PlainTextConstruct();
            childHandlerInfo.handler = ptc.new PlainTextConstruct.AtomHandler();
            childHandlerInfo.textConstruct = ptc;
        } else if (type.equals("html") || type.equals("text/html")) {
            HtmlTextConstruct htc = new HtmlTextConstruct();
            childHandlerInfo.handler = htc.new HtmlTextConstruct.AtomHandler();
            childHandlerInfo.textConstruct = htc;
        } else if (type.equals("xhtml")) {
            XhtmlTextConstruct xtc = new XhtmlTextConstruct();
            childHandlerInfo.handler = new XhtmlTextConstruct.AtomHandler(xtc);
            childHandlerInfo.textConstruct = xtc;
        } else {
            ParseException pe = new ParseException(CoreErrorDomain.ERR.invalidTextContentType);
            pe.setInternalReason("Invalid text content type: '" + type + "'");
            throw pe;
        }
        return childHandlerInfo;
    }

    public static class ChildHandlerInfo {
        public XmlParser.ElementHandler handler;
        public TextConstruct textConstruct;
    }

    public static enum RssFormat {
        PLAIN_TEXT,
        FULL_HTML;

    }

    public static class Type {
        public static final int TEXT = 1;
        public static final int HTML = 2;
        public static final int XHTML = 3;
    }
}

