/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceAdapter;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceListener;
import net.java.sip.communicator.service.protocol.event.CallPeerEvent;
import org.jitsi.util.event.PropertyChangeNotifier;

public class CallConference
extends PropertyChangeNotifier {
    public static final String CALLS = "calls";
    private final CallChangeListener callChangeListener = new CallChangeListener(){

        @Override
        public void callPeerAdded(CallPeerEvent ev) {
            CallConference.this.onCallPeerEvent(ev);
        }

        @Override
        public void callPeerRemoved(CallPeerEvent ev) {
            CallConference.this.onCallPeerEvent(ev);
        }

        @Override
        public void callStateChanged(CallChangeEvent ev) {
            CallConference.this.callStateChanged(ev);
        }
    };
    private final List<CallChangeListener> callChangeListeners = new LinkedList<CallChangeListener>();
    private final CallPeerConferenceListener callPeerConferenceListener = new CallPeerConferenceAdapter(){

        @Override
        protected void onCallPeerConferenceEvent(CallPeerConferenceEvent ev) {
            CallConference.this.onCallPeerConferenceEvent(ev);
        }

        @Override
        public void conferenceMemberErrorReceived(CallPeerConferenceEvent ev) {
            CallConference.this.onCallPeerConferenceEvent(ev);
        }
    };
    private final List<CallPeerConferenceListener> callPeerConferenceListeners = new LinkedList<CallPeerConferenceListener>();
    private final Object callsSyncRoot = new Object();
    private boolean conferenceFocus = false;
    private List<Call> immutableCalls;
    private final boolean jitsiVideobridge;
    private List<Call> mutableCalls;

    public static int getCallPeerCount(Call call) {
        CallConference conference = call.getConference();
        return conference == null ? call.getCallPeerCount() : conference.getCallPeerCount();
    }

    public static List<CallPeer> getCallPeers(Call call) {
        CallConference conference = call.getConference();
        ArrayList<CallPeer> callPeers = new ArrayList<CallPeer>();
        if (conference == null) {
            Iterator<? extends CallPeer> callPeerIt = call.getCallPeers();
            while (callPeerIt.hasNext()) {
                callPeers.add(callPeerIt.next());
            }
        } else {
            conference.getCallPeers(callPeers);
        }
        return callPeers;
    }

    public static List<Call> getCalls(Call call) {
        CallConference conference = call.getConference();
        List<Object> calls = conference == null ? Collections.emptyList() : conference.getCalls();
        return calls;
    }

    private static boolean isConferenceFocus(List<Call> calls) {
        int callCount = calls.size();
        boolean conferenceFocus = callCount < 1 ? false : (callCount > 1 ? true : calls.get(0).getCallPeerCount() > 1);
        return conferenceFocus;
    }

    public CallConference() {
        this(false);
    }

    public CallConference(boolean jitsiVideobridge) {
        this.jitsiVideobridge = jitsiVideobridge;
        this.mutableCalls = new ArrayList<Call>();
        this.immutableCalls = Collections.unmodifiableList(this.mutableCalls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addCall(Call call) {
        if (call == null) {
            throw new NullPointerException("call");
        }
        Object object = this.callsSyncRoot;
        synchronized (object) {
            if (this.mutableCalls.contains((Object)call)) {
                return false;
            }
            ArrayList<Call> newMutableCalls = new ArrayList<Call>(this.mutableCalls);
            if (!newMutableCalls.add(call)) {
                return false;
            }
            this.mutableCalls = newMutableCalls;
            this.immutableCalls = Collections.unmodifiableList(this.mutableCalls);
        }
        this.callAdded(call);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallChangeListener(CallChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<CallChangeListener> list = this.callChangeListeners;
        synchronized (list) {
            if (!this.callChangeListeners.contains(listener)) {
                this.callChangeListeners.add(listener);
            }
        }
    }

    private void addCallPeerConferenceListener(Call call) {
        Iterator<? extends CallPeer> callPeerIter = call.getCallPeers();
        while (callPeerIter.hasNext()) {
            callPeerIter.next().addCallPeerConferenceListener(this.callPeerConferenceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallPeerConferenceListener(CallPeerConferenceListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<CallPeerConferenceListener> list = this.callPeerConferenceListeners;
        synchronized (list) {
            if (!this.callPeerConferenceListeners.contains(listener)) {
                this.callPeerConferenceListeners.add(listener);
            }
        }
    }

    protected void callAdded(Call call) {
        call.addCallChangeListener(this.callChangeListener);
        this.addCallPeerConferenceListener(call);
        boolean conferenceFocus = CallConference.isConferenceFocus(this.getCalls());
        if (conferenceFocus) {
            this.setConferenceFocus(conferenceFocus);
        }
        this.firePropertyChange(CALLS, null, (Object)call);
    }

    protected void callRemoved(Call call) {
        call.removeCallChangeListener(this.callChangeListener);
        this.removeCallPeerConferenceListener(call);
        boolean conferenceFocus = CallConference.isConferenceFocus(this.getCalls());
        if (!conferenceFocus) {
            this.setConferenceFocus(conferenceFocus);
        }
        this.firePropertyChange(CALLS, (Object)call, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callStateChanged(CallChangeEvent ev) {
        Call call = ev.getSourceCall();
        if (this.containsCall(call)) {
            try {
                for (CallChangeListener l : this.getCallChangeListeners()) {
                    l.callStateChanged(ev);
                }
            }
            finally {
                if ("CallState".equals(ev.getPropertyName()) && CallState.CALL_ENDED.equals(ev.getNewValue())) {
                    this.removeCall(call);
                }
            }
        }
    }

    protected void conferenceFocusChanged(boolean oldValue, boolean newValue) {
        this.firePropertyChange("conferenceFocus", oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsCall(Call call) {
        Object object = this.callsSyncRoot;
        synchronized (object) {
            return this.mutableCalls.contains((Object)call);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallChangeListener[] getCallChangeListeners() {
        List<CallChangeListener> list = this.callChangeListeners;
        synchronized (list) {
            return this.callChangeListeners.toArray(new CallChangeListener[this.callChangeListeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCallCount() {
        Object object = this.callsSyncRoot;
        synchronized (object) {
            return this.mutableCalls.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallPeerConferenceListener[] getCallPeerConferenceListeners() {
        List<CallPeerConferenceListener> list = this.callPeerConferenceListeners;
        synchronized (list) {
            return this.callPeerConferenceListeners.toArray(new CallPeerConferenceListener[this.callPeerConferenceListeners.size()]);
        }
    }

    public int getCallPeerCount() {
        int callPeerCount = 0;
        for (Call call : this.getCalls()) {
            callPeerCount += call.getCallPeerCount();
        }
        return callPeerCount;
    }

    public List<CallPeer> getCallPeers() {
        ArrayList<CallPeer> callPeers = new ArrayList<CallPeer>();
        this.getCallPeers(callPeers);
        return callPeers;
    }

    protected void getCallPeers(List<CallPeer> callPeers) {
        for (Call call : this.getCalls()) {
            Iterator<? extends CallPeer> callPeerIt = call.getCallPeers();
            while (callPeerIt.hasNext()) {
                callPeers.add(callPeerIt.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Call> getCalls() {
        Object object = this.callsSyncRoot;
        synchronized (object) {
            return this.immutableCalls;
        }
    }

    public boolean isConferenceFocus() {
        return this.conferenceFocus;
    }

    public boolean isEnded() {
        for (Call call : this.getCalls()) {
            if (CallState.CALL_ENDED.equals(call.getCallState())) continue;
            return false;
        }
        return true;
    }

    public boolean isJitsiVideobridge() {
        return this.jitsiVideobridge;
    }

    private void onCallPeerConferenceEvent(CallPeerConferenceEvent ev) {
        int eventID = ev.getEventID();
        block6: for (CallPeerConferenceListener l : this.getCallPeerConferenceListeners()) {
            switch (eventID) {
                case 1: {
                    l.conferenceFocusChanged(ev);
                    continue block6;
                }
                case 2: {
                    l.conferenceMemberAdded(ev);
                    continue block6;
                }
                case 3: {
                    l.conferenceMemberRemoved(ev);
                    continue block6;
                }
                case 4: {
                    l.conferenceMemberErrorReceived(ev);
                    continue block6;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported CallPeerConferenceEvent eventID.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCallPeerEvent(CallPeerEvent ev) {
        Call call = ev.getSourceCall();
        if (this.containsCall(call)) {
            int eventID = ev.getEventID();
            boolean conferenceFocus = CallConference.isConferenceFocus(this.getCalls());
            switch (eventID) {
                case 1: {
                    if (!conferenceFocus) break;
                    this.setConferenceFocus(conferenceFocus);
                    break;
                }
                case 2: {
                    if (conferenceFocus) break;
                    this.setConferenceFocus(conferenceFocus);
                    break;
                }
            }
            try {
                block19: for (CallChangeListener l : this.getCallChangeListeners()) {
                    switch (eventID) {
                        case 1: {
                            l.callPeerAdded(ev);
                            continue block19;
                        }
                        case 2: {
                            l.callPeerRemoved(ev);
                            continue block19;
                        }
                    }
                }
            }
            finally {
                CallPeer callPeer = ev.getSourceCallPeer();
                switch (eventID) {
                    case 1: {
                        callPeer.addCallPeerConferenceListener(this.callPeerConferenceListener);
                        break;
                    }
                    case 2: {
                        callPeer.removeCallPeerConferenceListener(this.callPeerConferenceListener);
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeCall(Call call) {
        if (call == null) {
            return false;
        }
        Object object = this.callsSyncRoot;
        synchronized (object) {
            if (!this.mutableCalls.contains((Object)call)) {
                return false;
            }
            ArrayList<Call> newMutableCalls = new ArrayList<Call>(this.mutableCalls);
            if (!newMutableCalls.remove((Object)call)) {
                return false;
            }
            this.mutableCalls = newMutableCalls;
            this.immutableCalls = Collections.unmodifiableList(this.mutableCalls);
        }
        this.callRemoved(call);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallChangeListener(CallChangeListener listener) {
        if (listener != null) {
            List<CallChangeListener> list = this.callChangeListeners;
            synchronized (list) {
                this.callChangeListeners.remove(listener);
            }
        }
    }

    private void removeCallPeerConferenceListener(Call call) {
        Iterator<? extends CallPeer> callPeerIter = call.getCallPeers();
        while (callPeerIter.hasNext()) {
            callPeerIter.next().removeCallPeerConferenceListener(this.callPeerConferenceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallPeerConferenceListener(CallPeerConferenceListener listener) {
        if (listener != null) {
            List<CallPeerConferenceListener> list = this.callPeerConferenceListeners;
            synchronized (list) {
                this.callPeerConferenceListeners.remove(listener);
            }
        }
    }

    public void setConferenceFocus(boolean conferenceFocus) {
        if (this.conferenceFocus != conferenceFocus) {
            boolean oldValue = this.isConferenceFocus();
            this.conferenceFocus = conferenceFocus;
            boolean newValue = this.isConferenceFocus();
            if (oldValue != newValue) {
                this.conferenceFocusChanged(oldValue, newValue);
            }
        }
    }
}

