/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.sendfile;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;

public class FileSendBlock
implements LiveWritable {
    public static final int SENDTYPE_SINGLEFILE = 1;
    public static final int SENDTYPE_DIR = 2;
    private final int sendType;
    private final int fileCount;
    private final long totalFileSize;
    private final String filename;

    public static FileSendBlock readFileSendBlock(ByteBlock block) {
        int firstNull;
        DefensiveTools.checkNull(block, "block");
        int type = BinaryTools.getUShort(block, 0);
        int count = BinaryTools.getUShort(block, 2);
        long size = BinaryTools.getUInt(block, 4);
        ByteBlock filenameBlock = block.subBlock(8);
        for (firstNull = 0; firstNull < filenameBlock.getLength() && filenameBlock.get(firstNull) != 0; ++firstNull) {
        }
        String name = null;
        name = BinaryTools.getUtf8String(filenameBlock.subBlock(0, firstNull));
        return new FileSendBlock(type, name, count, size);
    }

    public FileSendBlock(String filename, long size) {
        this(1, filename, 1, size);
    }

    public FileSendBlock(int sendType, String filename, int fileCount, long totalFileSize) {
        DefensiveTools.checkRange(sendType, "sendType", 0);
        DefensiveTools.checkRange(fileCount, "fileCount", 0);
        DefensiveTools.checkRange(totalFileSize, "totalFileSize", 0L);
        DefensiveTools.checkNull(filename, "filename");
        this.sendType = sendType;
        this.fileCount = fileCount;
        this.totalFileSize = totalFileSize;
        this.filename = filename;
    }

    public final int getSendType() {
        return this.sendType;
    }

    public final int getFileCount() {
        return this.fileCount;
    }

    public final long getTotalFileSize() {
        return this.totalFileSize;
    }

    public final String getFilename() {
        return this.filename;
    }

    public void write(OutputStream out) throws IOException {
        BinaryTools.writeUShort(out, this.sendType);
        BinaryTools.writeUShort(out, this.fileCount);
        BinaryTools.writeUInt(out, this.totalFileSize);
        byte[] bytes = BinaryTools.getUtf8Bytes(this.filename);
        if (Arrays.binarySearch(bytes, (byte)0) >= 0) {
            bytes = BinaryTools.getLatinBytes(this.filename);
        }
        out.write(bytes);
        out.write(new byte[46]);
    }

    public String toString() {
        return "FileSendBlock: type=" + this.sendType + (this.fileCount > 1 ? ", " + this.fileCount + " files under " + this.filename : ": " + this.filename) + ": " + this.totalFileSize + " bytes total";
    }
}

