/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.java.sip.communicator.plugin.update.UpdateActivator;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleContext;

public class Resources {
    private static Logger logger = Logger.getLogger(Resources.class);
    private static final String UPDATE_CONFIGURATION_FILE = "update-location.properties";
    private static ResourceManagementService resources;
    private static Properties updateConfiguration;

    public static ResourceManagementService getResources() {
        if (resources == null) {
            resources = (ResourceManagementService)ServiceUtils.getService((BundleContext)UpdateActivator.bundleContext, ResourceManagementService.class);
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUpdateConfigurationString(String key) {
        if (updateConfiguration == null) {
            updateConfiguration = new Properties();
            File updateConfigurationFile = new File(UPDATE_CONFIGURATION_FILE);
            if (updateConfigurationFile.exists()) {
                FileInputStream updateConfigurationInputStream = null;
                try {
                    updateConfigurationInputStream = new FileInputStream(updateConfigurationFile);
                    updateConfiguration.load(updateConfigurationInputStream);
                }
                catch (IOException ioe) {
                    logger.error((Object)"Could not load the configuration file of the update plug-in.", (Throwable)ioe);
                }
                finally {
                    if (updateConfigurationInputStream != null) {
                        try {
                            ((InputStream)updateConfigurationInputStream).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)"No configuration file specified for the update plug-in.");
            }
        }
        return updateConfiguration.getProperty(key);
    }
}

