/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.secureim;

import java.util.Date;
import net.kano.joscar.DefensiveTools;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.icbm.MessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.EncryptedAimMessage;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.EncryptedAimMessageInfo;
import net.kano.joustsim.trust.BuddyCertificateInfo;

public class UndecryptableAimMessageInfo
extends MessageInfo {
    private final BuddyCertificateInfo certInfo;
    private final Reason reason;
    private final Exception exception;

    static UndecryptableAimMessageInfo getInstance(EncryptedAimMessageInfo msgInfo, BuddyCertificateInfo certInfo, Reason reason, Exception ex) {
        return new UndecryptableAimMessageInfo(msgInfo.getFrom(), msgInfo.getTo(), (EncryptedAimMessage)msgInfo.getMessage(), certInfo, msgInfo.getTimestamp(), reason, ex);
    }

    private UndecryptableAimMessageInfo(Screenname from, Screenname to, EncryptedAimMessage message, BuddyCertificateInfo certInfo, Date date, Reason reason, Exception ex) {
        super(from, to, message, date);
        DefensiveTools.checkNull(reason, "reason");
        this.certInfo = certInfo;
        this.reason = reason;
        this.exception = ex;
    }

    public BuddyCertificateInfo getMessageCertificateInfo() {
        return this.certInfo;
    }

    public Reason getReason() {
        return this.reason;
    }

    public Exception getException() {
        return this.exception;
    }

    public static class Reason {
        public static final Reason UNKNOWN = new Reason("UNKNOWN");
        public static final Reason DECRYPT_ERROR = new Reason("DECRYPT_ERROR");
        public static final Reason BAD_SIGNATURE = new Reason("BAD_SIGNATURE");
        private final String name;

        private Reason(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

