/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.presence.avatar.imagepicker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.GenericFileDialog;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileChooser;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileFilter;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.presence.avatar.imagepicker.EditPanel;
import net.java.sip.communicator.plugin.desktoputil.presence.avatar.imagepicker.WebcamDialog;

public class ImagePickerDialog
extends SIPCommDialog
implements ActionListener {
    private EditPanel editPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JButton selectFileButton;
    private JButton webcamButton;
    private boolean editCanceled = false;

    public ImagePickerDialog(int clipperZoneWidth, int clipperZoneHeight) {
        this.initComponents(clipperZoneWidth, clipperZoneHeight);
        this.initDialog();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void initDialog() {
        this.setTitle(DesktopUtilActivator.getResources().getI18NString("service.gui.avatar.imagepicker.IMAGE_PICKER"));
        this.setModal(true);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        TransparentPanel editButtonsPanel = new TransparentPanel();
        editButtonsPanel.setLayout(new FlowLayout(0));
        editButtonsPanel.add(this.selectFileButton);
        editButtonsPanel.add(this.webcamButton);
        TransparentPanel okCancelPanel = new TransparentPanel();
        okCancelPanel.setLayout(new FlowLayout(2));
        okCancelPanel.add(this.cancelButton);
        okCancelPanel.add(this.okButton);
        TransparentPanel buttonsPanel = new TransparentPanel();
        buttonsPanel.setLayout(new BorderLayout());
        buttonsPanel.add((Component)((Object)editButtonsPanel), "West");
        buttonsPanel.add((Component)((Object)okCancelPanel), "Center");
        this.add((Component)((Object)this.editPanel), "Center");
        this.add((Component)((Object)buttonsPanel), "South");
        this.pack();
    }

    private void initComponents(int clipperZoneWidth, int clipperZoneHeight) {
        this.editPanel = new EditPanel(clipperZoneWidth, clipperZoneHeight);
        this.okButton = new JButton(DesktopUtilActivator.getResources().getI18NString("service.gui.avatar.imagepicker.SET"));
        this.okButton.addActionListener(this);
        this.okButton.setName("okButton");
        this.cancelButton = new JButton(DesktopUtilActivator.getResources().getI18NString("service.gui.avatar.imagepicker.CANCEL"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setName("cancelButton");
        this.selectFileButton = new JButton(DesktopUtilActivator.getResources().getI18NString("service.gui.avatar.imagepicker.CHOOSE_FILE"));
        this.selectFileButton.addActionListener(this);
        this.selectFileButton.setName("selectFileButton");
        this.webcamButton = new JButton(DesktopUtilActivator.getResources().getI18NString("service.gui.avatar.imagepicker.TAKE_PHOTO"));
        this.webcamButton.addActionListener(this);
        this.webcamButton.setName("webcamButton");
    }

    public byte[] showDialog(Image image) {
        if (image != null) {
            this.editPanel.setImage(ImageUtils.getBufferedImage(image));
        }
        this.setVisible(true);
        if (this.editCanceled) {
            return null;
        }
        return this.editPanel.getClippedImage();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String name = ((JButton)e.getSource()).getName();
        if (name.equals("cancelButton")) {
            this.editCanceled = true;
            this.setVisible(false);
        } else if (name.equals("selectFileButton")) {
            SipCommFileChooser chooser = GenericFileDialog.create(null, DesktopUtilActivator.getResources().getI18NString("service.gui.avatar.imagepicker.CHOOSE_FILE"), 0);
            chooser.addFilter(new ImageFileFilter());
            File selectedFile = chooser.getFileFromDialog();
            if (selectedFile != null) {
                try {
                    BufferedImage image = ImageIO.read(selectedFile);
                    this.editPanel.setImage(image);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        } else if (name.equals("okButton")) {
            this.editCanceled = false;
            this.setVisible(false);
        } else if (name.equals("webcamButton")) {
            WebcamDialog dialog = new WebcamDialog(this);
            dialog.setVisible(true);
            byte[] bimage = dialog.getGrabbedImage();
            if (bimage != null) {
                Image i = new ImageIcon(bimage).getImage();
                this.editPanel.setImage(ImageUtils.getBufferedImage(i));
            }
        }
    }

    @Override
    protected void close(boolean isEscaped) {
        this.dispose();
    }

    class ImageFileFilter
    extends SipCommFileFilter {
        ImageFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            String path = f.getAbsolutePath().toLowerCase();
            return path.matches("(.*)\\.(jpg|jpeg|png|bmp)$") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return DesktopUtilActivator.getResources().getI18NString("service.gui.avatar.imagepicker.IMAGE_FILES");
        }
    }
}

