/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.provdisc.mdns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import net.java.sip.communicator.service.provdisc.event.DiscoveryEvent;
import net.java.sip.communicator.service.provdisc.event.DiscoveryListener;
import net.java.sip.communicator.util.Logger;

public class MDNSProvisioningDiscover
implements Runnable {
    private final Logger logger = Logger.getLogger(MDNSProvisioningDiscover.class);
    private static final int MDNS_TIMEOUT = 2000;
    private List<DiscoveryListener> listeners = new ArrayList<DiscoveryListener>();
    private JmDNS jmdns = null;

    @Override
    public void run() {
        String url = this.discoverProvisioningURL();
        if (url != null) {
            DiscoveryEvent evt = new DiscoveryEvent((Object)this, url);
            for (DiscoveryListener listener : this.listeners) {
                listener.notifyProvisioningURL(evt);
            }
        }
    }

    public String discoverProvisioningURL() {
        StringBuffer url = new StringBuffer();
        try {
            this.jmdns = JmDNS.create();
        }
        catch (IOException e) {
            this.logger.info((Object)"Failed to create JmDNS", (Throwable)e);
            return null;
        }
        ServiceInfo info = this.jmdns.getServiceInfo("_https._tcp.local", "Provisioning URL", 2000L);
        if (info == null) {
            info = this.jmdns.getServiceInfo("_http._tcp.local", "Provisioning URL", 2000L);
        }
        if (info != null && info.getName().equals("Provisioning URL")) {
            String protocol = info.getApplication();
            url.append(info.getURL(protocol));
            Enumeration en = info.getPropertyNames();
            if (en.hasMoreElements()) {
                url.append("?");
            }
            while (en.hasMoreElements()) {
                String tmp = (String)en.nextElement();
                if (tmp.equals("path")) continue;
                url.append(tmp);
                url.append("=");
                url.append(info.getPropertyString(tmp));
                if (!en.hasMoreElements()) continue;
                url.append("&");
            }
        }
        try {
            this.jmdns.close();
            this.jmdns = null;
        }
        catch (Exception e) {
            this.logger.warn((Object)"Failed to close JmDNS", (Throwable)e);
        }
        return url.toString().length() > 0 ? url.toString() : null;
    }

    public void addDiscoveryListener(DiscoveryListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeDiscoveryListener(DiscoveryListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }
}

