/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.ircaccregwizz;

import java.util.Hashtable;
import net.java.sip.communicator.plugin.ircaccregwizz.IrcAccountRegistrationWizard;
import net.java.sip.communicator.service.gui.AccountRegistrationWizard;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.gui.WizardContainer;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.util.AbstractServiceDependentActivator;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class IrcAccRegWizzActivator
extends AbstractServiceDependentActivator {
    private static Logger logger = Logger.getLogger((String)IrcAccRegWizzActivator.class.getName());
    static BundleContext bundleContext;
    private static UIService uiService;
    private static WizardContainer wizardContainer;
    private IrcAccountRegistrationWizard ircWizard;

    public void start(Object dependentService) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Loading irc account wizard.");
        }
        uiService = (UIService)dependentService;
        wizardContainer = uiService.getAccountRegWizardContainer();
        this.ircWizard = new IrcAccountRegistrationWizard(wizardContainer);
        Hashtable<String, String> containerFilter = new Hashtable<String, String>();
        containerFilter.put("PROTOCOL_NAME", "IRC");
        bundleContext.registerService(AccountRegistrationWizard.class.getName(), (Object)this.ircWizard, containerFilter);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"IRC account registration wizard [STARTED].");
        }
    }

    public Class<?> getDependentServiceClass() {
        return UIService.class;
    }

    public void setBundleContext(BundleContext context) {
        bundleContext = context;
    }

    public void stop(BundleContext bundleContext) {
    }

    public static ProtocolProviderFactory getIrcProtocolProviderFactory() {
        ServiceReference[] serRefs = null;
        String osgiFilter = "(PROTOCOL_NAME=IRC)";
        try {
            serRefs = bundleContext.getServiceReferences(ProtocolProviderFactory.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            logger.error((Object)ex);
        }
        return (ProtocolProviderFactory)bundleContext.getService(serRefs[0]);
    }

    public static UIService getUIService() {
        return uiService;
    }
}

