/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.callhistory;

import java.util.Date;
import java.util.List;
import java.util.Vector;
import net.java.sip.communicator.service.callhistory.CallPeerRecord;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class CallRecord {
    public static final String OUT = "out";
    public static final String IN = "in";
    protected String direction = null;
    protected final List<CallPeerRecord> peerRecords = new Vector<CallPeerRecord>();
    protected Date startTime = null;
    protected Date endTime = null;
    protected ProtocolProviderService protocolProvider;
    protected int endReason = -1;

    public CallRecord() {
    }

    public CallRecord(String direction, Date startTime, Date endTime) {
        this.direction = direction;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public CallPeerRecord findPeerRecord(String address) {
        for (CallPeerRecord item : this.peerRecords) {
            if (!item.getPeerAddress().equals(address)) continue;
            return item;
        }
        return null;
    }

    public String getDirection() {
        return this.direction;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public List<CallPeerRecord> getPeerRecords() {
        return this.peerRecords;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.protocolProvider;
    }

    public int getEndReason() {
        return this.endReason;
    }
}

