/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.keybindings;

import java.awt.AWTKeyStroke;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.KeyStroke;
import net.java.sip.communicator.impl.keybindings.GlobalKeybindingSetImpl;
import net.java.sip.communicator.impl.keybindings.KeybindingSetImpl;
import net.java.sip.communicator.impl.keybindings.KeybindingsActivator;
import net.java.sip.communicator.service.keybindings.GlobalKeybindingSet;
import net.java.sip.communicator.service.keybindings.KeybindingSet;
import net.java.sip.communicator.service.keybindings.KeybindingsService;
import net.java.sip.communicator.service.keybindings.Persistence;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.fileaccess.FileCategory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

class KeybindingsServiceImpl
implements KeybindingsService,
Observer {
    private static final Logger logger = Logger.getLogger(KeybindingsServiceImpl.class);
    private static final String DEFAULT_KEYBINDING_DIR = "/resources/config/defaultkeybindings";
    private static final String CUSTOM_KEYBINDING_DIR = "keybindings";
    private static final String CONFIGURATION_PATH = "net.java.sip.communicator.impl.keybinding.global";
    private static final String DEFAULTS_VALUES_PATH = "impl.keybinding.global";
    private boolean isRunning = false;
    private final HashMap<KeybindingSet.Category, KeybindingSetImpl> bindings = new HashMap();
    private GlobalKeybindingSet globalBindings = null;

    KeybindingsServiceImpl() {
    }

    synchronized void start(BundleContext bc) {
        if (this.isRunning) {
            return;
        }
        for (KeybindingSet.Category category : KeybindingSet.Category.values()) {
            KeybindingSetImpl newSet;
            File customFile;
            LinkedHashMap<KeyStroke, String> defaultBindings;
            Persistence format = category.getFormat();
            try {
                String defaultPath = "/resources/config/defaultkeybindings/" + category.getResource();
                InputStream in = this.getClass().getResourceAsStream(defaultPath);
                defaultBindings = format.load(in);
            }
            catch (IOException exc) {
                logger.error((Object)("default bindings set missing: " + category.getResource()), (Throwable)exc);
                this.bindings.put(category, null);
                continue;
            }
            catch (ParseException exc) {
                logger.error((Object)("unable to parse default bindings set: " + category.getResource()), (Throwable)exc);
                this.bindings.put(category, null);
                continue;
            }
            String customPath = "keybindings/" + category.getResource();
            try {
                ServiceReference faServiceReference = bc.getServiceReference(FileAccessService.class.getName());
                FileAccessService faService = (FileAccessService)bc.getService(faServiceReference);
                File customDir = faService.getPrivatePersistentDirectory(CUSTOM_KEYBINDING_DIR, FileCategory.PROFILE);
                if (!customDir.exists()) {
                    customDir.mkdir();
                }
                customFile = faService.getPrivatePersistentFile(customPath, FileCategory.PROFILE);
            }
            catch (Exception exc) {
                String msg = "unable to secure file for custom bindings (" + customPath + "), using defaults but won't be able to save changes";
                logger.error((Object)msg, (Throwable)exc);
                newSet = new KeybindingSetImpl(defaultBindings, category, null);
                this.bindings.put(category, newSet);
                newSet.addObserver(this);
                continue;
            }
            LinkedHashMap<KeyStroke, String> customBindings = null;
            if (customFile.exists()) {
                try {
                    FileInputStream in = new FileInputStream(customFile);
                    customBindings = format.load(in);
                    in.close();
                }
                catch (Exception in) {
                    // empty catch block
                }
            }
            LinkedHashMap<Object, Object> merged = new LinkedHashMap();
            if (customBindings != null) {
                LinkedHashMap<KeyStroke, String> customTmp = new LinkedHashMap<KeyStroke, String>(customBindings);
                for (Map.Entry<KeyStroke, String> shortcut2action : defaultBindings.entrySet()) {
                    String action = shortcut2action.getValue();
                    if (customTmp.containsValue(action)) {
                        KeyStroke custom = null;
                        for (Map.Entry customShortcut2action : customTmp.entrySet()) {
                            if (!((String)customShortcut2action.getValue()).equals(action)) continue;
                            custom = (KeyStroke)customShortcut2action.getKey();
                            break;
                        }
                        assert (custom != null);
                        customTmp.remove(custom);
                        merged.put(custom, action);
                        continue;
                    }
                    merged.put(shortcut2action.getKey(), action);
                }
            } else {
                merged = defaultBindings;
            }
            if (!merged.equals(customBindings)) {
                try {
                    FileOutputStream out = new FileOutputStream(customFile);
                    format.save(out, merged);
                    out.close();
                }
                catch (IOException exc) {
                    logger.error((Object)("unable to write to: " + customFile.getAbsolutePath()), (Throwable)exc);
                }
            }
            newSet = new KeybindingSetImpl(merged, category, customFile);
            this.bindings.put(category, newSet);
            newSet.addObserver(this);
        }
        this.globalBindings = new GlobalKeybindingSetImpl();
        this.globalBindings.setBindings(this.getGlobalShortcutFromConfiguration());
        this.isRunning = true;
    }

    synchronized void stop() {
        if (!this.isRunning) {
            return;
        }
        for (KeybindingSetImpl bindingSet : this.bindings.values()) {
            bindingSet.invalidate();
        }
        this.bindings.clear();
        this.saveGlobalShortcutFromConfiguration();
        this.isRunning = false;
    }

    @Override
    public synchronized KeybindingSet getBindings(KeybindingSet.Category category) {
        if (!this.isRunning) {
            throw new UnsupportedOperationException();
        }
        assert (this.bindings.containsKey((Object)category));
        return this.bindings.get((Object)category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable obs, Object arg) {
        KeybindingSetImpl changedBindings;
        if (obs instanceof KeybindingSetImpl && (changedBindings = (KeybindingSetImpl)obs).isWritable()) {
            KeybindingsServiceImpl keybindingsServiceImpl = this;
            synchronized (keybindingsServiceImpl) {
                if (changedBindings.isWritable()) {
                    File customFile = changedBindings.getCustomFile();
                    try {
                        FileOutputStream out = new FileOutputStream(customFile);
                        Persistence format = changedBindings.getCategory().getFormat();
                        format.save(out, (Map<KeyStroke, String>)changedBindings.getBindings());
                        out.close();
                    }
                    catch (IOException exc) {
                        logger.error((Object)("unable to write to: " + customFile.getAbsolutePath()), (Throwable)exc);
                    }
                }
            }
        }
    }

    @Override
    public Map<String, List<AWTKeyStroke>> getGlobalShortcutFromConfiguration() {
        LinkedHashMap<String, List<AWTKeyStroke>> gBindings = new LinkedHashMap<String, List<AWTKeyStroke>>();
        ConfigurationService configService = KeybindingsActivator.getConfigService();
        String shortcut = null;
        String shortcut2 = null;
        String propName = null;
        String propName2 = null;
        String[] names = new String[]{"answer", "hangup", "answer_hangup", "contactlist", "mute", "push_to_talk"};
        Object configured = configService.getProperty("net.java.sip.communicator.impl.keybinding.global.configured");
        if (configured == null) {
            for (String name : names) {
                ArrayList<AWTKeyStroke> kss = new ArrayList<AWTKeyStroke>();
                propName = "impl.keybinding.global." + name + ".1";
                String string = shortcut = propName != null ? KeybindingsActivator.getResourceService().getSettingsString(propName) : null;
                if (shortcut != null) {
                    kss.add(AWTKeyStroke.getAWTKeyStroke(shortcut));
                }
                gBindings.put(name, kss);
            }
            configService.setProperty("net.java.sip.communicator.impl.keybinding.global.configured", (Object)"true");
            return gBindings;
        }
        for (String name : names) {
            ArrayList<AWTKeyStroke> kss = new ArrayList<AWTKeyStroke>();
            propName = "net.java.sip.communicator.impl.keybinding.global." + name + ".1";
            propName2 = "net.java.sip.communicator.impl.keybinding.global." + name + ".2";
            shortcut = propName != null ? (String)configService.getProperty(propName) : null;
            String string = shortcut2 = propName2 != null ? (String)configService.getProperty(propName2) : null;
            if (shortcut != null) {
                kss.add(AWTKeyStroke.getAWTKeyStroke(shortcut));
            }
            if (shortcut2 != null) {
                int nb = Integer.parseInt(shortcut2);
                kss.add(AWTKeyStroke.getAWTKeyStroke(nb, 16367));
            }
            gBindings.put(name, kss);
        }
        return gBindings;
    }

    @Override
    public void saveGlobalShortcutFromConfiguration() {
        ConfigurationService configService = KeybindingsActivator.getConfigService();
        String shortcut = null;
        String shortcut2 = null;
        for (Map.Entry<String, List<AWTKeyStroke>> entry : this.globalBindings.getBindings().entrySet()) {
            String key = entry.getKey();
            List<AWTKeyStroke> kss = entry.getValue();
            String path = CONFIGURATION_PATH;
            path = path + "." + key;
            shortcut = path + ".1";
            shortcut2 = path + ".2";
            configService.setProperty(shortcut, kss.size() > 0 ? kss.get(0) : null);
            configService.setProperty(shortcut2, kss.size() > 1 && kss.get(1) != null ? Integer.valueOf(kss.get(1).getKeyCode()) : null);
        }
    }

    @Override
    public GlobalKeybindingSet getGlobalBindings() {
        return this.globalBindings;
    }
}

