/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.chat;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.EncodedStringInfo;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.MinimalEncoder;
import net.kano.joscar.OscarTools;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;
import org.jetbrains.annotations.Nullable;

public class ChatMsg
implements LiveWritable {
    public static final String CONTENTENCODING_DEFAULT = "binary";
    public static final String CONTENTTYPE_DEFAULT = "text/x-aolrtf";
    public static final String CONTENTTYPE_SECURE = "application/pkcs7-mime";
    private static final int TYPE_CHARSET = 2;
    private static final int TYPE_BODY = 1;
    private static final int TYPE_LANG = 3;
    private static final int TYPE_CONTENT_TYPE = 4;
    private static final int TYPE_CONTENT_ENCODING = 5;
    private final ByteBlock messageData;
    private final Locale language;
    private final String contentType;
    private final String contentEncoding;
    private String charset;

    public static ChatMsg readChatMsg(ByteBlock msgBlock) {
        DefensiveTools.checkNull(msgBlock, "msgBlock");
        ImmutableTlvChain msgChain = TlvTools.readChain(msgBlock);
        String contentType = msgChain.getString(4);
        String contentEncoding = msgChain.getString(5);
        String charset = msgChain.getString(2);
        ByteBlock messageData = msgChain.getLastTlv(1).getData();
        String language = msgChain.getString(3);
        return new ChatMsg(contentType, contentEncoding, charset, messageData, new Locale(language));
    }

    public ChatMsg(String message) {
        this(message, Locale.getDefault());
    }

    public ChatMsg(String message, Locale locale) {
        EncodedStringInfo stringInfo = MinimalEncoder.encodeMinimally(message);
        this.contentType = CONTENTTYPE_DEFAULT;
        this.contentEncoding = CONTENTENCODING_DEFAULT;
        this.charset = stringInfo.getCharset();
        this.messageData = ByteBlock.wrap(stringInfo.getData());
        this.language = locale;
    }

    public ChatMsg(String contentType, String contentEncoding, String charset, ByteBlock messageData, Locale language) {
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
        this.charset = charset;
        this.messageData = messageData;
        this.language = language;
    }

    public final ByteBlock getMessageData() {
        return this.messageData;
    }

    public final String getContentType() {
        return this.contentType;
    }

    public final String getContentEncoding() {
        return this.contentEncoding;
    }

    public final String getCharset() {
        return this.charset;
    }

    public final Locale getLanguage() {
        return this.language;
    }

    @Nullable
    public final String getMessage() {
        if (this.contentType == null || this.contentType.equals(CONTENTTYPE_DEFAULT)) {
            return this.getMessageAsString();
        }
        return null;
    }

    public final String getMessageAsString() {
        return OscarTools.getString(this.messageData, this.charset);
    }

    public void write(OutputStream out) throws IOException {
        MutableTlvChain msgChain = TlvTools.createMutableChain();
        if (this.contentType != null) {
            msgChain.addTlv(Tlv.getStringInstance(4, this.contentType));
        }
        if (this.charset != null) {
            msgChain.addTlv(Tlv.getStringInstance(2, this.charset));
        }
        if (this.language != null) {
            msgChain.addTlv(Tlv.getStringInstance(3, this.language.getLanguage()));
        }
        if (this.contentEncoding != null) {
            msgChain.addTlv(Tlv.getStringInstance(5, this.contentEncoding));
        }
        if (this.messageData != null) {
            msgChain.addTlv(new Tlv(1, this.messageData));
        }
        msgChain.write(out);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ChatMsg: ");
        String msgStr = this.getMessage();
        if (msgStr != null) {
            sb.append(msgStr + ": ");
        }
        sb.append("contentType=" + this.contentType);
        sb.append(", charset=" + this.charset);
        sb.append(", language=" + (this.language != null ? this.language.getLanguage() : null));
        sb.append(", contentEncoding=" + this.contentEncoding);
        sb.append(", msgData: " + this.messageData.getLength() + " bytes");
        return sb.toString();
    }
}

