/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Point;
import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.UINotification;
import net.java.sip.communicator.impl.gui.main.UINotificationGroup;
import net.java.sip.communicator.impl.gui.main.UINotificationManager;
import net.java.sip.communicator.impl.gui.main.call.CallContainer;
import net.java.sip.communicator.impl.gui.main.call.CallDialog;
import net.java.sip.communicator.impl.gui.main.call.CallInterfaceListener;
import net.java.sip.communicator.impl.gui.main.call.CallPanel;
import net.java.sip.communicator.impl.gui.main.call.ChooseCallAccountDialog;
import net.java.sip.communicator.impl.gui.main.call.ChooseCallAccountPopupMenu;
import net.java.sip.communicator.impl.gui.main.call.DesktopSharingFrame;
import net.java.sip.communicator.impl.gui.main.call.FullScreenShareIndicator;
import net.java.sip.communicator.impl.gui.main.call.ReceivedCallDialog;
import net.java.sip.communicator.impl.gui.main.call.ResolveAddressToDisplayNameContactQueryListener;
import net.java.sip.communicator.impl.gui.main.call.SelectScreenDialog;
import net.java.sip.communicator.impl.gui.main.call.SwingCallListener;
import net.java.sip.communicator.impl.gui.main.call.TransferCallDialog;
import net.java.sip.communicator.impl.gui.main.contactlist.TreeContactList;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.MessageDialog;
import net.java.sip.communicator.plugin.desktoputil.UIPhoneUtil;
import net.java.sip.communicator.plugin.desktoputil.transparent.TransparentFrame;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.ExtendedContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIContactDetail;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import net.java.sip.communicator.service.protocol.ConferenceMember;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetAdvancedTelephony;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetCusaxUtils;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingServer;
import net.java.sip.communicator.service.protocol.OperationSetDesktopStreaming;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.OperationSetResourceAwareTelephony;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyConferencing;
import net.java.sip.communicator.service.protocol.OperationSetVideoBridge;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.CallChangeAdapter;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.event.CallEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.service.protocol.media.ProtocolMediaActivator;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.NetworkUtils;
import net.java.sip.communicator.util.account.AccountUtils;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.MediaUseCase;
import org.jitsi.service.neomedia.QualityControl;
import org.jitsi.service.neomedia.QualityPreset;
import org.jitsi.service.neomedia.codec.EncodingConfiguration;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.StringUtils;

public class CallManager {
    private static final Logger logger = Logger.getLogger(CallManager.class);
    private static final String desktopSharingWarningProperty = "net.java.sip.communicator.impl.gui.main.call.SHOW_DESKTOP_SHARING_WARNING";
    private static final String IGNORE_PREFERRED_PROVIDER_PROP = "net.java.sip.communicator.impl.gui.main.call.IGNORE_PREFERRED_PROVIDER_PROP";
    private static final Map<CallConference, CallPanel> callPanels = new HashMap<CallConference, CallPanel>();
    private static Map<Call, UIContactImpl> uiContactCalls;
    private static UINotificationGroup missedCallGroup;

    public static void answerCall(Call call) {
        CallManager.answerCall(call, null, false);
    }

    private static void answerCall(Call call, Call existingCall, boolean video) {
        if (existingCall == null) {
            CallManager.openCallContainerIfNecessary(call);
        }
        new AnswerCallThread(call, existingCall, video).start();
    }

    public static void answerCallInFirstExistingCall(Call call) {
        Iterator<Call> existingCallIter = CallManager.getInProgressCalls().iterator();
        Call existingCall = existingCallIter.hasNext() ? existingCallIter.next() : null;
        CallManager.answerCall(call, existingCall, false);
    }

    public static void mergeExistingCalls(CallConference conference, Collection<Call> calls) {
        new MergeExistingCalls(conference, calls).start();
    }

    public static void answerVideoCall(Call call) {
        CallManager.answerCall(call, null, true);
    }

    public static void hangupCall(Call call) {
        new HangupCallThread(call).start();
    }

    public static void hangupCallPeer(CallPeer peer) {
        new HangupCallThread(peer).start();
    }

    public static void hangupCalls(CallConference conference) {
        new HangupCallThread(conference).start();
    }

    public static void createCall(ProtocolProviderService protocolProvider, String contact) {
        new CreateCallThread(protocolProvider, contact, false).start();
    }

    public static void createCall(ProtocolProviderService protocolProvider, String contact, UIContactImpl uiContact) {
        new CreateCallThread(protocolProvider, null, null, uiContact, contact, null, null, false).start();
    }

    public static void createVideoCall(ProtocolProviderService protocolProvider, String contact) {
        new CreateCallThread(protocolProvider, contact, true).start();
    }

    public static void createVideoCall(ProtocolProviderService protocolProvider, String contact, UIContactImpl uiContact) {
        new CreateCallThread(protocolProvider, null, null, uiContact, contact, null, null, true).start();
    }

    public static void enableLocalVideo(Call call, boolean enable) {
        new EnableLocalVideoThread(call, enable).start();
    }

    public static boolean isLocalVideoEnabled(Call call) {
        OperationSetVideoTelephony telephony = (OperationSetVideoTelephony)call.getProtocolProvider().getOperationSet(OperationSetVideoTelephony.class);
        return telephony != null && telephony.isLocalVideoAllowed(call);
    }

    private static void createDesktopSharing(ProtocolProviderService protocolProvider, String contact, UIContactImpl uiContact) {
        if (!CallManager.showDesktopSharingWarning()) {
            return;
        }
        MediaService mediaService = GuiActivator.getMediaService();
        List desktopDevices = mediaService.getDevices(MediaType.VIDEO, MediaUseCase.DESKTOP);
        int deviceNumber = desktopDevices.size();
        if (deviceNumber == 1) {
            CallManager.createDesktopSharing(protocolProvider, contact, uiContact, (MediaDevice)desktopDevices.get(0), true);
        } else if (deviceNumber > 1) {
            SelectScreenDialog selectDialog = new SelectScreenDialog(desktopDevices);
            selectDialog.setVisible(true);
            if (selectDialog.getSelectedDevice() != null) {
                CallManager.createDesktopSharing(protocolProvider, contact, uiContact, selectDialog.getSelectedDevice(), true);
            }
        }
    }

    private static void createRegionDesktopSharing(ProtocolProviderService protocolProvider, String contact, UIContactImpl uiContact) {
        if (CallManager.showDesktopSharingWarning()) {
            TransparentFrame frame = DesktopSharingFrame.createTransparentFrame(protocolProvider, contact, uiContact, true);
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        }
    }

    public static void createRegionDesktopSharing(ProtocolProviderService protocolProvider, String contact, UIContactImpl uiContact, int x, int y, int width, int height) {
        MediaService mediaService = GuiActivator.getMediaService();
        List desktopDevices = mediaService.getDevices(MediaType.VIDEO, MediaUseCase.DESKTOP);
        int deviceNumber = desktopDevices.size();
        if (deviceNumber > 0) {
            CallManager.createDesktopSharing(protocolProvider, contact, uiContact, mediaService.getMediaDeviceForPartialDesktopStreaming(width, height, x, y), false);
        }
    }

    private static void createDesktopSharing(ProtocolProviderService protocolProvider, String contact, UIContactImpl uiContact, MediaDevice mediaDevice, boolean fullscreen) {
        new CreateDesktopSharingThread(protocolProvider, contact, uiContact, mediaDevice, fullscreen).start();
    }

    public static void enableDesktopSharing(Call call, boolean enable) {
        if (!enable) {
            CallManager.enableDesktopSharing(call, null, enable);
        } else if (CallManager.showDesktopSharingWarning()) {
            MediaService mediaService = GuiActivator.getMediaService();
            List desktopDevices = mediaService.getDevices(MediaType.VIDEO, MediaUseCase.DESKTOP);
            int deviceNumber = desktopDevices.size();
            new FullScreenShareIndicator(call);
            if (deviceNumber == 1) {
                CallManager.enableDesktopSharing(call, null, enable);
            } else if (deviceNumber > 1) {
                SelectScreenDialog selectDialog = new SelectScreenDialog(desktopDevices);
                selectDialog.setVisible(true);
                if (selectDialog.getSelectedDevice() != null) {
                    CallManager.enableDesktopSharing(call, selectDialog.getSelectedDevice(), enable);
                }
            }
        }
        CallManager.enableDesktopRemoteControl((CallPeer)call.getCallPeers().next(), false);
    }

    public static void enableRegionDesktopSharing(Call call, boolean enable) {
        if (!enable) {
            CallManager.enableDesktopSharing(call, null, enable);
        } else if (CallManager.showDesktopSharingWarning()) {
            TransparentFrame frame = DesktopSharingFrame.createTransparentFrame(call, true);
            frame.setVisible(true);
        }
    }

    public static void enableRegionDesktopSharing(Call call, int x, int y, int width, int height) {
        boolean succeed;
        MediaService mediaService = GuiActivator.getMediaService();
        List desktopDevices = mediaService.getDevices(MediaType.VIDEO, MediaUseCase.DESKTOP);
        int deviceNumber = desktopDevices.size();
        if (deviceNumber > 0 && (succeed = CallManager.enableDesktopSharing(call, mediaService.getMediaDeviceForPartialDesktopStreaming(width, height, x, y), true))) {
            TransparentFrame frame = DesktopSharingFrame.createTransparentFrame(call, false);
            frame.setVisible(true);
        }
        CallManager.enableDesktopRemoteControl((CallPeer)call.getCallPeers().next(), false);
    }

    private static boolean enableDesktopSharing(Call call, MediaDevice mediaDevice, boolean enable) {
        OperationSetDesktopStreaming desktopOpSet = (OperationSetDesktopStreaming)call.getProtocolProvider().getOperationSet(OperationSetDesktopStreaming.class);
        boolean enableSucceeded = false;
        if (desktopOpSet != null) {
            if (enable && CallManager.isLocalVideoEnabled(call)) {
                CallManager.getActiveCallContainer(call).setVideoButtonSelected(false);
            }
            try {
                if (mediaDevice != null) {
                    desktopOpSet.setLocalVideoAllowed(call, mediaDevice, enable);
                } else {
                    desktopOpSet.setLocalVideoAllowed(call, enable);
                }
                enableSucceeded = true;
            }
            catch (OperationFailedException ex) {
                logger.error((Object)"Failed to toggle the streaming of local video.", (Throwable)ex);
            }
        }
        return enable && enableSucceeded;
    }

    public static boolean isDesktopSharingEnabled(Call call) {
        OperationSetDesktopStreaming desktopOpSet = (OperationSetDesktopStreaming)call.getProtocolProvider().getOperationSet(OperationSetDesktopStreaming.class);
        return desktopOpSet != null && desktopOpSet.isLocalVideoAllowed(call);
    }

    public static boolean isRegionDesktopSharingEnabled(Call call) {
        OperationSetDesktopStreaming desktopOpSet = (OperationSetDesktopStreaming)call.getProtocolProvider().getOperationSet(OperationSetDesktopStreaming.class);
        return desktopOpSet != null && desktopOpSet.isPartialStreaming(call);
    }

    public static void enableDesktopRemoteControl(CallPeer callPeer, boolean isEnable) {
        OperationSetDesktopSharingServer sharingOpSet = (OperationSetDesktopSharingServer)callPeer.getProtocolProvider().getOperationSet(OperationSetDesktopSharingServer.class);
        if (sharingOpSet == null) {
            return;
        }
        if (isEnable) {
            sharingOpSet.enableRemoteControl(callPeer);
        } else {
            sharingOpSet.disableRemoteControl(callPeer);
        }
    }

    public static void createCall(String callString, JComponent c) {
        CallManager.createCall(callString, c, null);
    }

    public static void createCall(String callString, JComponent c, CallInterfaceListener l) {
        List<ProtocolProviderService> telephonyProviders;
        callString = callString.trim();
        if (ConfigurationUtils.isNormalizePhoneNumber() && !NetworkUtils.isValidIPAddress((String)callString)) {
            callString = GuiActivator.getPhoneNumberI18nService().normalize(callString);
        }
        if ((telephonyProviders = CallManager.getTelephonyProviders()).size() == 1) {
            CallManager.createCall(telephonyProviders.get(0), callString);
            if (l != null) {
                l.callInterfaceStarted();
            }
        } else if (telephonyProviders.size() > 1) {
            if (c == null) {
                ProtocolProviderService preferredTelephonyProvider = null;
                for (ProtocolProviderService telephonyProvider : telephonyProviders) {
                    try {
                        OperationSetPresence presenceOpSet = (OperationSetPresence)telephonyProvider.getOperationSet(OperationSetPresence.class);
                        if (presenceOpSet == null || presenceOpSet.findContactByID(callString) == null) continue;
                        preferredTelephonyProvider = telephonyProvider;
                        break;
                    }
                    catch (Throwable t) {
                        if (!(t instanceof ThreadDeath)) continue;
                        throw (ThreadDeath)t;
                    }
                }
                if (preferredTelephonyProvider == null) {
                    preferredTelephonyProvider = telephonyProviders.get(0);
                }
                CallManager.createCall(preferredTelephonyProvider, callString);
                if (l != null) {
                    l.callInterfaceStarted();
                }
            } else {
                ChooseCallAccountPopupMenu chooseAccountDialog = new ChooseCallAccountPopupMenu(c, callString, telephonyProviders, l);
                chooseAccountDialog.setLocation(c.getLocation());
                chooseAccountDialog.showPopupMenu();
            }
        } else {
            ResourceManagementService resources = GuiActivator.getResources();
            new ErrorDialog(null, resources.getI18NString("service.gui.WARNING"), resources.getI18NString("service.gui.NO_ONLINE_TELEPHONY_ACCOUNT")).showDialog();
        }
    }

    public static void createConferenceCall(String[] callees, ProtocolProviderService protocolProvider) {
        HashMap<ProtocolProviderService, List<String>> crossProtocolCallees = new HashMap<ProtocolProviderService, List<String>>();
        crossProtocolCallees.put(protocolProvider, Arrays.asList(callees));
        CallManager.createConferenceCall(crossProtocolCallees);
    }

    public static void inviteToConferenceCall(String[] callees, Call call) {
        HashMap<ProtocolProviderService, List<String>> crossProtocolCallees = new HashMap<ProtocolProviderService, List<String>>();
        crossProtocolCallees.put(call.getProtocolProvider(), Arrays.asList(callees));
        CallManager.inviteToConferenceCall(crossProtocolCallees, call);
    }

    public static void inviteToConferenceCall(Map<ProtocolProviderService, List<String>> callees, Call call) {
        new InviteToConferenceCallThread(callees, call).start();
    }

    public static void inviteToConferenceCall(Map<ProtocolProviderService, List<String>> callees, CallConference conference) {
        List calls;
        Call call = null;
        if (conference != null && !(calls = conference.getCalls()).isEmpty()) {
            call = (Call)calls.get(0);
        }
        new InviteToConferenceCallThread(callees, call).start();
    }

    public static void createConferenceCall(Map<ProtocolProviderService, List<String>> callees) {
        new InviteToConferenceCallThread(callees, null).start();
    }

    public static void createJitsiVideobridgeConfCall(ProtocolProviderService callProvider, String[] callees) {
        new InviteToConferenceBridgeThread(callProvider, callees, null).start();
    }

    public static void inviteToJitsiVideobridgeConfCall(String[] callees, Call call) {
        new InviteToConferenceBridgeThread(call.getProtocolProvider(), callees, call).start();
    }

    public static void putOnHold(CallPeer callPeer, boolean isOnHold) {
        new PutOnHoldCallPeerThread(callPeer, isOnHold).start();
    }

    public static void transferCall(CallPeer peer, CallPeer target) {
        OperationSetAdvancedTelephony telephony = (OperationSetAdvancedTelephony)peer.getCall().getProtocolProvider().getOperationSet(OperationSetAdvancedTelephony.class);
        if (telephony != null) {
            try {
                telephony.transfer(peer, target);
            }
            catch (OperationFailedException ex) {
                logger.error((Object)("Failed to transfer " + peer.getAddress() + " to " + target), (Throwable)ex);
            }
        }
    }

    public static void transferCall(CallPeer peer, String target) {
        OperationSetAdvancedTelephony telephony = (OperationSetAdvancedTelephony)peer.getCall().getProtocolProvider().getOperationSet(OperationSetAdvancedTelephony.class);
        if (telephony != null) {
            try {
                telephony.transfer(peer, target);
            }
            catch (OperationFailedException ex) {
                logger.error((Object)("Failed to transfer " + peer.getAddress() + " to " + target), (Throwable)ex);
            }
        }
    }

    private static void closeCallContainerIfNotNecessary(CallConference callConference) {
        CallPanel callPanel = callPanels.get(callConference);
        if (callPanel != null) {
            CallManager.closeCallContainerIfNotNecessary(callConference, callPanel.isCloseWaitAfterHangup());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeCallContainerIfNotNecessary(final CallConference callConference, final boolean wait) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CallManager.closeCallContainerIfNotNecessary(callConference, wait);
                }
            });
            return;
        }
        Iterator<Map.Entry<CallConference, CallPanel>> entryIter = callPanels.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry<CallConference, CallPanel> entry = entryIter.next();
            CallConference aConference = entry.getKey();
            boolean notNecessary = aConference.isEnded();
            if (!notNecessary) continue;
            CallPanel aCallPanel = entry.getValue();
            CallContainer window = aCallPanel.getCallWindow();
            try {
                window.close(aCallPanel, wait && aConference == callConference);
            }
            finally {
                Map<CallConference, CallPanel> map = callPanels;
                synchronized (map) {
                    entryIter.remove();
                }
                aCallPanel.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CallPanel openCallContainerIfNecessary(Call call) {
        CallManager.assertIsEventDispatchingThread();
        CallConference conference = call.getConference();
        CallPanel callPanel = CallManager.findCallPanel(conference);
        if (callPanel == null) {
            CallContainer callContainer = GuiActivator.getUIService().getSingleWindowContainer();
            if (callContainer == null) {
                callContainer = new CallDialog();
            }
            callPanel = new CallPanel(conference, callContainer);
            callContainer.addCallPanel(callPanel);
            Map<CallConference, CallPanel> map = callPanels;
            synchronized (map) {
                callPanels.put(conference, callPanel);
            }
        }
        return callPanel;
    }

    public static List<ProtocolProviderService> getTelephonyProviders() {
        return AccountUtils.getRegisteredProviders(OperationSetBasicTelephony.class);
    }

    public static List<ProtocolProviderService> getTelephonyConferencingProviders() {
        return AccountUtils.getRegisteredProviders(OperationSetTelephonyConferencing.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Call> getActiveCalls() {
        CallConference[] conferences;
        Map<CallConference, CallPanel> map = callPanels;
        synchronized (map) {
            Set<CallConference> keySet = callPanels.keySet();
            conferences = keySet.toArray(new CallConference[keySet.size()]);
        }
        ArrayList<Call> calls = new ArrayList<Call>();
        for (CallConference conference : conferences) {
            for (Call call : conference.getCalls()) {
                if (call.getCallState() != CallState.CALL_IN_PROGRESS) continue;
                calls.add(call);
            }
        }
        return calls;
    }

    public static Collection<Call> getInProgressCalls() {
        return CallManager.getActiveCalls();
    }

    public static CallPanel getActiveCallContainer(Call call) {
        return CallManager.findCallPanel(call.getConference());
    }

    public static String getPeerDisplayName(CallPeer peer, DetailsResolveListener listener) {
        String resolvedName;
        String imppAddress;
        String displayName = null;
        UIContactImpl uiContact = CallManager.getCallUIContact(peer.getCall());
        if (uiContact != null) {
            Contact contact;
            if (uiContact.getDescriptor() instanceof SourceContact && (contact = CallManager.getPeerCusaxContact(peer, (SourceContact)uiContact.getDescriptor())) != null) {
                displayName = contact.getDisplayName();
            }
            if (StringUtils.isNullOrEmpty(displayName, (boolean)true)) {
                displayName = uiContact.getDisplayName();
            }
        }
        if (StringUtils.isNullOrEmpty(displayName, (boolean)true) && peer.getContact() != null) {
            displayName = peer.getContact().getDisplayName();
        }
        if (StringUtils.isNullOrEmpty(displayName, (boolean)true) && !StringUtils.isNullOrEmpty((String)(imppAddress = peer.getAlternativeIMPPAddress()))) {
            int protocolPartIndex = imppAddress.indexOf(":");
            imppAddress = protocolPartIndex >= 0 ? imppAddress.substring(protocolPartIndex + 1) : imppAddress;
            List cusaxProviders = AccountUtils.getRegisteredProviders(OperationSetCusaxUtils.class);
            if (cusaxProviders != null && cusaxProviders.size() > 0) {
                Contact contact;
                Iterator iter = cusaxProviders.iterator();
                while (iter.hasNext() && StringUtils.isNullOrEmpty((String)(displayName = (contact = CallManager.getPeerContact(peer, (ProtocolProviderService)iter.next(), imppAddress)) != null ? contact.getDisplayName() : null), (boolean)true)) {
                }
            } else {
                MetaContact metaContact = CallManager.getPeerMetaContact(peer, imppAddress);
                String string = displayName = metaContact != null ? metaContact.getDisplayName() : null;
            }
        }
        if (StringUtils.isNullOrEmpty((String)displayName, (boolean)true) && (resolvedName = CallManager.queryContactSource(displayName = !StringUtils.isNullOrEmpty((String)peer.getDisplayName(), (boolean)true) ? peer.getDisplayName() : peer.getAddress(), listener)) != null) {
            displayName = resolvedName;
        }
        return displayName;
    }

    public static byte[] getPeerImage(CallPeer peer) {
        String imppAddress;
        UIContactImpl uiContact;
        byte[] image = null;
        if (peer.getContact() != null) {
            image = CallManager.getContactImage(peer.getContact());
        }
        if ((image == null || image.length == 0) && (uiContact = CallManager.getCallUIContact(peer.getCall())) != null) {
            if (uiContact.getDescriptor() instanceof SourceContact && ((SourceContact)uiContact.getDescriptor()).isDefaultImage()) {
                Contact contact = CallManager.getPeerCusaxContact(peer, (SourceContact)uiContact.getDescriptor());
                if (contact != null) {
                    image = contact.getImage();
                }
            } else {
                image = uiContact.getAvatar();
            }
        }
        if (!(image != null && image.length != 0 || StringUtils.isNullOrEmpty((String)(imppAddress = peer.getAlternativeIMPPAddress())))) {
            int protocolPartIndex = imppAddress.indexOf(":");
            imppAddress = protocolPartIndex >= 0 ? imppAddress.substring(protocolPartIndex + 1) : imppAddress;
            List cusaxProviders = AccountUtils.getRegisteredProviders(OperationSetCusaxUtils.class);
            if (cusaxProviders != null && cusaxProviders.size() > 0) {
                Contact contact;
                Iterator iter = cusaxProviders.iterator();
                while (iter.hasNext() && (image = (contact = CallManager.getPeerContact(peer, (ProtocolProviderService)iter.next(), imppAddress)) != null ? CallManager.getContactImage(contact) : null) == null) {
                }
            } else {
                MetaContact metaContact = CallManager.getPeerMetaContact(peer, imppAddress);
                byte[] byArray = image = metaContact != null ? metaContact.getAvatar() : null;
            }
        }
        if ((image == null || image.length == 0) && peer.getImage() != null) {
            image = peer.getImage();
        }
        return image;
    }

    public static Contact getIMCapableCusaxContact(CallPeer peer) {
        String imppAddress;
        UIContactImpl uiContact = CallManager.getCallUIContact(peer.getCall());
        if (uiContact != null) {
            Contact contact;
            if (uiContact.getDescriptor() instanceof MetaContact) {
                MetaContact metaContact = (MetaContact)uiContact.getDescriptor();
                Iterator iter = metaContact.getContacts();
                while (iter.hasNext()) {
                    Contact contact2 = (Contact)iter.next();
                    if (contact2.getProtocolProvider().getOperationSet(OperationSetBasicInstantMessaging.class) == null) continue;
                    return contact2;
                }
            } else if (uiContact.getDescriptor() instanceof SourceContact && (contact = CallManager.getPeerCusaxContact(peer, (SourceContact)uiContact.getDescriptor())) != null && contact.getProtocolProvider().getOperationSet(OperationSetBasicInstantMessaging.class) != null) {
                return contact;
            }
        }
        if (!StringUtils.isNullOrEmpty((String)(imppAddress = peer.getAlternativeIMPPAddress()))) {
            int protocolPartIndex = imppAddress.indexOf(":");
            imppAddress = protocolPartIndex >= 0 ? imppAddress.substring(protocolPartIndex + 1) : imppAddress;
            List cusaxProviders = AccountUtils.getRegisteredProviders(OperationSetCusaxUtils.class);
            if (cusaxProviders != null && cusaxProviders.size() > 0) {
                for (ProtocolProviderService cusaxProvider : cusaxProviders) {
                    Contact contact = CallManager.getPeerContact(peer, cusaxProvider, imppAddress);
                    if (contact == null || cusaxProvider.getOperationSet(OperationSetBasicInstantMessaging.class) == null) continue;
                    return contact;
                }
            }
        }
        return null;
    }

    private static Contact getPeerCusaxContact(CallPeer peer, SourceContact sourceContact) {
        OperationSetPersistentPresence opSetPersistentPresence;
        ProtocolProviderService pps;
        OperationSetCusaxUtils cusaxOpSet;
        ProtocolProviderService linkedCusaxProvider = null;
        for (ContactDetail detail : sourceContact.getContactDetails()) {
            OperationSetCusaxUtils cusaxOpSet2;
            ProtocolProviderService pps2 = detail.getPreferredProtocolProvider(OperationSetBasicTelephony.class);
            if (pps2 == null || (cusaxOpSet2 = (OperationSetCusaxUtils)pps2.getOperationSet(OperationSetCusaxUtils.class)) == null) continue;
            linkedCusaxProvider = cusaxOpSet2.getLinkedCusaxProvider();
            break;
        }
        if (linkedCusaxProvider == null && (cusaxOpSet = (OperationSetCusaxUtils)(pps = peer.getProtocolProvider()).getOperationSet(OperationSetCusaxUtils.class)) != null) {
            linkedCusaxProvider = cusaxOpSet.getLinkedCusaxProvider();
        }
        if (linkedCusaxProvider != null && (opSetPersistentPresence = (OperationSetPersistentPresence)linkedCusaxProvider.getOperationSet(OperationSetPersistentPresence.class)) != null) {
            String peerAddress = peer.getAddress();
            int index = peerAddress.indexOf("@");
            String peerUserID = index > -1 ? peerAddress.substring(0, index) : peerAddress;
            String peerUserIDQ = Pattern.quote(peerUserID);
            Pattern pattern = Pattern.compile("^(" + peerUserIDQ + "|" + peerUserIDQ + "@.*)$");
            return CallManager.findContactByPeer(peerUserID, pattern, opSetPersistentPresence.getServerStoredContactListRoot(), (OperationSetCusaxUtils)linkedCusaxProvider.getOperationSet(OperationSetCusaxUtils.class));
        }
        return null;
    }

    private static Contact findContactByPeer(String peerUserID, Pattern searchPattern, ContactGroup parent, OperationSetCusaxUtils cusaxOpSet) {
        Iterator contactIterator = parent.contacts();
        while (contactIterator.hasNext()) {
            Contact contact = (Contact)contactIterator.next();
            if (!searchPattern.matcher(contact.getAddress()).find() && !cusaxOpSet.doesDetailBelong(contact, peerUserID)) continue;
            return contact;
        }
        Iterator groupsIterator = parent.subgroups();
        while (groupsIterator.hasNext()) {
            ContactGroup gr = (ContactGroup)groupsIterator.next();
            Contact contact = CallManager.findContactByPeer(peerUserID, searchPattern, gr, cusaxOpSet);
            if (contact == null) continue;
            return contact;
        }
        return null;
    }

    private static byte[] getContactImage(Contact contact) {
        MetaContact metaContact = GuiActivator.getContactListService().findMetaContactByContact(contact);
        if (metaContact != null) {
            return metaContact.getAvatar();
        }
        return null;
    }

    private static Contact getPeerContact(CallPeer callPeer, ProtocolProviderService cusaxProvider, String alternativePeerAddress) {
        OperationSetPresence presenceOpSet = (OperationSetPresence)cusaxProvider.getOperationSet(OperationSetPresence.class);
        if (presenceOpSet == null) {
            return null;
        }
        Contact contact = presenceOpSet.findContactByID(alternativePeerAddress);
        if (contact == null) {
            return null;
        }
        OperationSetCusaxUtils cusaxOpSet = (OperationSetCusaxUtils)cusaxProvider.getOperationSet(OperationSetCusaxUtils.class);
        if (cusaxOpSet != null && cusaxOpSet.doesDetailBelong(contact, callPeer.getAddress())) {
            return contact;
        }
        return null;
    }

    public static MetaContact getPeerMetaContact(CallPeer peer) {
        String imppAddress;
        if (peer == null) {
            return null;
        }
        if (peer.getContact() != null) {
            return GuiActivator.getContactListService().findMetaContactByContact(peer.getContact());
        }
        UIContactImpl uiContact = CallManager.getCallUIContact(peer.getCall());
        if (uiContact != null) {
            Contact contact;
            if (uiContact.getDescriptor() instanceof MetaContact) {
                return (MetaContact)uiContact.getDescriptor();
            }
            if (uiContact.getDescriptor() instanceof SourceContact && (contact = CallManager.getPeerCusaxContact(peer, (SourceContact)uiContact.getDescriptor())) != null) {
                return GuiActivator.getContactListService().findMetaContactByContact(contact);
            }
        }
        if (!StringUtils.isNullOrEmpty((String)(imppAddress = peer.getAlternativeIMPPAddress()))) {
            int protocolPartIndex = imppAddress.indexOf(":");
            imppAddress = protocolPartIndex >= 0 ? imppAddress.substring(protocolPartIndex + 1) : imppAddress;
            List cusaxProviders = AccountUtils.getRegisteredProviders(OperationSetCusaxUtils.class);
            if (cusaxProviders != null && cusaxProviders.size() > 0) {
                Iterator iter = cusaxProviders.iterator();
                while (iter.hasNext()) {
                    Contact contact = CallManager.getPeerContact(peer, (ProtocolProviderService)iter.next(), imppAddress);
                    MetaContact res = GuiActivator.getContactListService().findMetaContactByContact(contact);
                    if (res == null) continue;
                    return res;
                }
            } else {
                return CallManager.getPeerMetaContact(peer, imppAddress);
            }
        }
        return null;
    }

    private static MetaContact getPeerMetaContact(CallPeer callPeer, String alternativePeerAddress) {
        Iterator metaContacts = GuiActivator.getContactListService().findAllMetaContactsForAddress(alternativePeerAddress);
        while (metaContacts.hasNext()) {
            MetaContact metaContact = (MetaContact)metaContacts.next();
            UIPhoneUtil phoneUtil = UIPhoneUtil.getPhoneUtil((MetaContact)metaContact);
            List additionalNumbers = phoneUtil.getAdditionalNumbers();
            if (additionalNumbers == null || additionalNumbers.size() > 0) continue;
            Iterator numbersIter = additionalNumbers.iterator();
            while (numbersIter.hasNext()) {
                if (!((UIContactDetail)numbersIter.next()).getAddress().equals(callPeer.getAddress())) continue;
                return metaContact;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openCallTransferDialog(CallPeer peer) {
        final TransferCallDialog dialog = new TransferCallDialog(peer);
        final Call call = peer.getCall();
        CallChangeAdapter callChangeListener = new CallChangeAdapter(){

            public void callStateChanged(CallChangeEvent evt) {
                if (!evt.getEventType().equals("CallState")) {
                    return;
                }
                if (!CallState.CALL_IN_PROGRESS.equals(call.getCallState())) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            }
        };
        call.addCallChangeListener((CallChangeListener)callChangeListener);
        try {
            dialog.pack();
            dialog.setVisible(true);
        }
        finally {
            call.removeCallChangeListener((CallChangeListener)callChangeListener);
        }
    }

    public static boolean isVideoQualityPresetSupported(CallPeer callPeer) {
        ProtocolProviderService provider = callPeer.getProtocolProvider();
        OperationSetVideoTelephony videoOpSet = (OperationSetVideoTelephony)provider.getOperationSet(OperationSetVideoTelephony.class);
        if (videoOpSet == null) {
            return false;
        }
        return videoOpSet.getQualityControl(callPeer) != null;
    }

    public static void setVideoQualityPreset(CallPeer callPeer, final QualityPreset qualityPreset) {
        ProtocolProviderService provider = callPeer.getProtocolProvider();
        OperationSetVideoTelephony videoOpSet = (OperationSetVideoTelephony)provider.getOperationSet(OperationSetVideoTelephony.class);
        if (videoOpSet == null) {
            return;
        }
        final QualityControl qualityControl = videoOpSet.getQualityControl(callPeer);
        if (qualityControl != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        qualityControl.setPreferredRemoteSendMaxPreset(qualityPreset);
                    }
                    catch (Exception e) {
                        logger.info((Object)"Unable to change video quality.", (Throwable)e);
                        ResourceManagementService resources = GuiActivator.getResources();
                        new ErrorDialog(null, resources.getI18NString("service.gui.WARNING"), resources.getI18NString("service.gui.UNABLE_TO_CHANGE_VIDEO_QUALITY"), (Throwable)e).showDialog();
                    }
                }
            }).start();
        }
    }

    public static boolean isVideoStreaming(Call call) {
        return CallManager.isVideoStreaming(call.getConference());
    }

    public static boolean isVideoStreaming(CallConference conference) {
        for (Call call : conference.getCalls()) {
            OperationSetVideoTelephony videoTelephony = (OperationSetVideoTelephony)call.getProtocolProvider().getOperationSet(OperationSetVideoTelephony.class);
            if (videoTelephony == null) continue;
            if (videoTelephony.isLocalVideoStreaming(call)) {
                return true;
            }
            Iterator callPeers = call.getCallPeers();
            while (callPeers.hasNext()) {
                List remoteVideos = videoTelephony.getVisualComponents((CallPeer)callPeers.next());
                if (remoteVideos == null || remoteVideos.size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean addressesAreEqual(String a, String b) {
        String bService;
        String bUserID;
        String aService;
        String aUserID;
        int bProtocolIndex;
        if (a.equals(b)) {
            return true;
        }
        int aProtocolIndex = a.indexOf(58);
        if (aProtocolIndex != -1) {
            a = a.substring(aProtocolIndex + 1);
        }
        if ((bProtocolIndex = b.indexOf(58)) != -1) {
            b = b.substring(bProtocolIndex + 1);
        }
        if (a.equals(b)) {
            return true;
        }
        int aServiceBegin = a.indexOf(64, aProtocolIndex);
        if (aServiceBegin != -1) {
            int aResourceBegin;
            aUserID = a.substring(0, aServiceBegin);
            aService = (aResourceBegin = a.indexOf(47, ++aServiceBegin)) != -1 ? a.substring(aServiceBegin, aResourceBegin) : a.substring(aServiceBegin);
        } else {
            aUserID = a;
            aService = null;
        }
        int bServiceBegin = b.indexOf(64, bProtocolIndex);
        if (bServiceBegin != -1) {
            int bResourceBegin;
            bUserID = b.substring(0, bServiceBegin);
            bService = (bResourceBegin = b.indexOf(47, ++bServiceBegin)) != -1 ? b.substring(bServiceBegin, bResourceBegin) : b.substring(bServiceBegin);
        } else {
            bUserID = b;
            bService = null;
        }
        boolean userIDsAreEqual = aUserID == null || aUserID.length() < 1 ? bUserID == null || bUserID.length() < 1 : aUserID.equals(bUserID);
        if (!userIDsAreEqual) {
            return false;
        }
        boolean servicesAreEqual = aService == null || aService.length() < 1 || bService == null || bService.length() < 1 ? true : aService.equals(bService);
        return servicesAreEqual;
    }

    public static boolean isLocalUser(ConferenceMember conferenceMember) {
        String localUserAddress = conferenceMember.getConferenceFocusCallPeer().getProtocolProvider().getAccountID().getAccountAddress();
        return CallManager.addressesAreEqual(conferenceMember.getAddress(), localUserAddress);
    }

    private static void addMissedCallNotification(String peerName, long callTime) {
        if (missedCallGroup == null) {
            missedCallGroup = new UINotificationGroup("MissedCalls", GuiActivator.getResources().getI18NString("service.gui.MISSED_CALLS_TOOL_TIP"));
        }
        UINotificationManager.addNotification(new UINotification(peerName, callTime, missedCallGroup));
    }

    private static List<MediaFormat> getAudioFormats(MediaDevice device, ProtocolProviderService protocolProvider) {
        List formats;
        ArrayList<MediaFormat> res = new ArrayList<MediaFormat>();
        Map accountProperties = protocolProvider.getAccountID().getAccountProperties();
        String overrideEncodings = (String)accountProperties.get("OVERRIDE_ENCODINGS");
        if (Boolean.parseBoolean(overrideEncodings)) {
            EncodingConfiguration encodingConfiguration = ProtocolMediaActivator.getMediaService().createEmptyEncodingConfiguration();
            encodingConfiguration.loadProperties(accountProperties, "Encodings");
            formats = device.getSupportedFormats(null, null, encodingConfiguration);
        } else {
            formats = device.getSupportedFormats();
        }
        for (MediaFormat format : formats) {
            if (format.getEncoding().equals("telephone-event")) continue;
            res.add(format);
        }
        return res;
    }

    private static void internalCallVideo(ProtocolProviderService protocolProvider, Contact contact, UIContactImpl uiContact, String stringContact) throws OperationFailedException, ParseException {
        OperationSetVideoTelephony telephony = (OperationSetVideoTelephony)protocolProvider.getOperationSet(OperationSetVideoTelephony.class);
        Call createdCall = null;
        if (telephony != null) {
            if (contact != null) {
                createdCall = telephony.createVideoCall(contact);
            } else if (stringContact != null) {
                createdCall = telephony.createVideoCall(stringContact);
            }
        }
        if (uiContact != null && createdCall != null) {
            CallManager.addUIContactCall(uiContact, createdCall);
        }
    }

    private static void internalCall(ProtocolProviderService protocolProvider, Contact contact, String stringContact, ContactResource contactResource, UIContactImpl uiContact) throws OperationFailedException, ParseException {
        OperationSetBasicTelephony telephony = (OperationSetBasicTelephony)protocolProvider.getOperationSet(OperationSetBasicTelephony.class);
        OperationSetResourceAwareTelephony resourceTelephony = (OperationSetResourceAwareTelephony)protocolProvider.getOperationSet(OperationSetResourceAwareTelephony.class);
        Call createdCall = null;
        if (resourceTelephony != null && contactResource != null) {
            if (contact != null) {
                createdCall = resourceTelephony.createCall(contact, contactResource);
            } else if (!StringUtils.isNullOrEmpty((String)stringContact)) {
                createdCall = resourceTelephony.createCall(stringContact, contactResource.getResourceName());
            }
        } else if (telephony != null) {
            if (contact != null) {
                createdCall = telephony.createCall(contact);
            } else if (!StringUtils.isNullOrEmpty((String)stringContact)) {
                createdCall = telephony.createCall(stringContact);
            }
        }
        if (uiContact != null && createdCall != null) {
            CallManager.addUIContactCall(uiContact, createdCall);
        }
    }

    private static void internalCall(ProtocolProviderService protocolProvider, ConferenceDescription conferenceDescription, ChatRoom chatRoom) throws OperationFailedException {
        OperationSetBasicTelephony telephony = (OperationSetBasicTelephony)protocolProvider.getOperationSet(OperationSetBasicTelephony.class);
        if (telephony != null) {
            telephony.createCall(conferenceDescription, chatRoom);
        }
    }

    public static UIContactImpl getCallUIContact(Call call) {
        if (uiContactCalls != null) {
            return uiContactCalls.get(call);
        }
        return null;
    }

    private static void addUIContactCall(UIContactImpl uiContact, Call call) {
        if (uiContactCalls == null) {
            uiContactCalls = new WeakHashMap<Call, UIContactImpl>();
        }
        uiContactCalls.put(call, uiContact);
    }

    private static boolean showDesktopSharingWarning() {
        Boolean isWarningEnabled = GuiActivator.getConfigurationService().getBoolean(desktopSharingWarningProperty, true);
        if (isWarningEnabled.booleanValue()) {
            ResourceManagementService resources = GuiActivator.getResources();
            MessageDialog warningDialog = new MessageDialog(null, resources.getI18NString("service.gui.WARNING"), resources.getI18NString("service.gui.DESKTOP_SHARING_WARNING"), true);
            switch (warningDialog.showDialog()) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    GuiActivator.getConfigurationService().setProperty(desktopSharingWarningProperty, (Object)false);
                    return true;
                }
            }
        }
        return true;
    }

    private static void normalizePhoneNumbers(String[] callees) {
        for (int i = 0; i < callees.length; ++i) {
            callees[i] = GuiActivator.getPhoneNumberI18nService().normalize(callees[i]);
        }
    }

    public static void assertIsEventDispatchingThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("The methon can be called only on the AWT event dispatching thread.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CallPanel findCallPanel(CallConference conference) {
        Map<CallConference, CallPanel> map = callPanels;
        synchronized (map) {
            return callPanels.get(conference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forwardCallEventToCallPanels(CallEvent ev) {
        CallManager.assertIsEventDispatchingThread();
        CallPanel[] callPanelArray = callPanels;
        synchronized (callPanels) {
            Collection<CallPanel> values = callPanels.values();
            CallPanel[] callPanels = values.toArray(new CallPanel[values.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (CallPanel callPanel : callPanels) {
                try {
                    callPanel.onCallEvent(ev);
                }
                catch (Exception ex) {
                    logger.error((Object)"A CallPanel failed to handle a CallEvent", (Throwable)ex);
                }
            }
            return;
        }
    }

    static void createCall(Class<? extends OperationSet> opSetClass, ProtocolProviderService protocolProviderService, String contact) {
        CallManager.createCall(opSetClass, protocolProviderService, contact, null);
    }

    static void createCall(Class<? extends OperationSet> opSetClass, ProtocolProviderService protocolProviderService, String contact, UIContactImpl uiContact) {
        if (opSetClass.equals(OperationSetBasicTelephony.class)) {
            CallManager.createCall(protocolProviderService, contact, uiContact);
        } else if (opSetClass.equals(OperationSetVideoTelephony.class)) {
            CallManager.createVideoCall(protocolProviderService, contact, uiContact);
        } else if (opSetClass.equals(OperationSetDesktopStreaming.class)) {
            CallManager.createDesktopSharing(protocolProviderService, contact, uiContact);
        }
    }

    public static void call(MetaContact metaContact, boolean isVideo, boolean isDesktop, boolean shareRegion) {
        Contact contact = metaContact.getDefaultContact(CallManager.getOperationSetForCall(isVideo, isDesktop));
        CallManager.call(contact, isVideo, isDesktop, shareRegion);
    }

    public static void call(Contact contact, ContactResource contactResource, boolean isVideo, boolean isDesktop, boolean shareRegion) {
        if (isDesktop) {
            if (shareRegion) {
                CallManager.createRegionDesktopSharing(contact.getProtocolProvider(), contact.getAddress(), null);
            } else {
                CallManager.createDesktopSharing(contact.getProtocolProvider(), contact.getAddress(), null);
            }
        } else {
            new CreateCallThread(contact.getProtocolProvider(), contact, contactResource, isVideo).start();
        }
    }

    public static void call(ProtocolProviderService protocolProvider, ConferenceDescription conferenceDescription, ChatRoom chatRoom) {
        new CreateCallThread(protocolProvider, conferenceDescription, chatRoom).start();
    }

    public static void call(Contact contact, boolean isVideo, boolean isDesktop, boolean shareRegion) {
        if (isDesktop) {
            if (shareRegion) {
                CallManager.createRegionDesktopSharing(contact.getProtocolProvider(), contact.getAddress(), null);
            } else {
                CallManager.createDesktopSharing(contact.getProtocolProvider(), contact.getAddress(), null);
            }
        } else {
            new CreateCallThread(contact.getProtocolProvider(), contact, null, isVideo).start();
        }
    }

    public static void call(String phone, boolean isVideo, boolean isDesktop, boolean shareRegion) {
        CallManager.call(phone, null, isVideo, isDesktop, shareRegion);
    }

    public static void call(final String phone, final UIContactImpl uiContact, boolean isVideo, boolean isDesktop, final boolean shareRegion) {
        List<ProtocolProviderService> providers = CallManager.getTelephonyProviders();
        if (providers.size() > 1) {
            ChooseCallAccountDialog chooseAccount = new ChooseCallAccountDialog(phone, CallManager.getOperationSetForCall(isVideo, isDesktop), providers){

                @Override
                public void callButtonPressed() {
                    if (shareRegion) {
                        CallManager.createRegionDesktopSharing(this.getSelectedProvider(), phone, uiContact);
                    } else {
                        super.callButtonPressed();
                    }
                }
            };
            chooseAccount.setUIContact(uiContact);
            chooseAccount.setVisible(true);
        } else {
            CallManager.createCall(providers.get(0), phone, uiContact);
        }
    }

    private static Class<? extends OperationSet> getOperationSetForCall(boolean isVideo, boolean isDesktop) {
        if (isVideo) {
            if (isDesktop) {
                return OperationSetDesktopStreaming.class;
            }
            return OperationSetVideoTelephony.class;
        }
        return OperationSetBasicTelephony.class;
    }

    public static void call(List<UIContactDetail> uiContactDetailList, UIContactImpl uiContact, boolean isVideo, boolean isDesktop, JComponent invoker, Point location) {
        CallManager.call(uiContactDetailList, uiContact, isVideo, isDesktop, invoker, location, true);
    }

    private static void call(List<UIContactDetail> uiContactDetailList, UIContactImpl uiContact, boolean isVideo, boolean isDesktop, JComponent invoker, Point location, boolean usePreferredProvider) {
        ChooseCallAccountPopupMenu chooseCallAccountPopupMenu = null;
        Class<? extends OperationSet> opsetClass = CallManager.getOperationSetForCall(isVideo, isDesktop);
        UIPhoneUtil contactPhoneUtil = null;
        if (uiContact != null && uiContact.getDescriptor() instanceof MetaContact) {
            contactPhoneUtil = UIPhoneUtil.getPhoneUtil((MetaContact)((MetaContact)uiContact.getDescriptor()));
        }
        if (contactPhoneUtil != null) {
            boolean addAdditionalNumbers = false;
            if (!isVideo || ConfigurationUtils.isRouteVideoAndDesktopUsingPhoneNumberEnabled()) {
                addAdditionalNumbers = true;
            } else if (isVideo && contactPhoneUtil != null) {
                boolean bl = contactPhoneUtil.isVideoCallEnabled() ? (isDesktop ? contactPhoneUtil.isDesktopSharingEnabled() : true) : (addAdditionalNumbers = false);
            }
            if (addAdditionalNumbers) {
                uiContactDetailList.addAll(contactPhoneUtil.getAdditionalNumbers());
            }
        }
        if (uiContactDetailList.size() == 1) {
            UIContactDetail detail = uiContactDetailList.get(0);
            ProtocolProviderService preferredProvider = null;
            if (usePreferredProvider) {
                preferredProvider = detail.getPreferredProtocolProvider(opsetClass);
            }
            List providers = null;
            String protocolName = null;
            if (preferredProvider != null) {
                if (preferredProvider.isRegistered()) {
                    CallManager.createCall(opsetClass, preferredProvider, detail.getAddress(), uiContact);
                } else {
                    protocolName = preferredProvider.getProtocolName();
                    providers = AccountUtils.getRegisteredProviders((String)protocolName, opsetClass);
                }
            } else {
                protocolName = detail.getPreferredProtocol(opsetClass);
                providers = protocolName != null ? AccountUtils.getRegisteredProviders((String)protocolName, opsetClass) : AccountUtils.getRegisteredProviders(opsetClass);
            }
            if (providers != null) {
                int providersCount = providers.size();
                if (providersCount <= 0) {
                    new ErrorDialog(null, GuiActivator.getResources().getI18NString("service.gui.CALL_FAILED"), GuiActivator.getResources().getI18NString("service.gui.NO_ONLINE_TELEPHONY_ACCOUNT")).showDialog();
                } else if (providersCount == 1) {
                    CallManager.createCall(opsetClass, (ProtocolProviderService)providers.get(0), detail.getAddress(), uiContact);
                } else if (providersCount > 1) {
                    chooseCallAccountPopupMenu = new ChooseCallAccountPopupMenu(invoker, detail.getAddress(), (List<ProtocolProviderService>)providers, opsetClass);
                }
            }
        } else if (uiContactDetailList.size() > 1) {
            chooseCallAccountPopupMenu = new ChooseCallAccountPopupMenu(invoker, uiContactDetailList, opsetClass);
        }
        if (chooseCallAccountPopupMenu != null) {
            if (uiContact != null) {
                chooseCallAccountPopupMenu.setUIContact(uiContact);
            }
            chooseCallAccountPopupMenu.showPopupMenu(location.x, location.y);
        }
    }

    public static void call(UIContact uiContact, boolean isVideo, boolean isDesktop, JComponent invoker, Point location) {
        UIContactImpl uiContactImpl = null;
        if (uiContact instanceof UIContactImpl) {
            uiContactImpl = (UIContactImpl)uiContact;
        }
        List telephonyContacts = uiContact.getContactDetailsForOperationSet(CallManager.getOperationSetForCall(isVideo, isDesktop));
        boolean ignorePreferredProvider = GuiActivator.getConfigurationService().getBoolean(IGNORE_PREFERRED_PROVIDER_PROP, false);
        CallManager.call(telephonyContacts, uiContactImpl, isVideo, isDesktop, invoker, location, !ignorePreferredProvider);
    }

    private static String queryContactSource(String peerAddress, DetailsResolveListener listener) {
        String displayName = null;
        if (!StringUtils.isNullOrEmpty((String)peerAddress)) {
            ContactSourceSearcher searcher = new ContactSourceSearcher(peerAddress, listener);
            if (listener == null) {
                searcher.run();
                displayName = searcher.displayName;
            } else {
                new Thread((Runnable)searcher, searcher.getClass().getName()).start();
            }
        }
        return displayName;
    }

    public static interface DetailsResolveListener {
        public void displayNameUpdated(String var1);

        public void imageUpdated(byte[] var1);

        public boolean isInterested();
    }

    private static class ContactSourceSearcher
    implements Runnable {
        private final DetailsResolveListener listener;
        private final String peerAddress;
        private String displayName;
        private byte[] displayImage;

        private ContactSourceSearcher(String peerAddress, DetailsResolveListener listener) {
            this.peerAddress = peerAddress;
            this.listener = listener;
        }

        @Override
        public void run() {
            ResolveAddressToDisplayNameContactQueryListener resolver;
            int i;
            Vector<ResolveAddressToDisplayNameContactQueryListener> resolvers = new Vector<ResolveAddressToDisplayNameContactQueryListener>(1, 1);
            int index = this.peerAddress.indexOf("@");
            String peerUserID = index > -1 ? this.peerAddress.substring(0, index) : this.peerAddress;
            String quotedPeerUserID = Pattern.quote(peerUserID);
            Pattern pattern = Pattern.compile("^(" + quotedPeerUserID + "|" + quotedPeerUserID + "@.*)$");
            for (ContactSourceService css : GuiActivator.getContactSources()) {
                ContactQuery query;
                if (css.getType() != 1 || (query = css instanceof ExtendedContactSourceService ? ((ExtendedContactSourceService)css).createContactQuery(pattern) : css.createContactQuery(peerUserID)) == null) continue;
                resolvers.add(new ResolveAddressToDisplayNameContactQueryListener(query));
                query.start();
            }
            long startTime = System.currentTimeMillis();
            long timeout = this.listener == null ? 500L : -1L;
            boolean hasRunningResolver = true;
            while ((this.displayName == null || this.displayImage == null) && hasRunningResolver && (this.listener == null || this.listener.isInterested())) {
                hasRunningResolver = false;
                for (i = 0; !(i >= resolvers.size() || this.displayName != null && this.displayImage != null || this.listener != null && !this.listener.isInterested()); ++i) {
                    resolver = (ResolveAddressToDisplayNameContactQueryListener)resolvers.get(i);
                    if (!resolver.isRunning()) {
                        if (this.displayName == null && resolver.isFoundName()) {
                            this.displayName = resolver.getResolvedName();
                            if (this.displayName.equals(this.peerAddress)) {
                                this.displayName = null;
                            }
                            if (this.listener != null && this.displayName != null) {
                                this.listener.displayNameUpdated(this.displayName);
                            }
                        }
                        if (this.displayImage != null || !resolver.isFoundImage()) continue;
                        this.displayImage = resolver.getResolvedImage();
                        String name = resolver.getResolvedName();
                        if (name != null && name.equals(this.peerAddress)) {
                            this.displayImage = null;
                            continue;
                        }
                        if (this.listener == null || this.displayImage == null) continue;
                        this.listener.imageUpdated(this.displayImage);
                        continue;
                    }
                    hasRunningResolver = true;
                }
                Thread.yield();
                if (timeout <= 0L || System.currentTimeMillis() - startTime < timeout) continue;
            }
            for (i = 0; i < resolvers.size(); ++i) {
                resolver = (ResolveAddressToDisplayNameContactQueryListener)resolvers.get(i);
                if (!resolver.isRunning()) continue;
                resolver.stop();
            }
        }
    }

    private static class MergeExistingCalls
    extends Thread {
        private final CallConference conference;
        private final Collection<Call> calls;

        public MergeExistingCalls(CallConference conference, Collection<Call> calls) {
            this.conference = conference;
            this.calls = calls;
        }

        private void putOffHold(Call call) {
            Iterator peers = call.getCallPeers();
            OperationSetBasicTelephony telephony = (OperationSetBasicTelephony)call.getProtocolProvider().getOperationSet(OperationSetBasicTelephony.class);
            while (peers.hasNext()) {
                CallPeer callPeer = (CallPeer)peers.next();
                boolean putOffHold = true;
                if (callPeer instanceof MediaAwareCallPeer) {
                    putOffHold = ((MediaAwareCallPeer)callPeer).getMediaHandler().isLocallyOnHold();
                }
                if (!putOffHold) continue;
                try {
                    telephony.putOffHold(callPeer);
                    Thread.sleep(400L);
                }
                catch (Exception ofe) {
                    logger.error((Object)"Failed to put off hold.", (Throwable)ofe);
                }
            }
        }

        @Override
        public void run() {
            for (Call call : this.conference.getCalls()) {
                this.putOffHold(call);
            }
            if (!this.calls.isEmpty()) {
                for (Call call : this.calls) {
                    if (this.conference.containsCall(call)) continue;
                    this.putOffHold(call);
                    CallManager.closeCallContainerIfNotNecessary(this.conference, false);
                    call.setConference(this.conference);
                }
            }
        }
    }

    private static class PutOnHoldCallPeerThread
    extends Thread {
        private final CallPeer callPeer;
        private final boolean isOnHold;

        public PutOnHoldCallPeerThread(CallPeer callPeer, boolean isOnHold) {
            this.callPeer = callPeer;
            this.isOnHold = isOnHold;
        }

        @Override
        public void run() {
            OperationSetBasicTelephony telephony = (OperationSetBasicTelephony)this.callPeer.getProtocolProvider().getOperationSet(OperationSetBasicTelephony.class);
            try {
                if (this.isOnHold) {
                    telephony.putOnHold(this.callPeer);
                } else {
                    telephony.putOffHold(this.callPeer);
                }
            }
            catch (OperationFailedException ex) {
                logger.error((Object)("Failed to put" + this.callPeer.getAddress() + (this.isOnHold ? " on hold." : " off hold.")), (Throwable)ex);
            }
        }
    }

    private static class EnableLocalVideoThread
    extends Thread {
        private final Call call;
        private final boolean enable;

        public EnableLocalVideoThread(Call call, boolean enable) {
            this.call = call;
            this.enable = enable;
        }

        @Override
        public void run() {
            OperationSetVideoTelephony videoTelephony = (OperationSetVideoTelephony)this.call.getProtocolProvider().getOperationSet(OperationSetVideoTelephony.class);
            boolean enableSucceeded = false;
            if (videoTelephony != null) {
                JFrame frame;
                if (this.enable && CallManager.isDesktopSharingEnabled(this.call) && (frame = DesktopSharingFrame.getFrameForCall(this.call)) != null) {
                    frame.dispose();
                }
                try {
                    videoTelephony.setLocalVideoAllowed(this.call, this.enable);
                    enableSucceeded = true;
                }
                catch (OperationFailedException ex) {
                    logger.error((Object)"Failed to toggle the streaming of local video.", (Throwable)ex);
                    ResourceManagementService r = GuiActivator.getResources();
                    String title = r.getI18NString("service.gui.LOCAL_VIDEO_ERROR_TITLE");
                    String message = r.getI18NString("service.gui.LOCAL_VIDEO_ERROR_MESSAGE");
                    GuiActivator.getAlertUIService().showAlertPopup(title, message, (Throwable)ex);
                }
            }
            if (this.enable && !enableSucceeded) {
                CallManager.getActiveCallContainer(this.call).setVideoButtonSelected(false);
            }
        }
    }

    private static class HangupCallThread
    extends Thread {
        private final Call call;
        private final CallConference conference;
        private final CallPeer peer;

        public HangupCallThread(Call call) {
            this(call, null, null);
        }

        public HangupCallThread(CallConference conference) {
            this(null, conference, null);
        }

        public HangupCallThread(CallPeer peer) {
            this(null, null, peer);
        }

        private HangupCallThread(Call call, CallConference conference, CallPeer peer) {
            this.call = call;
            this.conference = conference;
            this.peer = peer;
        }

        @Override
        public void run() {
            HashSet peers = new HashSet();
            if (this.call != null) {
                Iterator peerIter = this.call.getCallPeers();
                while (peerIter.hasNext()) {
                    peers.add(peerIter.next());
                }
            }
            if (this.conference != null) {
                peers.addAll(this.conference.getCallPeers());
            }
            if (this.peer != null) {
                peers.add(this.peer);
            }
            for (CallPeer peer : peers) {
                OperationSetBasicTelephony basicTelephony = (OperationSetBasicTelephony)peer.getProtocolProvider().getOperationSet(OperationSetBasicTelephony.class);
                try {
                    basicTelephony.hangupCallPeer(peer);
                }
                catch (OperationFailedException ofe) {
                    logger.error((Object)("Could not hang up: " + peer), (Throwable)ofe);
                }
            }
        }
    }

    private static class InviteToConferenceBridgeThread
    extends Thread {
        private final ProtocolProviderService callProvider;
        private final String[] callees;
        private final Call call;

        public InviteToConferenceBridgeThread(ProtocolProviderService callProvider, String[] callees, Call call) {
            this.callProvider = callProvider;
            this.callees = callees;
            this.call = call;
        }

        @Override
        public void run() {
            OperationSetVideoBridge opSetVideoBridge = (OperationSetVideoBridge)this.callProvider.getOperationSet(OperationSetVideoBridge.class);
            if (opSetVideoBridge == null || !opSetVideoBridge.isActive()) {
                return;
            }
            if (ConfigurationUtils.isNormalizePhoneNumber()) {
                CallManager.normalizePhoneNumbers(this.callees);
            }
            try {
                if (this.call == null) {
                    opSetVideoBridge.createConfCall(this.callees);
                } else {
                    for (String contact : this.callees) {
                        opSetVideoBridge.inviteCalleeToCall(contact, this.call);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to invite callees: " + Arrays.toString(this.callees)), (Throwable)e);
                new ErrorDialog(null, GuiActivator.getResources().getI18NString("service.gui.ERROR"), e.getMessage(), (Throwable)e).showDialog();
            }
        }
    }

    private static class InviteToConferenceCallThread
    extends Thread {
        private final Map<ProtocolProviderService, List<String>> callees;
        private final Call call;

        public InviteToConferenceCallThread(Map<ProtocolProviderService, List<String>> callees, Call call) {
            this.callees = callees;
            this.call = call;
        }

        @Override
        public void run() {
            CallConference conference = this.call == null ? null : this.call.getConference();
            for (Map.Entry<ProtocolProviderService, List<String>> entry : this.callees.entrySet()) {
                Call ppsCall;
                Object[] contactArray;
                ProtocolProviderService pps;
                block8: {
                    List conferenceCalls;
                    block9: {
                        block10: {
                            block7: {
                                OperationSetBasicTelephony basicTelephony;
                                pps = entry.getKey();
                                if (pps != null && (basicTelephony = (OperationSetBasicTelephony)pps.getOperationSet(OperationSetBasicTelephony.class)) == null) continue;
                                List<String> contactList = entry.getValue();
                                contactArray = contactList.toArray(new String[contactList.size()]);
                                if (ConfigurationUtils.isNormalizePhoneNumber()) {
                                    CallManager.normalizePhoneNumbers((String[])contactArray);
                                }
                                if (this.call == null || !this.call.getProtocolProvider().equals(pps)) break block7;
                                ppsCall = this.call;
                                break block8;
                            }
                            ppsCall = null;
                            if (conference == null) break block8;
                            conferenceCalls = conference.getCalls();
                            if (pps != null) break block9;
                            if (this.call != null) break block10;
                            if (conferenceCalls.isEmpty()) break block8;
                            ppsCall = (Call)conferenceCalls.get(0);
                            pps = ppsCall.getProtocolProvider();
                            break block8;
                        }
                        ppsCall = this.call;
                        pps = ppsCall.getProtocolProvider();
                        break block8;
                    }
                    for (Call conferenceCall : conferenceCalls) {
                        if (!pps.equals(conferenceCall.getProtocolProvider())) continue;
                        ppsCall = conferenceCall;
                        break;
                    }
                }
                OperationSetTelephonyConferencing telephonyConferencing = (OperationSetTelephonyConferencing)pps.getOperationSet(OperationSetTelephonyConferencing.class);
                try {
                    if (ppsCall == null) {
                        ppsCall = telephonyConferencing.createConfCall((String[])contactArray, conference);
                        if (conference != null) continue;
                        conference = ppsCall.getConference();
                        continue;
                    }
                    for (Object contact : contactArray) {
                        telephonyConferencing.inviteCalleeToCall((String)contact, ppsCall);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to invite callees: " + Arrays.toString(contactArray)), (Throwable)e);
                    new ErrorDialog(null, GuiActivator.getResources().getI18NString("service.gui.ERROR"), e.getMessage(), 64).showDialog();
                }
            }
        }
    }

    private static class AnswerCallThread
    extends Thread {
        private final Call call;
        private final Call existingCall;
        private final boolean video;

        public AnswerCallThread(Call call, Call existingCall, boolean video) {
            this.call = call;
            this.existingCall = existingCall;
            this.video = video;
        }

        @Override
        public void run() {
            if (this.existingCall != null) {
                this.call.setConference(this.existingCall.getConference());
            }
            ProtocolProviderService pps = this.call.getProtocolProvider();
            Iterator peers = this.call.getCallPeers();
            while (peers.hasNext()) {
                OperationSetVideoTelephony telephony;
                CallPeer peer = (CallPeer)peers.next();
                if (this.video) {
                    telephony = (OperationSetVideoTelephony)pps.getOperationSet(OperationSetVideoTelephony.class);
                    try {
                        telephony.answerVideoCallPeer(peer);
                    }
                    catch (OperationFailedException ofe) {
                        logger.error((Object)("Could not answer " + peer + " with video because of the following exception: " + (Object)((Object)ofe)));
                    }
                    continue;
                }
                telephony = (OperationSetBasicTelephony)pps.getOperationSet(OperationSetBasicTelephony.class);
                try {
                    telephony.answerCallPeer(peer);
                }
                catch (OperationFailedException ofe) {
                    logger.error((Object)("Could not answer " + peer + " because of the following exception: "), (Throwable)ofe);
                }
            }
        }
    }

    private static class CreateDesktopSharingThread
    extends Thread {
        private final String stringContact;
        private final ProtocolProviderService protocolProvider;
        private final MediaDevice mediaDevice;
        private final UIContactImpl uiContact;
        private boolean fullscreen = false;

        public CreateDesktopSharingThread(ProtocolProviderService protocolProvider, String contact, UIContactImpl uiContact, MediaDevice mediaDevice, boolean fullscreen) {
            this.protocolProvider = protocolProvider;
            this.stringContact = contact;
            this.uiContact = uiContact;
            this.mediaDevice = mediaDevice;
            this.fullscreen = fullscreen;
        }

        @Override
        public void run() {
            OperationSetDesktopStreaming desktopSharingOpSet = (OperationSetDesktopStreaming)this.protocolProvider.getOperationSet(OperationSetDesktopStreaming.class);
            if (desktopSharingOpSet == null) {
                return;
            }
            Throwable exception = null;
            Call createdCall = null;
            try {
                createdCall = this.mediaDevice != null ? desktopSharingOpSet.createVideoCall(this.stringContact, this.mediaDevice) : desktopSharingOpSet.createVideoCall(this.stringContact);
            }
            catch (OperationFailedException e) {
                exception = e;
            }
            catch (ParseException e) {
                exception = e;
            }
            if (exception != null) {
                logger.error((Object)"The call could not be created: ", exception);
                new ErrorDialog(null, GuiActivator.getResources().getI18NString("service.gui.ERROR"), exception.getMessage(), 64).showDialog();
            }
            if (this.uiContact != null && createdCall != null) {
                CallManager.addUIContactCall(this.uiContact, createdCall);
            }
            if (createdCall != null && this.fullscreen) {
                new FullScreenShareIndicator(createdCall);
            }
        }
    }

    private static class CreateCallThread
    extends Thread {
        private final Contact contact;
        private final ContactResource contactResource;
        private final UIContactImpl uiContact;
        private final ProtocolProviderService protocolProvider;
        private final String stringContact;
        private final ConferenceDescription conferenceDescription;
        private final boolean video;
        private final ChatRoom chatRoom;

        public CreateCallThread(ProtocolProviderService protocolProvider, Contact contact, ContactResource contactResource, boolean video) {
            this(protocolProvider, contact, contactResource, null, null, null, null, video);
        }

        public CreateCallThread(ProtocolProviderService protocolProvider, String contact, boolean video) {
            this(protocolProvider, null, null, null, contact, null, null, video);
        }

        public CreateCallThread(ProtocolProviderService protocolProvider, ConferenceDescription conferenceDescription, ChatRoom chatRoom) {
            this(protocolProvider, null, null, null, null, conferenceDescription, chatRoom, false);
        }

        public CreateCallThread(ProtocolProviderService protocolProvider, Contact contact, ContactResource contactResource, UIContactImpl uiContact, String stringContact, ConferenceDescription conferenceDescription, ChatRoom chatRoom, boolean video) {
            this.protocolProvider = protocolProvider;
            this.contact = contact;
            this.contactResource = contactResource;
            this.uiContact = uiContact;
            this.stringContact = stringContact;
            this.video = video;
            this.conferenceDescription = conferenceDescription;
            this.chatRoom = chatRoom;
        }

        @Override
        public void run() {
            if (!this.video) {
                MediaService mediaService = GuiActivator.getMediaService();
                MediaDevice dev = mediaService.getDefaultDevice(MediaType.AUDIO, MediaUseCase.CALL);
                List formats = CallManager.getAudioFormats(dev, this.protocolProvider);
                String errorMsg = null;
                if (!dev.getDirection().allowsSending()) {
                    errorMsg = GuiActivator.getResources().getI18NString("service.gui.CALL_NO_AUDIO_DEVICE");
                } else if (formats.isEmpty()) {
                    errorMsg = GuiActivator.getResources().getI18NString("service.gui.CALL_NO_AUDIO_CODEC");
                }
                if (errorMsg != null && GuiActivator.getUIService().getPopupDialog().showConfirmPopupDialog((Object)(errorMsg + " " + GuiActivator.getResources().getI18NString("service.gui.CALL_NO_DEVICE_CODECS_Q")), GuiActivator.getResources().getI18NString("service.gui.CALL"), 0, 3) == 1) {
                    return;
                }
            }
            Contact contact = this.contact;
            String stringContact = this.stringContact;
            if (ConfigurationUtils.isNormalizePhoneNumber() && !NetworkUtils.isValidIPAddress((String)stringContact)) {
                if (contact != null) {
                    stringContact = contact.getAddress();
                    contact = null;
                }
                if (stringContact != null) {
                    stringContact = GuiActivator.getPhoneNumberI18nService().normalize(stringContact);
                }
            }
            try {
                if (this.conferenceDescription != null) {
                    CallManager.internalCall(this.protocolProvider, this.conferenceDescription, this.chatRoom);
                } else if (this.video) {
                    CallManager.internalCallVideo(this.protocolProvider, contact, this.uiContact, stringContact);
                } else {
                    CallManager.internalCall(this.protocolProvider, contact, stringContact, this.contactResource, this.uiContact);
                }
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                logger.error((Object)"The call could not be created: ", t);
                String message = GuiActivator.getResources().getI18NString("servoce.gui.CREATE_CALL_FAILED");
                if (t.getMessage() != null) {
                    message = message + " " + t.getMessage();
                }
                new ErrorDialog(null, GuiActivator.getResources().getI18NString("service.gui.ERROR"), message, t).showDialog();
            }
        }
    }

    private static class IncomingCallHandler
    extends CallChangeAdapter {
        private ReceivedCallDialog receivedCallDialog;
        private String peerName;
        private long callTime;

        IncomingCallHandler(Call sourceCall) {
            Iterator peerIter = sourceCall.getCallPeers();
            if (!peerIter.hasNext()) {
                return;
            }
            this.peerName = ((CallPeer)peerIter.next()).getDisplayName();
            this.callTime = System.currentTimeMillis();
            sourceCall.addCallChangeListener((CallChangeListener)this);
        }

        public void callStateChanged(final CallChangeEvent ev) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IncomingCallHandler.this.callStateChanged(ev);
                    }
                });
                return;
            }
            if (!"CallState".equals(ev.getPropertyName())) {
                return;
            }
            if (this.receivedCallDialog != null && this.receivedCallDialog.isVisible()) {
                this.receivedCallDialog.setVisible(false);
            }
            Object newValue = ev.getNewValue();
            Call call = ev.getSourceCall();
            if (CallState.CALL_INITIALIZATION.equals(newValue) || CallState.CALL_IN_PROGRESS.equals(newValue)) {
                CallManager.openCallContainerIfNecessary(call);
            } else if (CallState.CALL_ENDED.equals(newValue)) {
                CallPeerChangeEvent cause;
                if (ev.getOldValue().equals(CallState.CALL_INITIALIZATION) && ((cause = ev.getCause()) == null || cause.getReasonCode() != 200)) {
                    CallManager.addMissedCallNotification(this.peerName, this.callTime);
                }
                call.removeCallChangeListener((CallChangeListener)this);
            }
        }

        public void incomingCallReceivedInEventDispatchThread(CallEvent ev) {
            Call sourceCall = ev.getSourceCall();
            boolean isVideoCall = ev.isVideoCall() && ConfigurationUtils.hasEnabledVideoFormat((ProtocolProviderService)sourceCall.getProtocolProvider());
            this.receivedCallDialog = new ReceivedCallDialog(sourceCall, isVideoCall, CallManager.getInProgressCalls().size() > 0, ev.isDesktopStreaming());
            this.receivedCallDialog.setVisible(true);
            Iterator peerIter = sourceCall.getCallPeers();
            if (!peerIter.hasNext()) {
                if (this.receivedCallDialog.isVisible()) {
                    this.receivedCallDialog.setVisible(false);
                }
                return;
            }
            CallManager.forwardCallEventToCallPanels(ev);
        }
    }

    public static class GuiCallListener
    extends SwingCallListener {
        private Map<CallEvent, WeakReference<IncomingCallHandler>> inCallHandlers = Collections.synchronizedMap(new WeakHashMap());

        @Override
        public void incomingCallReceived(CallEvent ev) {
            this.inCallHandlers.put(ev, new WeakReference<IncomingCallHandler>(new IncomingCallHandler(ev.getSourceCall())));
            super.incomingCallReceived(ev);
        }

        @Override
        public void incomingCallReceivedInEventDispatchThread(CallEvent ev) {
            WeakReference<IncomingCallHandler> ihRef = this.inCallHandlers.remove(ev);
            if (ihRef != null) {
                ((IncomingCallHandler)((Object)ihRef.get())).incomingCallReceivedInEventDispatchThread(ev);
            }
        }

        @Override
        public void callEndedInEventDispatchThread(CallEvent ev) {
            CallConference callConference = ev.getCallConference();
            CallManager.closeCallContainerIfNotNecessary(callConference);
            CallManager.forwardCallEventToCallPanels(ev);
            TreeContactList contactList = GuiActivator.getContactList();
            if (contactList.getCurrentFilter().equals(TreeContactList.historyFilter)) {
                contactList.applyFilter(TreeContactList.historyFilter);
            }
        }

        @Override
        public void outgoingCallCreatedInEventDispatchThread(CallEvent ev) {
            Call sourceCall = ev.getSourceCall();
            CallManager.openCallContainerIfNecessary(sourceCall);
            CallManager.forwardCallEventToCallPanels(ev);
        }
    }
}

