/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.contactinfo;

import java.util.Hashtable;
import net.java.sip.communicator.plugin.contactinfo.ContactInfoMenuItem;
import net.java.sip.communicator.service.browserlauncher.BrowserLauncherService;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.ImageLoaderService;
import net.java.sip.communicator.service.gui.PluginComponent;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ContactInfoActivator
implements BundleActivator {
    private Logger logger = Logger.getLogger(ContactInfoActivator.class);
    private static final String ENABLED_IN_CHAT_WINDOW_PROP = "net.java.sip.communicator.plugin.contactinfo.ENABLED_IN_CHAT_WINDOW_PROP";
    private static final String ENABLED_IN_CALL_WINDOW_PROP = "net.java.sip.communicator.plugin.contactinfo.ENABLED_IN_CALL_WINDOW_PROP";
    private static BrowserLauncherService browserLauncherService;
    private static ImageLoaderService<?> imageLoaderService;
    private static MetaContactListService metaCListService;
    static BundleContext bundleContext;

    public void start(BundleContext bc) throws Exception {
        bundleContext = bc;
        Hashtable<String, String> containerFilter = new Hashtable<String, String>();
        containerFilter.put("CONTAINER_ID", Container.CONTAINER_CONTACT_RIGHT_BUTTON_MENU.getID());
        bundleContext.registerService(PluginComponentFactory.class.getName(), (Object)new ContactInfoPluginComponentFactory(Container.CONTAINER_CONTACT_RIGHT_BUTTON_MENU), containerFilter);
        if (ContactInfoActivator.getConfigService().getBoolean(ENABLED_IN_CHAT_WINDOW_PROP, false)) {
            containerFilter = new Hashtable();
            containerFilter.put("CONTAINER_ID", Container.CONTAINER_CHAT_TOOL_BAR.getID());
            bundleContext.registerService(PluginComponentFactory.class.getName(), (Object)new ContactInfoPluginComponentFactory(Container.CONTAINER_CHAT_TOOL_BAR), containerFilter);
        }
        if (ContactInfoActivator.getConfigService().getBoolean(ENABLED_IN_CALL_WINDOW_PROP, false)) {
            containerFilter = new Hashtable();
            containerFilter.put("CONTAINER_ID", Container.CONTAINER_CALL_DIALOG.getID());
            bundleContext.registerService(PluginComponentFactory.class.getName(), (Object)new ContactInfoPluginComponentFactory(Container.CONTAINER_CALL_DIALOG), containerFilter);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"CONTACT INFO... [REGISTERED]");
        }
    }

    public void stop(BundleContext bc) throws Exception {
    }

    public static BrowserLauncherService getBrowserLauncher() {
        if (browserLauncherService == null) {
            ServiceReference serviceReference = bundleContext.getServiceReference(BrowserLauncherService.class.getName());
            browserLauncherService = (BrowserLauncherService)bundleContext.getService(serviceReference);
        }
        return browserLauncherService;
    }

    public static ImageLoaderService<?> getImageLoaderService() {
        if (imageLoaderService == null) {
            imageLoaderService = (ImageLoaderService)ServiceUtils.getService((BundleContext)bundleContext, ImageLoaderService.class);
        }
        return imageLoaderService;
    }

    public static MetaContactListService getContactListService() {
        if (metaCListService == null) {
            metaCListService = (MetaContactListService)ServiceUtils.getService((BundleContext)bundleContext, MetaContactListService.class);
        }
        return metaCListService;
    }

    public static ConfigurationService getConfigService() {
        return (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
    }

    static {
        imageLoaderService = null;
    }

    private class ContactInfoPluginComponentFactory
    extends PluginComponentFactory {
        ContactInfoPluginComponentFactory(Container c) {
            super(c);
        }

        protected PluginComponent getPluginInstance() {
            return new ContactInfoMenuItem(this.getContainer(), this);
        }
    }
}

