/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.acl;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gAcl", nsUri="http://schemas.google.com/acl/2007", localName="scope", isRequired=true)
public class AclScope
extends AbstractExtension {
    static final String SCOPE = "scope";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String NAME = "name";
    private static final AttributeHelper.LowerCaseEnumToAttributeValue<Type> TYPE_ENUM_TO_ATTRIBUTE_VALUE = new AttributeHelper.LowerCaseEnumToAttributeValue();
    private Type type = null;
    private String value = null;
    private String name = null;

    public AclScope() {
    }

    public AclScope(Type type, String value) {
        this.setType(type);
        this.setValue(value);
        this.setImmutable(true);
    }

    public AclScope(Type type, String value, String name) {
        this.setType(type);
        this.setValue(value);
        this.setName(name);
        this.setImmutable(true);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.throwExceptionIfImmutable();
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.throwExceptionIfImmutable();
        this.name = name;
    }

    public String toExternalForm() {
        if (this.type == Type.DEFAULT) {
            return AclScope.getTypeIdentifier(this.type);
        }
        return AclScope.getTypeIdentifier(this.type) + ":" + this.value;
    }

    public static AclScope fromExternalForm(String externalForm) {
        if (externalForm == null) {
            return null;
        }
        if (externalForm.equals(AclScope.getTypeIdentifier(Type.DEFAULT))) {
            return new AclScope(Type.DEFAULT, null);
        }
        String[] components = externalForm.split(":");
        if (components.length != 2) {
            return null;
        }
        Type type = AclScope.getType(components[0]);
        if (type == null || type == Type.DEFAULT) {
            return null;
        }
        return new AclScope(type, components[1]);
    }

    @Override
    protected void validate() {
        if (this.type == null) {
            AclScope.throwExceptionForMissingAttribute(TYPE);
        }
        if (this.type == Type.DEFAULT) {
            if (this.value != null) {
                throw new IllegalStateException("attribute value should not be set for default type");
            }
        } else if (this.value == null) {
            AclScope.throwExceptionForMissingAttribute(VALUE);
        }
    }

    @Override
    public void putAttributes(AttributeGenerator generator) {
        generator.put(TYPE, this.type, TYPE_ENUM_TO_ATTRIBUTE_VALUE);
        generator.put(VALUE, this.value);
        generator.put(NAME, this.name);
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.type = helper.consumeEnum(TYPE, true, Type.class, null, TYPE_ENUM_TO_ATTRIBUTE_VALUE);
        this.value = helper.consume(VALUE, false);
        this.name = helper.consume(NAME, false);
    }

    private static String getTypeIdentifier(Type type) {
        return TYPE_ENUM_TO_ATTRIBUTE_VALUE.getAttributeValue(type);
    }

    private static Type getType(String identifier) {
        for (Type type : Type.values()) {
            if (!TYPE_ENUM_TO_ATTRIBUTE_VALUE.getAttributeValue(type).equals(identifier)) continue;
            return type;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        AclScope vc = (AclScope)o;
        return AclScope.eq(this.value, vc.value) && AclScope.eq((Object)this.type, (Object)vc.type) && AclScope.eq(this.name, vc.name);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        if (this.type != null) {
            result = 37 * result + this.type.hashCode();
        }
        if (this.name != null) {
            result = 37 * result + this.name.hashCode();
        }
        return result;
    }

    public String toString() {
        return "[AclScope type=" + (Object)((Object)this.type) + " value=" + this.value + " name=" + this.name + "]";
    }

    public static enum Type {
        INVITE,
        USER,
        DOMAIN,
        GROUP,
        DEFAULT;

    }
}

