/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.io.IOException;
import java.util.Arrays;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.PushBufferStream;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPushBufferCaptureDevice;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPushBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.AbstractAudioRenderer;

class AudioSilenceCaptureDevice
extends AbstractPushBufferCaptureDevice {
    private static final long CLOCK_TICK_INTERVAL = 20L;
    private static final Format[] SUPPORTED_FORMATS = new Format[]{new AudioFormat("LINEAR", 48000.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)};
    private final boolean clockOnly;

    AudioSilenceCaptureDevice(boolean clockOnly) {
        this.clockOnly = clockOnly;
    }

    protected AudioSilenceStream createStream(int streamIndex, FormatControl formatControl) {
        return new AudioSilenceStream(this, formatControl, this.clockOnly);
    }

    @Override
    protected Format[] getSupportedFormats(int streamIndex) {
        return (Format[])SUPPORTED_FORMATS.clone();
    }

    private static class AudioSilenceStream
    extends AbstractPushBufferStream<AudioSilenceCaptureDevice>
    implements Runnable {
        private boolean started;
        private Thread thread;
        private final boolean clockOnly;

        public AudioSilenceStream(AudioSilenceCaptureDevice dataSource, FormatControl formatControl, boolean clockOnly) {
            super(dataSource, formatControl);
            this.clockOnly = clockOnly;
        }

        public void read(Buffer buffer) throws IOException {
            if (this.clockOnly) {
                buffer.setLength(0);
            } else {
                AudioFormat format = (AudioFormat)this.getFormat();
                int frameSizeInBytes = format.getChannels() * ((int)format.getSampleRate() / 50) * (format.getSampleSizeInBits() / 8);
                byte[] data = AbstractCodec2.validateByteArraySize(buffer, frameSizeInBytes, false);
                Arrays.fill(data, 0, frameSizeInBytes, (byte)0);
                buffer.setFormat((Format)format);
                buffer.setLength(frameSizeInBytes);
                buffer.setOffset(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block21: {
                AbstractAudioRenderer.useAudioThreadPriority();
                tickTime = System.currentTimeMillis();
                while (true) lbl-1000:
                // 4 sources

                {
                    v0 = tick = (sleepInterval = tickTime - System.currentTimeMillis()) <= 0L;
                    if (tick) {
                        tickTime += 20L;
                    } else {
                        try {
                            Thread.sleep(sleepInterval);
                        }
                        catch (InterruptedException var6_6) {
                            // empty catch block
                        }
                    }
                    var6_5 = this;
                    synchronized (var6_5) {
                        if (this.thread != Thread.currentThread() || !this.started) {
                            break block21;
                        }
                    }
                    if (!tick || (transferHandler = this.transferHandler) == null) continue;
                    try {
                        transferHandler.transferData((PushBufferStream)this);
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) ** break;
                        continue;
                        throw (ThreadDeath)t;
                    }
                    break;
                }
                ** GOTO lbl-1000
                finally {
                    var1_2 = this;
                    synchronized (var1_2) {
                        if (this.thread == Thread.currentThread()) {
                            this.thread = null;
                            this.started = false;
                            this.notifyAll();
                        }
                    }
                }
            }
        }

        @Override
        public synchronized void start() throws IOException {
            if (this.thread == null) {
                String className = this.getClass().getName();
                this.thread = new Thread((Runnable)this, className);
                this.thread.setDaemon(true);
                boolean started = false;
                try {
                    this.thread.start();
                    started = true;
                }
                finally {
                    this.started = started;
                    if (!started) {
                        this.thread = null;
                        this.notifyAll();
                        throw new IOException("Failed to start " + className);
                    }
                }
            }
        }

        @Override
        public synchronized void stop() throws IOException {
            this.started = false;
            this.notifyAll();
            boolean interrupted = false;
            while (this.thread != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

