/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.globalproxyconfig;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Dictionary;
import java.util.Hashtable;
import net.java.sip.communicator.plugin.globalproxyconfig.GlobalProxyConfigForm;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.LazyConfigurationForm;
import net.java.sip.communicator.service.protocol.ProxyInfo;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class GlobalProxyPluginActivator
implements BundleActivator {
    private Logger logger = Logger.getLogger(GlobalProxyPluginActivator.class);
    private static ConfigurationService configService;
    protected static BundleContext bundleContext;
    private static final String DISABLED_PROP = "net.java.sip.communicator.plugin.globalproxyconfig.DISABLED";

    public void start(BundleContext bc) throws Exception {
        bundleContext = bc;
        if (!GlobalProxyPluginActivator.getConfigurationService().getBoolean(DISABLED_PROP, false)) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("FORM_TYPE", "ADVANCED_TYPE");
            bundleContext.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm(GlobalProxyConfigForm.class.getName(), this.getClass().getClassLoader(), "plugin.globalproxy.PLUGIN_ICON", "plugin.globalproxy.GLOBAL_PROXY_CONFIG", 51, true), properties);
        }
        GlobalProxyPluginActivator.initProperties();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"GLOBAL PROXY CONFIGURATION PLUGIN... [REGISTERED]");
        }
    }

    public void stop(BundleContext bc) throws Exception {
    }

    public static ConfigurationService getConfigurationService() {
        if (configService == null) {
            ServiceReference configReference = bundleContext.getServiceReference(ConfigurationService.class.getName());
            configService = (ConfigurationService)bundleContext.getService(configReference);
        }
        return configService;
    }

    static void initProperties() {
        String globalProxyType = GlobalProxyPluginActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyType");
        if (globalProxyType != null && !globalProxyType.equals(ProxyInfo.ProxyType.NONE.name())) {
            String globalProxyAddress = GlobalProxyPluginActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyAddress");
            if (globalProxyAddress == null || globalProxyAddress.length() <= 0) {
                return;
            }
            String globalProxyPortStr = GlobalProxyPluginActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyPort");
            int globalProxyPort = -1;
            try {
                globalProxyPort = Integer.parseInt(globalProxyPortStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String globalProxyUsername = GlobalProxyPluginActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyUsername");
            String globalProxyPassword = GlobalProxyPluginActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyPassword");
            String type = null;
            if (globalProxyType.equals(ProxyInfo.ProxyType.HTTP.name())) {
                type = "HTTP";
                System.setProperty("http.proxyHost", globalProxyAddress);
                if (globalProxyPortStr != null) {
                    System.setProperty("http.proxyPort", globalProxyPortStr);
                }
                System.setProperty("proxySet", "true");
            } else if (globalProxyType.equals(ProxyInfo.ProxyType.SOCKS4.name()) || globalProxyType.equals(ProxyInfo.ProxyType.SOCKS5.name())) {
                type = "SOCKS";
                System.setProperty("socksProxyHost", globalProxyAddress);
                if (globalProxyPortStr != null) {
                    System.setProperty("socksProxyPort", globalProxyPortStr);
                }
                System.setProperty("socksProxySet", "true");
            }
            Authenticator.setDefault(new AuthenticatorImpl(globalProxyAddress, globalProxyPort, type, globalProxyUsername, globalProxyPassword));
        } else {
            Authenticator.setDefault(null);
        }
    }

    private static class AuthenticatorImpl
    extends Authenticator {
        String host;
        int port;
        String type;
        String username;
        String password;

        public AuthenticatorImpl(String host, int port, String type, String username, String password) {
            this.host = host;
            this.port = port;
            this.type = type;
            this.username = username;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            if (this.getRequestingProtocol().startsWith(this.type) && this.getRequestingHost().equals(this.host) && this.port == this.getRequestingPort() && this.getRequestorType().equals((Object)Authenticator.RequestorType.SERVER) && this.username != null) {
                char[] pass = this.password == null ? new char[]{} : this.password.toCharArray();
                return new PasswordAuthentication(this.username, pass);
            }
            return super.getPasswordAuthentication();
        }
    }
}

