/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Wrapper;
import org.hsqldb.HsqlException;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCStatementBase;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultProperties;

public class JDBCStatement
extends JDBCStatementBase
implements Statement,
Wrapper {
    boolean poolable = false;

    @Override
    public synchronized ResultSet executeQuery(String string) throws SQLException {
        this.fetchResult(string, 2, 2, null, null);
        return this.getResultSet();
    }

    @Override
    public synchronized int executeUpdate(String string) throws SQLException {
        this.fetchResult(string, 1, 2, null, null);
        return this.resultIn.getUpdateCount();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeResultData();
        this.batchResultOut = null;
        this.connection = null;
        this.resultIn = null;
        this.resultOut = null;
        this.isClosed = true;
    }

    @Override
    public synchronized int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.checkClosed();
        if (n < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
    }

    @Override
    public synchronized int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    @Override
    public synchronized void setMaxRows(int n) throws SQLException {
        this.checkClosed();
        if (n < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        this.maxRows = n;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkClosed();
        this.isEscapeProcessing = bl;
    }

    @Override
    public synchronized int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this.checkClosed();
        if (n < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        }
        this.queryTimeout = n;
    }

    @Override
    public synchronized void cancel() throws SQLException {
        this.checkClosed();
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.checkClosed();
    }

    @Override
    public synchronized boolean execute(String string) throws SQLException {
        this.fetchResult(string, 0, 2, null, null);
        return this.currentResultSet != null;
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        return super.getResultSet();
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        return super.getUpdateCount();
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public synchronized void setFetchDirection(int n) throws SQLException {
        this.checkClosed();
        this.checkClosed();
        switch (n) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchDirection = n;
                break;
            }
            default: {
                throw JDBCUtil.invalidArgument();
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchDirection;
    }

    @Override
    public synchronized void setFetchSize(int n) throws SQLException {
        this.checkClosed();
        if (n < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        this.fetchSize = n;
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public synchronized int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCConcurrency(this.rsProperties);
    }

    @Override
    public synchronized int getResultSetType() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCScrollability(this.rsProperties);
    }

    @Override
    public synchronized void addBatch(String string) throws SQLException {
        this.checkClosed();
        if (this.isEscapeProcessing) {
            string = this.connection.nativeSQL(string);
        }
        if (this.batchResultOut == null) {
            this.batchResultOut = Result.newBatchedExecuteRequest();
        }
        this.batchResultOut.getNavigator().add(new Object[]{string});
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        this.checkClosed();
        if (this.batchResultOut != null) {
            this.batchResultOut.getNavigator().clear();
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        this.checkClosed();
        this.generatedResult = null;
        if (this.batchResultOut == null) {
            this.batchResultOut = Result.newBatchedExecuteRequest();
        }
        int n = this.batchResultOut.getNavigator().getSize();
        try {
            this.resultIn = this.connection.sessionProxy.execute(this.batchResultOut);
            this.performPostExecute();
        }
        catch (HsqlException hsqlException) {
            this.batchResultOut.getNavigator().clear();
            throw JDBCUtil.sqlException(hsqlException);
        }
        this.batchResultOut.getNavigator().clear();
        if (this.resultIn.isError()) {
            throw JDBCUtil.sqlException(this.resultIn);
        }
        RowSetNavigator rowSetNavigator = this.resultIn.getNavigator();
        int[] nArray = new int[rowSetNavigator.getSize()];
        for (int i = 0; i < nArray.length; ++i) {
            Object[] objectArray = rowSetNavigator.getNext();
            nArray[i] = (Integer)objectArray[0];
        }
        if (nArray.length != n) {
            if (this.errorResult == null) {
                throw new BatchUpdateException(nArray);
            }
            this.errorResult.getMainString();
            throw new BatchUpdateException(this.errorResult.getMainString(), this.errorResult.getSubString(), this.errorResult.getErrorCode(), nArray);
        }
        return nArray;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    @Override
    public synchronized boolean getMoreResults(int n) throws SQLException {
        return super.getMoreResults(n);
    }

    @Override
    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        return this.getGeneratedResultSet();
    }

    @Override
    public synchronized int executeUpdate(String string, int n) throws SQLException {
        if (n != 1 && n != 2) {
            throw JDBCUtil.invalidArgument("autoGeneratedKeys");
        }
        this.fetchResult(string, 1, n, null, null);
        if (this.resultIn.isError()) {
            throw JDBCUtil.sqlException(this.resultIn);
        }
        return this.resultIn.getUpdateCount();
    }

    @Override
    public synchronized int executeUpdate(String string, int[] nArray) throws SQLException {
        if (nArray == null || nArray.length == 0) {
            throw JDBCUtil.invalidArgument("columnIndexes");
        }
        this.fetchResult(string, 1, 21, nArray, null);
        return this.resultIn.getUpdateCount();
    }

    @Override
    public synchronized int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (stringArray == null || stringArray.length == 0) {
            throw JDBCUtil.invalidArgument("columnIndexes");
        }
        this.fetchResult(string, 1, 11, null, stringArray);
        return this.resultIn.getUpdateCount();
    }

    @Override
    public synchronized boolean execute(String string, int n) throws SQLException {
        if (n != 1 && n != 2) {
            throw JDBCUtil.invalidArgument("autoGeneratedKeys");
        }
        this.fetchResult(string, 0, n, null, null);
        return this.resultIn.isData();
    }

    @Override
    public synchronized boolean execute(String string, int[] nArray) throws SQLException {
        if (nArray == null || nArray.length == 0) {
            throw JDBCUtil.invalidArgument("columnIndexes");
        }
        this.fetchResult(string, 0, 21, nArray, null);
        return this.resultIn.isData();
    }

    @Override
    public synchronized boolean execute(String string, String[] stringArray) throws SQLException {
        if (stringArray == null || stringArray.length == 0) {
            throw JDBCUtil.invalidArgument("columnIndexes");
        }
        this.fetchResult(string, 0, 11, null, stringArray);
        return this.resultIn.isData();
    }

    @Override
    public synchronized int getResultSetHoldability() throws SQLException {
        return ResultProperties.getJDBCHoldability(this.rsProperties);
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public synchronized void setPoolable(boolean bl) throws SQLException {
        this.checkClosed();
        this.poolable = bl;
    }

    @Override
    public synchronized boolean isPoolable() throws SQLException {
        this.checkClosed();
        return this.poolable;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    JDBCStatement(JDBCConnection jDBCConnection, int n) {
        this.resultOut = Result.newExecuteDirectRequest();
        this.connection = jDBCConnection;
        this.connectionIncarnation = this.connection.incarnation;
        this.rsProperties = n;
    }

    private void fetchResult(String string, int n, int n2, int[] nArray, String[] stringArray) throws SQLException {
        this.checkClosed();
        this.closeResultData();
        if (this.isEscapeProcessing) {
            string = this.connection.nativeSQL(string);
        }
        this.resultOut.setPrepareOrExecuteProperties(string, this.maxRows, this.fetchSize, n, this.queryTimeout, this.rsProperties, n2, nArray, stringArray);
        try {
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
            this.performPostExecute();
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
        if (this.resultIn.isError()) {
            throw JDBCUtil.sqlException(this.resultIn);
        }
        if (this.resultIn.isData()) {
            this.currentResultSet = new JDBCResultSet(this.connection, this, this.resultIn, this.resultIn.metaData);
        } else if (this.resultIn.getStatementType() == 2) {
            this.getMoreResults();
        }
    }
}

