/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.dtls;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.crypto.tls.DTLSClientProtocol;
import org.bouncycastle.crypto.tls.DTLSProtocol;
import org.bouncycastle.crypto.tls.DTLSServerProtocol;
import org.bouncycastle.crypto.tls.DTLSTransport;
import org.bouncycastle.crypto.tls.DatagramTransport;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.TlsClient;
import org.bouncycastle.crypto.tls.TlsClientContext;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsPeer;
import org.bouncycastle.crypto.tls.TlsServer;
import org.bouncycastle.crypto.tls.TlsServerContext;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.RTCPPacketPredicate;
import org.jitsi.impl.neomedia.RTPConnectorOutputStream;
import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.dtls.DatagramTransportImpl;
import org.jitsi.impl.neomedia.transform.dtls.DtlsControlImpl;
import org.jitsi.impl.neomedia.transform.dtls.DtlsTransformEngine;
import org.jitsi.impl.neomedia.transform.dtls.Properties;
import org.jitsi.impl.neomedia.transform.dtls.TlsClientImpl;
import org.jitsi.impl.neomedia.transform.dtls.TlsServerImpl;
import org.jitsi.impl.neomedia.transform.srtp.SRTCPTransformer;
import org.jitsi.impl.neomedia.transform.srtp.SRTPContextFactory;
import org.jitsi.impl.neomedia.transform.srtp.SRTPPolicy;
import org.jitsi.impl.neomedia.transform.srtp.SRTPTransformer;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.ConfigUtils;
import org.jitsi.util.Logger;
import org.jitsi.util.event.WeakReferencePropertyChangeListener;

public class DtlsPacketTransformer
implements PacketTransformer {
    private static final long CONNECT_RETRY_INTERVAL = 500L;
    private static final int CONNECT_TRIES = 3;
    private static final boolean DROP_UNENCRYPTED_PKTS;
    private static final String DROP_UNENCRYPTED_PKTS_PNAME;
    static final int DTLS_RECORD_HEADER_LENGTH = 13;
    private static final int DTLS_TRANSPORT_RECEIVE_WAITMILLIS = -1;
    private static final Logger logger;
    private static final int TRANSFORM_QUEUE_CAPACITY;
    private final int componentID;
    private AbstractRTPConnector connector;
    private Thread connectThread;
    private DatagramTransportImpl datagramTransport;
    private DTLSTransport dtlsTransport;
    private MediaType mediaType;
    private final PropertyChangeListener propertyChangeListener = new WeakReferencePropertyChangeListener(new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            DtlsPacketTransformer.this.propertyChange(ev);
        }
    });
    private final LinkedList<RawPacket> _reverseTransformSrtpQueue = new LinkedList();
    private boolean rtcpmux;
    private SinglePacketTransformer _srtpTransformer;
    private long _srtpTransformerLastChanged = -1L;
    private boolean tlsPeerHasRaisedCloseNotifyWarning;
    private final LinkedList<RawPacket> _transformSrtpQueue = new LinkedList();
    private final DtlsTransformEngine transformEngine;
    private boolean started = false;

    public static boolean isDtlsRecord(byte[] buf, int off, int len) {
        boolean b = false;
        if (len >= 13) {
            short type = TlsUtils.readUint8((byte[])buf, (int)off);
            switch (type) {
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    int length;
                    int major = buf[off + 1] & 0xFF;
                    int minor = buf[off + 2] & 0xFF;
                    ProtocolVersion version = null;
                    if (major == ProtocolVersion.DTLSv10.getMajorVersion() && minor == ProtocolVersion.DTLSv10.getMinorVersion()) {
                        version = ProtocolVersion.DTLSv10;
                    }
                    if (version == null && major == ProtocolVersion.DTLSv12.getMajorVersion() && minor == ProtocolVersion.DTLSv12.getMinorVersion()) {
                        version = ProtocolVersion.DTLSv12;
                    }
                    if (version == null || 13 + (length = TlsUtils.readUint16((byte[])buf, (int)(off + 11))) > len) break;
                    b = true;
                    break;
                }
            }
        }
        return b;
    }

    public DtlsPacketTransformer(DtlsTransformEngine transformEngine, int componentID) {
        this.transformEngine = transformEngine;
        this.componentID = componentID;
        this.getProperties().addPropertyChangeListener(this.propertyChangeListener);
        this.propertyChange((String)null);
    }

    @Override
    public synchronized void close() {
        this.getProperties().removePropertyChangeListener(this.propertyChangeListener);
        this.setMediaType(null);
        this.setConnector(null);
    }

    private void closeDatagramTransport() {
        if (this.datagramTransport != null) {
            try {
                this.datagramTransport.close();
            }
            catch (IOException ioe) {
                logger.error("Failed to (properly) close " + this.datagramTransport.getClass(), ioe);
            }
            this.datagramTransport = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enterRunInConnectThreadLoop(int i, DatagramTransport datagramTransport) {
        if (i < 0 || i > 3) {
            return false;
        }
        Thread currentThread = Thread.currentThread();
        DtlsPacketTransformer dtlsPacketTransformer = this;
        synchronized (dtlsPacketTransformer) {
            if (i > 0 && i < 2) {
                boolean interrupted = false;
                try {
                    this.wait(500L);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
                if (interrupted) {
                    currentThread.interrupt();
                }
            }
            return currentThread.equals(this.connectThread) && datagramTransport.equals(this.datagramTransport);
        }
    }

    DtlsControlImpl getDtlsControl() {
        return this.getTransformEngine().getDtlsControl();
    }

    Properties getProperties() {
        return this.getTransformEngine().getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SinglePacketTransformer getSRTPTransformer() {
        SinglePacketTransformer srtpTransformer = this._srtpTransformer;
        if (srtpTransformer != null) {
            return srtpTransformer;
        }
        if (this.rtcpmux && 2 == this.componentID) {
            return this.initializeSRTCPTransformerFromRtp();
        }
        boolean yield = true;
        while (true) {
            DtlsPacketTransformer dtlsPacketTransformer = this;
            synchronized (dtlsPacketTransformer) {
                srtpTransformer = this._srtpTransformer;
                if (srtpTransformer != null) {
                    break;
                }
                if (this.connectThread == null) {
                    break;
                }
            }
            if (!yield) break;
            yield = false;
            Thread.yield();
        }
        return srtpTransformer;
    }

    DtlsTransformEngine getTransformEngine() {
        return this.transformEngine;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean handleRunInConnectThreadException(IOException ioe, String msg, int i) {
        if (this.mediaType == null) {
            return false;
        }
        if (ioe instanceof TlsFatalAlert) {
            TlsFatalAlert tfa = (TlsFatalAlert)ioe;
            short alertDescription = tfa.getAlertDescription();
            if (alertDescription == 10) {
                msg = msg + " Received fatal unexpected message.";
                if (i != 0 && Thread.currentThread().equals(this.connectThread) && this.connector != null && this.mediaType != null) {
                    msg = msg + " Will retry.";
                    logger.error(msg, ioe);
                    return true;
                }
                msg = msg + " Giving up after " + (3 - i) + " retries.";
            } else {
                msg = msg + " Received fatal alert " + alertDescription + ".";
            }
        }
        logger.error(msg, ioe);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SinglePacketTransformer initializeSRTCPTransformerFromRtp() {
        SinglePacketTransformer srtpTransformer;
        DtlsPacketTransformer rtpTransformer = (DtlsPacketTransformer)this.getTransformEngine().getRTPTransformer();
        if (rtpTransformer != this && (srtpTransformer = rtpTransformer.getSRTPTransformer()) != null && srtpTransformer instanceof SRTPTransformer) {
            DtlsPacketTransformer dtlsPacketTransformer = this;
            synchronized (dtlsPacketTransformer) {
                if (this._srtpTransformer == null) {
                    this.setSrtpTransformer(new SRTCPTransformer((SRTPTransformer)srtpTransformer));
                }
            }
        }
        return this._srtpTransformer;
    }

    private SinglePacketTransformer initializeSRTPTransformer(int srtpProtectionProfile, TlsContext tlsContext) {
        SRTPContextFactory reverseSRTPContextFactory;
        SRTPContextFactory forwardSRTPContextFactory;
        int RTP_auth_tag_length;
        int RTCP_auth_tag_length;
        int auth_key_length;
        int auth_function;
        int cipher;
        int cipher_salt_length;
        int cipher_key_length;
        boolean rtcp;
        switch (this.componentID) {
            case 2: {
                rtcp = true;
                break;
            }
            case 1: {
                rtcp = false;
                break;
            }
            default: {
                throw new IllegalStateException("componentID");
            }
        }
        switch (srtpProtectionProfile) {
            case 2: {
                cipher_key_length = 16;
                cipher_salt_length = 14;
                cipher = 1;
                auth_function = 1;
                auth_key_length = 20;
                RTCP_auth_tag_length = 10;
                RTP_auth_tag_length = 4;
                break;
            }
            case 1: {
                cipher_key_length = 16;
                cipher_salt_length = 14;
                cipher = 1;
                auth_function = 1;
                auth_key_length = 20;
                RTP_auth_tag_length = 10;
                RTCP_auth_tag_length = 10;
                break;
            }
            case 6: {
                cipher_key_length = 0;
                cipher_salt_length = 0;
                cipher = 0;
                auth_function = 1;
                auth_key_length = 20;
                RTCP_auth_tag_length = 10;
                RTP_auth_tag_length = 4;
                break;
            }
            case 5: {
                cipher_key_length = 0;
                cipher_salt_length = 0;
                cipher = 0;
                auth_function = 1;
                auth_key_length = 20;
                RTP_auth_tag_length = 10;
                RTCP_auth_tag_length = 10;
                break;
            }
            default: {
                throw new IllegalArgumentException("srtpProtectionProfile");
            }
        }
        byte[] keyingMaterial = tlsContext.exportKeyingMaterial("EXTRACTOR-dtls_srtp", null, 2 * (cipher_key_length + cipher_salt_length));
        byte[] client_write_SRTP_master_key = new byte[cipher_key_length];
        byte[] server_write_SRTP_master_key = new byte[cipher_key_length];
        byte[] client_write_SRTP_master_salt = new byte[cipher_salt_length];
        byte[] server_write_SRTP_master_salt = new byte[cipher_salt_length];
        byte[][] keyingMaterialValues = new byte[][]{client_write_SRTP_master_key, server_write_SRTP_master_key, client_write_SRTP_master_salt, server_write_SRTP_master_salt};
        int keyingMaterialOffset = 0;
        for (int i = 0; i < keyingMaterialValues.length; ++i) {
            byte[] keyingMaterialValue = keyingMaterialValues[i];
            System.arraycopy(keyingMaterial, keyingMaterialOffset, keyingMaterialValue, 0, keyingMaterialValue.length);
            keyingMaterialOffset += keyingMaterialValue.length;
        }
        SRTPPolicy srtcpPolicy = new SRTPPolicy(cipher, cipher_key_length, auth_function, auth_key_length, RTCP_auth_tag_length, cipher_salt_length);
        SRTPPolicy srtpPolicy = new SRTPPolicy(cipher, cipher_key_length, auth_function, auth_key_length, RTP_auth_tag_length, cipher_salt_length);
        SRTPContextFactory clientSRTPContextFactory = new SRTPContextFactory(tlsContext instanceof TlsClientContext, client_write_SRTP_master_key, client_write_SRTP_master_salt, srtpPolicy, srtcpPolicy);
        SRTPContextFactory serverSRTPContextFactory = new SRTPContextFactory(tlsContext instanceof TlsServerContext, server_write_SRTP_master_key, server_write_SRTP_master_salt, srtpPolicy, srtcpPolicy);
        if (tlsContext instanceof TlsClientContext) {
            forwardSRTPContextFactory = clientSRTPContextFactory;
            reverseSRTPContextFactory = serverSRTPContextFactory;
        } else if (tlsContext instanceof TlsServerContext) {
            forwardSRTPContextFactory = serverSRTPContextFactory;
            reverseSRTPContextFactory = clientSRTPContextFactory;
        } else {
            throw new IllegalArgumentException("tlsContext");
        }
        SinglePacketTransformer srtpTransformer = rtcp ? new SRTCPTransformer(forwardSRTPContextFactory, reverseSRTPContextFactory) : new SRTPTransformer(forwardSRTPContextFactory, reverseSRTPContextFactory);
        return srtpTransformer;
    }

    private boolean isSrtpDisabled() {
        return this.getProperties().isSrtpDisabled();
    }

    private synchronized void maybeStart() {
        if (this.mediaType != null && this.connector != null && !this.started) {
            this.start();
        }
    }

    void notifyAlertRaised(TlsPeer tlsPeer, short alertLevel, short alertDescription, String message, Throwable cause) {
        if (1 == alertLevel && 0 == alertDescription) {
            this.tlsPeerHasRaisedCloseNotifyWarning = true;
        }
    }

    private void propertyChange(PropertyChangeEvent ev) {
        this.propertyChange(ev.getPropertyName());
    }

    private void propertyChange(String propertyName) {
        if (propertyName == null) {
            this.propertyChange(Properties.RTCPMUX_PNAME);
            this.propertyChange(Properties.MEDIA_TYPE_PNAME);
            this.propertyChange(Properties.CONNECTOR_PNAME);
        } else if (Properties.CONNECTOR_PNAME.equals(propertyName)) {
            this.setConnector((AbstractRTPConnector)this.getProperties().get(propertyName));
        } else if (Properties.MEDIA_TYPE_PNAME.equals(propertyName)) {
            this.setMediaType((MediaType)((Object)this.getProperties().get(propertyName)));
        } else if (Properties.RTCPMUX_PNAME.equals(propertyName)) {
            Object newValue = this.getProperties().get(propertyName);
            this.setRtcpmux(newValue == null ? false : (Boolean)newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueTransformSrtp(RawPacket[] pkts, boolean transform) {
        if (pkts != null) {
            LinkedList<RawPacket> q;
            LinkedList<RawPacket> linkedList = q = transform ? this._transformSrtpQueue : this._reverseTransformSrtpQueue;
            synchronized (linkedList) {
                for (RawPacket pkt : pkts) {
                    if (pkt == null) continue;
                    while (q.size() >= TRANSFORM_QUEUE_CAPACITY && q.poll() != null) {
                    }
                    q.add(pkt);
                }
            }
        }
    }

    @Override
    public RawPacket[] reverseTransform(RawPacket[] pkts) {
        return this.transform(pkts, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reverseTransformDtls(RawPacket pkt, List<RawPacket> outPkts) {
        block12: {
            if (this.rtcpmux && 2 == this.componentID) {
                logger.warn("Dropping a DTLS packet, because it was received on the RTCP channel while rtcpmux is in use.");
                return;
            }
            DtlsPacketTransformer dtlsPacketTransformer = this;
            synchronized (dtlsPacketTransformer) {
                if (this.datagramTransport == null) {
                    logger.warn("Dropping a DTLS packet. This DtlsPacketTransformer has not been started successfully or has been closed.");
                } else {
                    this.datagramTransport.queueReceive(pkt.getBuffer(), pkt.getOffset(), pkt.getLength());
                }
            }
            if (outPkts == null) {
                return;
            }
            DTLSTransport dtlsTransport = this.dtlsTransport;
            if (dtlsTransport != null) {
                try {
                    while (true) {
                        int receiveLimit = dtlsTransport.getReceiveLimit();
                        byte[] buf = new byte[receiveLimit];
                        RawPacket p = new RawPacket(buf, 0, buf.length);
                        int received = dtlsTransport.receive(buf, 0, buf.length, -1);
                        if (received > 0) {
                            p.setLength(received);
                            outPkts.add(p);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    if (this.mediaType == null || this.tlsPeerHasRaisedCloseNotifyWarning) break block12;
                    logger.error("Failed to decode a DTLS record!", ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInConnectThread(DTLSProtocol dtlsProtocol, TlsPeer tlsPeer, DatagramTransport datagramTransport) {
        boolean closeSRTPTransformer;
        int i;
        DTLSTransport dtlsTransport = null;
        boolean srtp = !this.isSrtpDisabled();
        int srtpProtectionProfile = 0;
        TlsContext tlsContext = null;
        if (dtlsProtocol instanceof DTLSClientProtocol) {
            DTLSClientProtocol dtlsClientProtocol = (DTLSClientProtocol)dtlsProtocol;
            TlsClientImpl tlsClient = (TlsClientImpl)tlsPeer;
            for (i = 2; i >= 0 && this.enterRunInConnectThreadLoop(i, datagramTransport); --i) {
                try {
                    dtlsTransport = dtlsClientProtocol.connect((TlsClient)tlsClient, datagramTransport);
                    break;
                }
                catch (IOException ioe) {
                    if (!this.handleRunInConnectThreadException(ioe, "Failed to connect this DTLS client to a DTLS server!", i)) break;
                    continue;
                }
            }
            if (dtlsTransport != null && srtp) {
                srtpProtectionProfile = tlsClient.getChosenProtectionProfile();
                tlsContext = tlsClient.getContext();
            }
        } else if (dtlsProtocol instanceof DTLSServerProtocol) {
            DTLSServerProtocol dtlsServerProtocol = (DTLSServerProtocol)dtlsProtocol;
            TlsServerImpl tlsServer = (TlsServerImpl)tlsPeer;
            for (i = 2; i >= 0 && this.enterRunInConnectThreadLoop(i, datagramTransport); --i) {
                try {
                    dtlsTransport = dtlsServerProtocol.accept((TlsServer)tlsServer, datagramTransport);
                    break;
                }
                catch (IOException ioe) {
                    if (!this.handleRunInConnectThreadException(ioe, "Failed to accept a connection from a DTLS client!", i)) break;
                    continue;
                }
            }
            if (dtlsTransport != null && srtp) {
                srtpProtectionProfile = tlsServer.getChosenProtectionProfile();
                tlsContext = tlsServer.getContext();
            }
        } else {
            throw new IllegalStateException("dtlsProtocol");
        }
        SinglePacketTransformer srtpTransformer = dtlsTransport == null || !srtp ? null : this.initializeSRTPTransformer(srtpProtectionProfile, tlsContext);
        DtlsPacketTransformer dtlsPacketTransformer = this;
        synchronized (dtlsPacketTransformer) {
            if (Thread.currentThread().equals(this.connectThread) && datagramTransport.equals(this.datagramTransport)) {
                this.dtlsTransport = dtlsTransport;
                this.setSrtpTransformer(srtpTransformer);
            }
            closeSRTPTransformer = this._srtpTransformer != srtpTransformer;
        }
        if (closeSRTPTransformer && srtpTransformer != null) {
            srtpTransformer.close();
        }
    }

    public void sendApplicationData(byte[] buf, int off, int len) {
        DTLSTransport dtlsTransport = this.dtlsTransport;
        Exception throwable = null;
        if (dtlsTransport != null) {
            try {
                dtlsTransport.send(buf, off, len);
            }
            catch (IOException ioe) {
                throwable = ioe;
            }
        } else {
            throwable = new NullPointerException("dtlsTransport");
        }
        if (throwable != null && this.mediaType != null && !this.tlsPeerHasRaisedCloseNotifyWarning) {
            logger.error("Failed to send application data over DTLS transport: ", throwable);
        }
    }

    private void setConnector(AbstractRTPConnector connector) {
        if (this.connector != connector) {
            AbstractRTPConnector oldValue = this.connector;
            this.connector = connector;
            DatagramTransportImpl datagramTransport = this.datagramTransport;
            if (datagramTransport != null) {
                datagramTransport.setConnector(connector);
            }
            if (connector != null) {
                this.maybeStart();
            }
        }
    }

    private synchronized void setMediaType(MediaType mediaType) {
        if (this.mediaType != mediaType) {
            MediaType oldValue = this.mediaType;
            this.mediaType = mediaType;
            if (oldValue != null) {
                this.stop();
            }
            if (this.mediaType != null) {
                this.maybeStart();
            }
        }
    }

    void setRtcpmux(boolean rtcpmux) {
        this.rtcpmux = rtcpmux;
    }

    private synchronized void setSrtpTransformer(SinglePacketTransformer srtpTransformer) {
        if (this._srtpTransformer != srtpTransformer) {
            this._srtpTransformer = srtpTransformer;
            this._srtpTransformerLastChanged = System.currentTimeMillis();
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void start() {
        Object tlsPeer;
        DTLSClientProtocol dtlsProtocolObj;
        if (this.datagramTransport != null) {
            if (this.connectThread == null && this.dtlsTransport == null) {
                logger.warn(this.getClass().getName() + " has been started but has failed to establish the DTLS connection!");
            }
            return;
        }
        if (this.rtcpmux && 2 == this.componentID) {
            return;
        }
        AbstractRTPConnector connector = this.connector;
        this.started = true;
        if (connector == null) {
            throw new NullPointerException("connector");
        }
        DtlsControl.Setup setup = this.getProperties().getSetup();
        if (DtlsControl.Setup.ACTIVE.equals((Object)setup)) {
            dtlsProtocolObj = new DTLSClientProtocol(new SecureRandom());
            tlsPeer = new TlsClientImpl(this);
        } else {
            dtlsProtocolObj = new DTLSServerProtocol(new SecureRandom());
            tlsPeer = new TlsServerImpl(this);
        }
        this.tlsPeerHasRaisedCloseNotifyWarning = false;
        DatagramTransportImpl datagramTransport = new DatagramTransportImpl(this.componentID);
        datagramTransport.setConnector(connector);
        Thread connectThread = new Thread((DTLSProtocol)dtlsProtocolObj, (TlsPeer)tlsPeer, datagramTransport){
            final /* synthetic */ DTLSProtocol val$dtlsProtocolObj;
            final /* synthetic */ TlsPeer val$tlsPeer;
            final /* synthetic */ DatagramTransportImpl val$datagramTransport;
            {
                this.val$dtlsProtocolObj = dTLSProtocol;
                this.val$tlsPeer = tlsPeer;
                this.val$datagramTransport = datagramTransportImpl;
            }

            @Override
            public void run() {
                try {
                    DtlsPacketTransformer.this.runInConnectThread(this.val$dtlsProtocolObj, this.val$tlsPeer, this.val$datagramTransport);
                }
                finally {
                    if (Thread.currentThread().equals(DtlsPacketTransformer.this.connectThread)) {
                        DtlsPacketTransformer.this.connectThread = null;
                    }
                }
            }
        };
        connectThread.setDaemon(true);
        connectThread.setName(DtlsPacketTransformer.class.getName() + ".connectThread");
        this.connectThread = connectThread;
        this.datagramTransport = datagramTransport;
        boolean started = false;
        try {
            connectThread.start();
            started = true;
        }
        finally {
            if (!started) {
                if (connectThread.equals(this.connectThread)) {
                    this.connectThread = null;
                }
                if (datagramTransport.equals(this.datagramTransport)) {
                    this.datagramTransport = null;
                }
            }
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stop() {
        this.started = false;
        if (this.connectThread != null) {
            this.connectThread = null;
        }
        try {
            if (this.dtlsTransport != null) {
                try {
                    this.dtlsTransport.close();
                }
                catch (IOException ioe) {
                    logger.error("Failed to (properly) close " + this.dtlsTransport.getClass(), ioe);
                }
                this.dtlsTransport = null;
            }
            if (this._srtpTransformer != null) {
                this._srtpTransformer.close();
                this._srtpTransformer = null;
            }
        }
        finally {
            try {
                this.closeDatagramTransport();
            }
            finally {
                this.notifyAll();
            }
        }
    }

    @Override
    public RawPacket[] transform(RawPacket[] pkts) {
        return this.transform(pkts, true);
    }

    private RawPacket[] transform(RawPacket[] inPkts, boolean transform) {
        List<RawPacket> outPkts = new ArrayList<RawPacket>();
        outPkts = this.transformDtls(inPkts, transform, outPkts);
        outPkts = this.transformNonDtls(inPkts, transform, outPkts);
        return outPkts.toArray(new RawPacket[outPkts.size()]);
    }

    private List<RawPacket> transformDtls(RawPacket[] inPkts, boolean transform, List<RawPacket> outPkts) {
        if (inPkts != null) {
            for (int i = 0; i < inPkts.length; ++i) {
                int len;
                int off;
                byte[] buf;
                RawPacket inPkt = inPkts[i];
                if (inPkt == null || !DtlsPacketTransformer.isDtlsRecord(buf = inPkt.getBuffer(), off = inPkt.getOffset(), len = inPkt.getLength())) continue;
                if (transform) {
                    outPkts.add(inPkt);
                } else {
                    this.reverseTransformDtls(inPkt, outPkts);
                }
                inPkts[i] = null;
            }
        }
        return outPkts;
    }

    private List<RawPacket> transformNonDtls(RawPacket[] inPkts, boolean transform, List<RawPacket> outPkts) {
        if (this.isSrtpDisabled()) {
            if (transform) {
                outPkts = this.transformNonSrtp(inPkts, outPkts);
            }
        } else {
            outPkts = this.transformSrtp(inPkts, transform, outPkts);
        }
        return outPkts;
    }

    private List<RawPacket> transformNonSrtp(RawPacket[] inPkts, List<RawPacket> outPkts) {
        if (inPkts != null) {
            for (RawPacket inPkt : inPkts) {
                if (inPkt == null) continue;
                byte[] buf = inPkt.getBuffer();
                int off = inPkt.getOffset();
                int len = inPkt.getLength();
                this.sendApplicationData(buf, off, len);
            }
        }
        return outPkts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RawPacket> transformSrtp(RawPacket[] inPkts, boolean transform, List<RawPacket> outPkts) {
        SinglePacketTransformer srtpTransformer = this.getSRTPTransformer();
        if (srtpTransformer == null) {
            if (!DROP_UNENCRYPTED_PKTS) {
                this.queueTransformSrtp(inPkts, transform);
            }
        } else {
            LinkedList<RawPacket> q;
            LinkedList<RawPacket> linkedList = q = transform ? this._transformSrtpQueue : this._reverseTransformSrtpQueue;
            if (q.size() > 0) {
                LinkedList<RawPacket> linkedList2 = q;
                synchronized (linkedList2) {
                    RawPacket template = inPkts != null && inPkts.length > 0 ? inPkts[0] : null;
                    try {
                        outPkts = this.transformSrtp(srtpTransformer, q, transform, outPkts, template);
                    }
                    finally {
                        this.clearQueue(q, template);
                    }
                }
            }
            if (inPkts != null && inPkts.length != 0) {
                outPkts = this.transformSrtp(srtpTransformer, Arrays.asList(inPkts), transform, outPkts, null);
            }
        }
        return outPkts;
    }

    private List<RawPacket> transformSrtp(SinglePacketTransformer srtpTransformer, Collection<RawPacket> inPkts, boolean transform, List<RawPacket> outPkts, RawPacket template) {
        for (RawPacket inPkt : inPkts) {
            RawPacket outPkt;
            if (inPkt == null || !this.match(template, inPkt) || (outPkt = transform ? srtpTransformer.transform(inPkt) : srtpTransformer.reverseTransform(inPkt)) == null) continue;
            outPkts.add(outPkt);
        }
        return outPkts;
    }

    private void clearQueue(LinkedList<RawPacket> q, RawPacket template) {
        long srtpTransformerLastChanged = this._srtpTransformerLastChanged;
        if (srtpTransformerLastChanged >= 0L && System.currentTimeMillis() - srtpTransformerLastChanged > 3000L) {
            q.clear();
            return;
        }
        Iterator it = q.iterator();
        while (it.hasNext()) {
            if (!this.match(template, (RawPacket)it.next())) continue;
            it.remove();
        }
    }

    private boolean match(RawPacket template, RawPacket pkt) {
        if (template == null) {
            return true;
        }
        if (pkt == null) {
            return false;
        }
        if (RTPPacketPredicate.INSTANCE.test(template)) {
            return template.getSSRC() == pkt.getSSRC() || template.getPayloadType() == pkt.getPayloadType();
        }
        if (RTCPPacketPredicate.INSTANCE.test(template)) {
            return template.getRTCPSSRC() == pkt.getRTCPSSRC();
        }
        return true;
    }

    static {
        DROP_UNENCRYPTED_PKTS_PNAME = DtlsPacketTransformer.class.getName() + ".dropUnencryptedPkts";
        logger = Logger.getLogger(DtlsPacketTransformer.class);
        TRANSFORM_QUEUE_CAPACITY = RTPConnectorOutputStream.PACKET_QUEUE_CAPACITY;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        DROP_UNENCRYPTED_PKTS = ConfigUtils.getBoolean(cfg, DROP_UNENCRYPTED_PKTS_PNAME, false);
    }
}

