/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.util.HashMap;
import java.util.Map;
import javax.sip.address.URI;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.ToHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.CustomHeader;
import net.java.sip.communicator.impl.protocol.sip.CustomHeaderList;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.util.Logger;

public class ConfigHeaders {
    public static final Logger logger = Logger.getLogger(ConfigHeaders.class);
    private static final String ACC_PROPERTY_CONFIG_HEADER = "ConfigHeader";
    private static final String ACC_PROPERTY_CONFIG_HEADER_NAME = "Name";
    private static final String ACC_PROPERTY_CONFIG_HEADER_VALUE = "Value";
    private static final String ACC_PROPERTY_CONFIG_HEADER_METHOD = "Method";

    static void attachConfigHeaders(Message message, ProtocolProviderServiceSipImpl protocolProvider) {
        if (message instanceof Response) {
            return;
        }
        Request request = (Request)message;
        Map props = protocolProvider.getAccountID().getAccountProperties();
        HashMap<String, HashMap<String, String>> headers = new HashMap<String, HashMap<String, String>>();
        for (Map.Entry entry : props.entrySet()) {
            String pName = (String)entry.getKey();
            String prefStr = (String)entry.getValue();
            if (!pName.startsWith(ACC_PROPERTY_CONFIG_HEADER) || prefStr == null) continue;
            prefStr = prefStr.trim();
            if (!pName.contains(".")) continue;
            pName = pName.replaceAll("ConfigHeader.", "");
            String name = pName.substring(pName.lastIndexOf(46) + 1).trim();
            if (!pName.contains(".")) continue;
            String ix = pName.substring(0, pName.lastIndexOf(46)).trim();
            HashMap<String, String> headerValues = (HashMap<String, String>)headers.get(ix);
            if (headerValues == null) {
                headerValues = new HashMap<String, String>();
                headers.put(ix, headerValues);
            }
            headerValues.put(name, prefStr);
        }
        for (Map headerValues : headers.values()) {
            String method = (String)headerValues.get(ACC_PROPERTY_CONFIG_HEADER_METHOD);
            if (method != null && !request.getMethod().equalsIgnoreCase(method) || !headerValues.containsKey(ACC_PROPERTY_CONFIG_HEADER_NAME) || !headerValues.containsKey(ACC_PROPERTY_CONFIG_HEADER_VALUE)) continue;
            try {
                String name = (String)headerValues.get(ACC_PROPERTY_CONFIG_HEADER_NAME);
                String value = ConfigHeaders.processParams((String)headerValues.get(ACC_PROPERTY_CONFIG_HEADER_VALUE), request);
                Header h = request.getHeader(name);
                if (h != null && !(h instanceof CustomHeader) || name.equals("Route")) {
                    request.setHeader(protocolProvider.getHeaderFactory().createHeader(name, value));
                    continue;
                }
                request.addHeader((Header)new CustomHeaderList(name, value));
            }
            catch (Exception e) {
                logger.error((Object)"Cannot create custom header", (Throwable)e);
            }
        }
    }

    private static String processParams(String value, Request request) {
        ToHeader toHeader;
        int index;
        FromHeader fromHeader;
        if (value.indexOf("${from.address}") != -1 && (fromHeader = (FromHeader)request.getHeader("From")) != null) {
            value = value.replace("${from.address}", fromHeader.getAddress().getURI().toString());
        }
        if (value.indexOf("${from.userID}") != -1 && (fromHeader = (FromHeader)request.getHeader("From")) != null) {
            URI fromURI = fromHeader.getAddress().getURI();
            String fromAddr = fromURI.toString();
            if (fromURI.isSipURI()) {
                fromAddr = fromAddr.replaceFirst(fromURI.getScheme() + ":", "");
            }
            if ((index = fromAddr.indexOf(64)) > -1) {
                fromAddr = fromAddr.substring(0, index);
            }
            value = value.replace("${from.userID}", fromAddr);
        }
        if (value.indexOf("${to.address}") != -1 && (toHeader = (ToHeader)request.getHeader("To")) != null) {
            value = value.replace("${to.address}", toHeader.getAddress().getURI().toString());
        }
        if (value.indexOf("${to.userID}") != -1 && (toHeader = (ToHeader)request.getHeader("To")) != null) {
            URI toURI = toHeader.getAddress().getURI();
            String toAddr = toURI.toString();
            if (toURI.isSipURI()) {
                toAddr = toAddr.replaceFirst(toURI.getScheme() + ":", "");
            }
            if ((index = toAddr.indexOf(64)) > -1) {
                toAddr = toAddr.substring(0, index);
            }
            value = value.replace("${to.userID}", toAddr);
        }
        return value;
    }
}

