/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.muc;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.impl.muc.ChatRoomContactSourceService;
import net.java.sip.communicator.impl.muc.MUCCustomContactActionService;
import net.java.sip.communicator.impl.muc.MUCGroupCustomContactActionService;
import net.java.sip.communicator.impl.muc.MUCServiceImpl;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.customcontactactions.CustomContactActionsService;
import net.java.sip.communicator.service.globaldisplaydetails.GlobalDisplayDetailsService;
import net.java.sip.communicator.service.gui.AlertUIService;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.msghistory.MessageHistoryService;
import net.java.sip.communicator.service.muc.MUCService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.AccountManager;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class MUCActivator
implements BundleActivator {
    private static final String DISABLED_PROPERTY = "net.java.sip.communicator.impl.muc.MUCSERVICE_DISABLED";
    static BundleContext bundleContext = null;
    private static ConfigurationService configService;
    private static List<ProtocolProviderService> chatRoomProviders;
    private static final ChatRoomContactSourceService chatRoomContactSource;
    private static ResourceManagementService resources;
    private static MUCServiceImpl mucService;
    private static AccountManager accountManager;
    private static AlertUIService alertUIService;
    private static CredentialsStorageService credentialsService;
    private static MUCCustomContactActionService mucCustomActionService;
    private static UIService uiService;
    private static ProtocolProviderRegListener protocolProviderRegListener;
    private static MessageHistoryService messageHistoryService;
    private static GlobalDisplayDetailsService globalDisplayDetailsService;

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        if (MUCActivator.getConfigurationService().getBoolean(DISABLED_PROPERTY, false)) {
            return;
        }
        bundleContext.registerService(ContactSourceService.class.getName(), (Object)chatRoomContactSource, null);
        mucService = new MUCServiceImpl();
        bundleContext.registerService(MUCService.class.getName(), (Object)mucService, null);
        mucCustomActionService = new MUCCustomContactActionService();
        bundleContext.registerService(CustomContactActionsService.class.getName(), (Object)mucCustomActionService, null);
        bundleContext.registerService(CustomContactActionsService.class.getName(), (Object)new MUCGroupCustomContactActionService(), null);
    }

    public void stop(BundleContext context) throws Exception {
        if (protocolProviderRegListener != null) {
            bundleContext.removeServiceListener((ServiceListener)protocolProviderRegListener);
        }
        if (chatRoomProviders != null) {
            chatRoomProviders.clear();
        }
    }

    public static MUCServiceImpl getMUCService() {
        return mucService;
    }

    public static ChatRoomContactSourceService getContactSource() {
        return chatRoomContactSource;
    }

    public static ResourceManagementService getResources() {
        if (resources == null) {
            resources = (ResourceManagementService)ServiceUtils.getService((BundleContext)bundleContext, ResourceManagementService.class);
        }
        return resources;
    }

    public static ConfigurationService getConfigurationService() {
        if (configService == null) {
            configService = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        }
        return configService;
    }

    public static AccountManager getAccountManager() {
        if (accountManager == null) {
            accountManager = (AccountManager)ServiceUtils.getService((BundleContext)bundleContext, AccountManager.class);
        }
        return accountManager;
    }

    public static AlertUIService getAlertUIService() {
        if (alertUIService == null) {
            alertUIService = (AlertUIService)ServiceUtils.getService((BundleContext)bundleContext, AlertUIService.class);
        }
        return alertUIService;
    }

    public static CredentialsStorageService getCredentialsStorageService() {
        if (credentialsService == null) {
            credentialsService = (CredentialsStorageService)ServiceUtils.getService((BundleContext)bundleContext, CredentialsStorageService.class);
        }
        return credentialsService;
    }

    public static List<ProtocolProviderService> getChatRoomProviders() {
        if (chatRoomProviders != null) {
            return chatRoomProviders;
        }
        chatRoomProviders = new LinkedList<ProtocolProviderService>();
        protocolProviderRegListener = new ProtocolProviderRegListener();
        bundleContext.addServiceListener((ServiceListener)protocolProviderRegListener);
        Collection serRefs = ServiceUtils.getServiceReferences((BundleContext)bundleContext, ProtocolProviderFactory.class);
        if (!serRefs.isEmpty()) {
            for (ServiceReference ppfSerRef : serRefs) {
                ProtocolProviderFactory providerFactory = (ProtocolProviderFactory)bundleContext.getService(ppfSerRef);
                for (AccountID accountID : providerFactory.getRegisteredAccounts()) {
                    ServiceReference ppsSerRef = providerFactory.getProviderForAccount(accountID);
                    ProtocolProviderService protocolProvider = (ProtocolProviderService)bundleContext.getService(ppsSerRef);
                    MUCActivator.handleProviderAdded(protocolProvider);
                }
            }
        }
        return chatRoomProviders;
    }

    private static void handleProviderAdded(ProtocolProviderService protocolProvider) {
        if (protocolProvider.getOperationSet(OperationSetMultiUserChat.class) != null && !chatRoomProviders.contains(protocolProvider)) {
            chatRoomProviders.add(protocolProvider);
        }
    }

    private static void handleProviderRemoved(ProtocolProviderService protocolProvider) {
        if (chatRoomProviders.contains(protocolProvider)) {
            chatRoomProviders.remove(protocolProvider);
        }
    }

    public static UIService getUIService() {
        if (uiService == null) {
            uiService = (UIService)ServiceUtils.getService((BundleContext)bundleContext, UIService.class);
        }
        return uiService;
    }

    public static GlobalDisplayDetailsService getGlobalDisplayDetailsService() {
        if (globalDisplayDetailsService == null) {
            globalDisplayDetailsService = (GlobalDisplayDetailsService)ServiceUtils.getService((BundleContext)bundleContext, GlobalDisplayDetailsService.class);
        }
        return globalDisplayDetailsService;
    }

    public static MessageHistoryService getMessageHistoryService() {
        if (messageHistoryService == null) {
            messageHistoryService = (MessageHistoryService)ServiceUtils.getService((BundleContext)bundleContext, MessageHistoryService.class);
        }
        return messageHistoryService;
    }

    static {
        chatRoomContactSource = new ChatRoomContactSourceService();
        resources = null;
        uiService = null;
        protocolProviderRegListener = null;
    }

    private static class ProtocolProviderRegListener
    implements ServiceListener {
        private ProtocolProviderRegListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            ServiceReference serviceRef = event.getServiceReference();
            if (serviceRef.getBundle().getState() == 16) {
                return;
            }
            Object service = bundleContext.getService(serviceRef);
            if (!(service instanceof ProtocolProviderService)) {
                return;
            }
            switch (event.getType()) {
                case 1: {
                    MUCActivator.handleProviderAdded((ProtocolProviderService)service);
                    break;
                }
                case 4: {
                    MUCActivator.handleProviderRemoved((ProtocolProviderService)service);
                }
            }
        }
    }
}

