/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.impl.protocol.irc.IrcActivator;
import net.java.sip.communicator.impl.protocol.irc.ProtocolIconIrcImpl;
import net.java.sip.communicator.service.protocol.PresenceStatus;

public final class IrcStatusEnum
extends PresenceStatus {
    public static final IrcStatusEnum OFFLINE = new IrcStatusEnum(0, "service.gui.OFFLINE", IrcStatusEnum.getImageInBytes("service.protocol.irc.OFFLINE_STATUS_ICON"));
    public static final IrcStatusEnum AWAY = new IrcStatusEnum(40, "service.gui.AWAY_STATUS", IrcStatusEnum.getImageInBytes("service.protocol.irc.AWAY_STATUS_ICON"));
    public static final IrcStatusEnum ONLINE = new IrcStatusEnum(65, "service.gui.ONLINE", IrcStatusEnum.getImageInBytes("service.protocol.irc.IRC_16x16"));
    private static final List<IrcStatusEnum> SUPPORTED_STATUS_SET;

    private IrcStatusEnum(int status, String statusName, byte[] statusIcon) {
        super(status, statusName, statusIcon);
    }

    static Iterator<IrcStatusEnum> supportedStatusSet() {
        return SUPPORTED_STATUS_SET.iterator();
    }

    public String getStatusName() {
        return IrcActivator.getResources().getI18NString(super.getStatusName());
    }

    private static byte[] getImageInBytes(String imageID) {
        return ProtocolIconIrcImpl.getImageInBytes(imageID);
    }

    static {
        LinkedList<IrcStatusEnum> statusSet = new LinkedList<IrcStatusEnum>();
        statusSet.add(ONLINE);
        statusSet.add(AWAY);
        statusSet.add(OFFLINE);
        SUPPORTED_STATUS_SET = Collections.unmodifiableList(statusSet);
    }
}

