/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.filetransfer;

import java.util.Date;
import net.java.sip.communicator.impl.gui.main.chat.filetransfer.FileTransferConversationComponent;
import net.java.sip.communicator.service.filehistory.FileRecord;

public class FileHistoryConversationComponent
extends FileTransferConversationComponent {
    private final FileRecord fileRecord;

    public FileHistoryConversationComponent(FileRecord fileRecord) {
        this.fileRecord = fileRecord;
        String contactName = fileRecord.getContact().getDisplayName();
        this.openFileButton.setVisible(true);
        this.openFolderButton.setVisible(true);
        String titleString = "";
        if (fileRecord.getDirection().equals("in")) {
            if (fileRecord.getStatus().equals("completed")) {
                titleString = resources.getI18NString("service.gui.FILE_RECEIVE_COMPLETED", new String[]{contactName});
                this.setWarningStyle(false);
            } else if (fileRecord.getStatus().equals("canceled")) {
                titleString = resources.getI18NString("service.gui.FILE_TRANSFER_CANCELED");
                this.setWarningStyle(true);
            } else if (fileRecord.getStatus().equals("failed")) {
                titleString = resources.getI18NString("service.gui.FILE_RECEIVE_FAILED", new String[]{contactName});
                this.setWarningStyle(true);
            } else if (fileRecord.getStatus().equals("refused")) {
                titleString = resources.getI18NString("service.gui.FILE_TRANSFER_REFUSED", new String[]{contactName});
                this.openFileButton.setVisible(false);
                this.openFolderButton.setVisible(false);
                this.setWarningStyle(true);
            }
        } else if (fileRecord.getDirection().equals("out")) {
            if (fileRecord.getStatus().equals("completed")) {
                titleString = resources.getI18NString("service.gui.FILE_SEND_COMPLETED", new String[]{contactName});
                this.setWarningStyle(false);
            } else if (fileRecord.getStatus().equals("canceled")) {
                titleString = resources.getI18NString("service.gui.FILE_TRANSFER_CANCELED");
                this.setWarningStyle(true);
            } else if (fileRecord.getStatus().equals("failed")) {
                titleString = resources.getI18NString("service.gui.FILE_UNABLE_TO_SEND", new String[]{contactName});
                this.setWarningStyle(true);
            } else if (fileRecord.getStatus().equals("refused")) {
                titleString = resources.getI18NString("service.gui.FILE_SEND_REFUSED", new String[]{contactName});
                this.setWarningStyle(true);
            }
        }
        this.setCompletedDownloadFile(fileRecord.getFile());
        Date date = fileRecord.getDate();
        this.titleLabel.setText(this.getDateString(date) + titleString);
        this.fileLabel.setText(this.getFileLabel(fileRecord.getFile()));
    }

    @Override
    public Date getDate() {
        return this.fileRecord.getDate();
    }

    @Override
    protected String getProgressLabel(String bytesString) {
        return "";
    }
}

