/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joustsim.JavaTools;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnectionProperties;
import net.kano.joustsim.oscar.AimSession;
import net.kano.joustsim.oscar.AppSession;
import net.kano.joustsim.oscar.BuddyIconTracker;
import net.kano.joustsim.oscar.BuddyInfoManager;
import net.kano.joustsim.oscar.BuddyInfoTracker;
import net.kano.joustsim.oscar.CapabilityManager;
import net.kano.joustsim.oscar.ConnectionManager;
import net.kano.joustsim.oscar.DefaultAimSession;
import net.kano.joustsim.oscar.DefaultEnabledCapabilityHandler;
import net.kano.joustsim.oscar.ExternalServiceManager;
import net.kano.joustsim.oscar.MyBuddyIconManager;
import net.kano.joustsim.oscar.OpenedServiceListener;
import net.kano.joustsim.oscar.OscarConnectionPreparer;
import net.kano.joustsim.oscar.SecurityEnabledHandler;
import net.kano.joustsim.oscar.State;
import net.kano.joustsim.oscar.StateEvent;
import net.kano.joustsim.oscar.StateInfo;
import net.kano.joustsim.oscar.StateListener;
import net.kano.joustsim.oscar.oscar.BasicConnection;
import net.kano.joustsim.oscar.oscar.LoginConnection;
import net.kano.joustsim.oscar.oscar.OscarConnListener;
import net.kano.joustsim.oscar.oscar.OscarConnStateEvent;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.Service;
import net.kano.joustsim.oscar.oscar.service.ServiceArbiter;
import net.kano.joustsim.oscar.oscar.service.bos.MainBosService;
import net.kano.joustsim.oscar.oscar.service.buddy.BuddyService;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomManager;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmService;
import net.kano.joustsim.oscar.oscar.service.info.BuddyTrustManager;
import net.kano.joustsim.oscar.oscar.service.info.CertificateInfoTrustManager;
import net.kano.joustsim.oscar.oscar.service.info.InfoService;
import net.kano.joustsim.oscar.oscar.service.login.LoginService;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiService;
import net.kano.joustsim.oscar.proxy.AimProxyInfo;
import net.kano.joustsim.trust.CertificateTrustManager;
import net.kano.joustsim.trust.SignerTrustManager;
import net.kano.joustsim.trust.TrustPreferences;
import net.kano.joustsim.trust.TrustedCertificatesTracker;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AimConnection {
    private static final Logger LOGGER = Logger.getLogger(AimConnection.class.getName());
    private final AppSession appSession;
    private final AimSession aimSession;
    private final Screenname screenname;
    private final Map<Integer, List<Service>> snacfamilies = new HashMap<Integer, List<Service>>();
    private final CopyOnWriteArrayList<OpenedServiceListener> serviceListeners = new CopyOnWriteArrayList();
    private final BuddyInfoManager buddyInfoManager;
    private final BuddyInfoTracker buddyInfoTracker;
    private final BuddyIconTracker buddyIconTracker;
    private final MyBuddyIconManager myBuddyIconManager;
    private final CertificateInfoTrustManager certificateInfoTrustManager;
    private final TrustedCertificatesTracker trustedCertificatesTracker;
    private final BuddyTrustManager buddyTrustManager;
    private final CapabilityManager capabilityManager;
    private final TrustPreferences localPrefs;
    private final ExternalServiceManager externalServiceMgr;
    private final ChatRoomManager chatRoomManager;
    private final ConnectionManager connectionManager;
    private volatile AimProxyInfo proxy = AimProxyInfo.forNoProxy();
    private volatile String passwordUrl = null;

    public AimConnection(Screenname screenname, String password) {
        this(new AimConnectionProperties(screenname, password));
    }

    public AimConnection(AimConnectionProperties props) {
        this(new DefaultAimSession(props.getScreenname()), props);
    }

    public AimConnection(AimSession aimSession, AimConnectionProperties props) {
        this(aimSession, aimSession.getTrustPreferences(), props);
    }

    public AimConnection(AimSession aimSession, TrustPreferences prefs, AimConnectionProperties props) throws IllegalArgumentException {
        Screenname sn = aimSession.getScreenname();
        if (!props.getScreenname().equals(sn)) {
            throw new IllegalArgumentException("connection properties object is for screenname " + props.getScreenname() + ", but " + "this connection is for " + sn);
        }
        DefensiveTools.checkNull(aimSession, "aimSession");
        DefensiveTools.checkNull(props, "props");
        if (!props.isComplete()) {
            throw new IllegalArgumentException("connection properties are incomplete (props.isComplete() == false): " + props);
        }
        this.appSession = aimSession.getAppSession();
        this.aimSession = aimSession;
        this.screenname = sn;
        this.localPrefs = prefs;
        this.connectionManager = new ConnectionManager(this, props);
        this.connectionManager.addConnectionPreparer(new OscarConnectionPreparer(){

            public void prepareMainBosConnection(ConnectionManager mgr, BasicConnection conn) {
                AimConnection.this.listenForSnacFamilies(conn);
            }

            public void prepareLoginConnection(ConnectionManager mgr, LoginConnection conn) {
                AimConnection.this.listenForSnacFamilies(conn);
            }
        });
        this.connectionManager.addStateListener(new StateListener(){

            public void handleStateChange(StateEvent event) {
                if (event.getNewState().isFinished()) {
                    List services = DefensiveTools.getUnmodifiable(AimConnection.this.getLocalServices());
                    for (OpenedServiceListener listener : AimConnection.this.serviceListeners) {
                        listener.closedServices(AimConnection.this, services);
                    }
                }
            }
        });
        this.buddyInfoManager = new BuddyInfoManager(this);
        this.buddyInfoTracker = new BuddyInfoTracker(this);
        this.buddyIconTracker = new BuddyIconTracker(this);
        this.myBuddyIconManager = new MyBuddyIconManager(this);
        this.trustedCertificatesTracker = this.createTrustedCertificatesTracker(prefs);
        this.certificateInfoTrustManager = new CertificateInfoTrustManager(this.trustedCertificatesTracker);
        this.buddyTrustManager = new BuddyTrustManager(this);
        this.capabilityManager = this.createCapabilityManager();
        this.externalServiceMgr = new ExternalServiceManager(this);
        this.chatRoomManager = new ChatRoomManager(this);
    }

    private void listenForSnacFamilies(OscarConnection conn) {
        conn.addOscarListener(new OscarConnListener(){

            public void registeredSnacFamilies(OscarConnection conn) {
                AimConnection.this.recordSnacFamilies(conn);
            }

            public void connStateChanged(OscarConnection conn, OscarConnStateEvent event) {
            }

            public void allFamiliesReady(OscarConnection conn) {
            }
        });
    }

    private synchronized List<Service> getLocalServices() {
        ArrayList<Service> list = new ArrayList<Service>();
        for (Map.Entry<Integer, List<Service>> entry : this.snacfamilies.entrySet()) {
            list.addAll((Collection<Service>)entry.getValue());
        }
        return list;
    }

    private CapabilityManager createCapabilityManager() {
        CapabilityManager mgr = new CapabilityManager(this);
        mgr.setCapabilityHandler(CapabilityBlock.BLOCK_ENCRYPTION, new SecurityEnabledHandler(this));
        mgr.setCapabilityHandler(CapabilityBlock.BLOCK_ICQCOMPATIBLE, new DefaultEnabledCapabilityHandler());
        mgr.setCapabilityHandler(CapabilityBlock.BLOCK_SHORTCAPS, new DefaultEnabledCapabilityHandler());
        mgr.setCapabilityHandler(CapabilityBlock.BLOCK_ICQ_UTF8, new DefaultEnabledCapabilityHandler());
        return mgr;
    }

    private TrustedCertificatesTracker createTrustedCertificatesTracker(TrustPreferences prefs) {
        SignerTrustManager signerMgr;
        CertificateTrustManager certMgr;
        if (prefs != null) {
            certMgr = prefs.getCertificateTrustManager();
            signerMgr = prefs.getSignerTrustManager();
        } else {
            LOGGER.warning("Warning: this AIM connection's certificate and signer managers will not be set because the trust manager is null");
            certMgr = null;
            signerMgr = null;
        }
        return new TrustedCertificatesTracker(certMgr, signerMgr);
    }

    public final AppSession getAppSession() {
        return this.appSession;
    }

    public final AimSession getAimSession() {
        return this.aimSession;
    }

    public final Screenname getScreenname() {
        return this.screenname;
    }

    public BuddyInfoManager getBuddyInfoManager() {
        return this.buddyInfoManager;
    }

    public BuddyIconTracker getBuddyIconTracker() {
        return this.buddyIconTracker;
    }

    public MyBuddyIconManager getMyBuddyIconManager() {
        return this.myBuddyIconManager;
    }

    public CertificateInfoTrustManager getCertificateInfoTrustManager() {
        return this.certificateInfoTrustManager;
    }

    public TrustedCertificatesTracker getTrustedCertificatesTracker() {
        return this.trustedCertificatesTracker;
    }

    public TrustPreferences getLocalPrefs() {
        return this.localPrefs;
    }

    public BuddyTrustManager getBuddyTrustManager() {
        return this.buddyTrustManager;
    }

    public CapabilityManager getCapabilityManager() {
        return this.capabilityManager;
    }

    public BuddyInfoTracker getBuddyInfoTracker() {
        return this.buddyInfoTracker;
    }

    public void addOpenedServiceListener(OpenedServiceListener l) {
        this.serviceListeners.addIfAbsent(l);
    }

    public void removeOpenedServiceListener(OpenedServiceListener l) {
        this.serviceListeners.remove(l);
    }

    @Nullable
    public synchronized Service getService(int family) {
        return this.getMutableService(family);
    }

    @Nullable
    private Service getMutableService(int family) {
        List<Service> list = this.getServiceListIfExists(family);
        return list == null ? null : list.get(0);
    }

    @Nullable
    private synchronized List<Service> getServiceListIfExists(int family) {
        List<Service> list = this.snacfamilies.get(family);
        return list == null || list.isEmpty() ? null : list;
    }

    public LoginService getLoginService() {
        return this.getServiceOfType(23, LoginService.class);
    }

    public MainBosService getBosService() {
        return this.getServiceOfType(1, MainBosService.class);
    }

    public IcbmService getIcbmService() {
        return this.getServiceOfType(4, IcbmService.class);
    }

    public BuddyService getBuddyService() {
        return this.getServiceOfType(3, BuddyService.class);
    }

    public InfoService getInfoService() {
        return this.getServiceOfType(2, InfoService.class);
    }

    public SsiService getSsiService() {
        return this.getServiceOfType(19, SsiService.class);
    }

    @Nullable
    private <E extends Service> E getServiceOfType(int fam, Class<E> cls) {
        Service service = this.getService(fam);
        if (cls.isInstance(service)) {
            return (E)((Service)JavaTools.cast(cls, service));
        }
        return null;
    }

    public void sendSnac(SnacCommand snac) {
        int family = snac.getFamily();
        Service service = this.getMutableService(family);
        if (service == null) {
            ServiceArbiter<? extends Service> arbiter = this.externalServiceMgr.getServiceArbiter(family);
            if (arbiter != null) {
                throw new IllegalStateException("can't send SNAC because the family is controlled by an arbiter: " + snac);
            }
        } else {
            service.getOscarConnection().sendSnac(snac);
        }
    }

    public ExternalServiceManager getExternalServiceManager() {
        return this.externalServiceMgr;
    }

    public ChatRoomManager getChatRoomManager() {
        return this.chatRoomManager;
    }

    public void addStateListener(StateListener l) {
        this.connectionManager.addStateListener(l);
    }

    public void removeStateListener(StateListener l) {
        this.connectionManager.removeStateListener(l);
    }

    public State getState() {
        return this.connectionManager.getState();
    }

    public StateInfo getStateInfo() {
        return this.connectionManager.getStateInfo();
    }

    public boolean isOnline() {
        return this.getState() == State.ONLINE;
    }

    public boolean connect() {
        return this.connectionManager.connect();
    }

    public boolean triedConnecting() {
        return this.connectionManager.triedConnecting();
    }

    public void disconnect() {
        this.connectionManager.disconnect(true);
    }

    public void disconnect(boolean onPurpose) {
        this.connectionManager.disconnect(onPurpose);
    }

    public boolean wantedDisconnect() {
        return this.connectionManager.wantedDisconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordSnacFamilies(OscarConnection conn) {
        ArrayList<Service> added = new ArrayList<Service>();
        AimConnection aimConnection = this;
        synchronized (aimConnection) {
            for (int family : conn.getSnacFamilies()) {
                List<Service> services = this.getServiceList(family);
                Service service = conn.getService(family);
                if (service == null) {
                    LOGGER.finer("Could not find service handler for family 0x" + Integer.toHexString(family));
                    continue;
                }
                services.add(service);
                added.add(service);
            }
        }
        List addedClone = DefensiveTools.getUnmodifiable(added);
        for (OpenedServiceListener listener : this.serviceListeners) {
            listener.openedServices(this, addedClone);
        }
    }

    private synchronized List<Service> getServiceList(int family) {
        List<Service> list = this.snacfamilies.get(family);
        if (list == null) {
            list = new ArrayList<Service>();
            this.snacfamilies.put(family, list);
        }
        return list;
    }

    public AimProxyInfo getProxy() {
        return this.proxy;
    }

    public void setProxy(AimProxyInfo proxy) {
        DefensiveTools.checkNull(proxy, "proxy");
        this.proxy = proxy;
    }

    public void setPasswordUrl(String passwordUrl) {
        this.passwordUrl = passwordUrl;
    }

    public String getChangePasswordUrl() {
        return this.passwordUrl;
    }
}

