/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;

public abstract class DNSEntry {
    private final String _key;
    private final String _name;
    private final String _type;
    private final DNSRecordType _recordType;
    private final DNSRecordClass _dnsClass;
    private final boolean _unique;
    final Map<ServiceInfo.Fields, String> _qualifiedNameMap;

    DNSEntry(String string, DNSRecordType dNSRecordType, DNSRecordClass dNSRecordClass, boolean bl) {
        this._name = string;
        this._recordType = dNSRecordType;
        this._dnsClass = dNSRecordClass;
        this._unique = bl;
        this._qualifiedNameMap = ServiceInfoImpl.decodeQualifiedNameMapForType(this.getName());
        String string2 = this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Domain);
        String string3 = this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Protocol);
        String string4 = this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Application);
        String string5 = this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Instance).toLowerCase();
        this._type = (string4.length() > 0 ? "_" + string4 + "." : "") + (string3.length() > 0 ? "_" + string3 + "." : "") + string2 + ".";
        this._key = ((string5.length() > 0 ? string5 + "." : "") + this._type).toLowerCase();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof DNSEntry) {
            DNSEntry dNSEntry = (DNSEntry)object;
            bl = this.getKey().equals(dNSEntry.getKey()) && this.getRecordType().equals((Object)dNSEntry.getRecordType()) && this.getRecordClass() == dNSEntry.getRecordClass();
        }
        return bl;
    }

    public boolean isSameEntry(DNSEntry dNSEntry) {
        return this.getKey().equals(dNSEntry.getKey()) && this.getRecordType().equals((Object)dNSEntry.getRecordType()) && (DNSRecordClass.CLASS_ANY == dNSEntry.getRecordClass() || this.getRecordClass().equals((Object)dNSEntry.getRecordClass()));
    }

    public boolean sameSubtype(DNSEntry dNSEntry) {
        return this.getSubtype().equals(dNSEntry.getSubtype());
    }

    public String getSubtype() {
        String string = this.getQualifiedNameMap().get((Object)ServiceInfo.Fields.Subtype);
        return string != null ? string : "";
    }

    public String getName() {
        return this._name != null ? this._name : "";
    }

    public String getType() {
        return this._type != null ? this._type : "";
    }

    public String getKey() {
        return this._key != null ? this._key : "";
    }

    public DNSRecordType getRecordType() {
        return this._recordType != null ? this._recordType : DNSRecordType.TYPE_IGNORE;
    }

    public DNSRecordClass getRecordClass() {
        return this._dnsClass != null ? this._dnsClass : DNSRecordClass.CLASS_UNKNOWN;
    }

    public boolean isUnique() {
        return this._unique;
    }

    public Map<ServiceInfo.Fields, String> getQualifiedNameMap() {
        return Collections.unmodifiableMap(this._qualifiedNameMap);
    }

    public boolean isServicesDiscoveryMetaQuery() {
        return this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Application).equals("dns-sd") && this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Instance).equals("_services");
    }

    public boolean isDomainDiscoveryQuery() {
        if (this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Application).equals("dns-sd")) {
            String string = this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Instance);
            return "b".equals(string) || "db".equals(string) || "r".equals(string) || "dr".equals(string) || "lb".equals(string);
        }
        return false;
    }

    public boolean isReverseLookup() {
        return this.isV4ReverseLookup() || this.isV6ReverseLookup();
    }

    public boolean isV4ReverseLookup() {
        return this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Domain).endsWith("in-addr.arpa");
    }

    public boolean isV6ReverseLookup() {
        return this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Domain).endsWith("ip6.arpa");
    }

    public abstract boolean isStale(long var1);

    public abstract boolean isExpired(long var1);

    public boolean isSameRecordClass(DNSEntry dNSEntry) {
        return dNSEntry != null && dNSEntry.getRecordClass() == this.getRecordClass();
    }

    public boolean isSameType(DNSEntry dNSEntry) {
        return dNSEntry != null && dNSEntry.getRecordType() == this.getRecordType();
    }

    protected void toByteArray(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this.getName().getBytes("UTF8"));
        dataOutputStream.writeShort(this.getRecordType().indexValue());
        dataOutputStream.writeShort(this.getRecordClass().indexValue());
    }

    protected byte[] toByteArray() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            this.toByteArray(dataOutputStream);
            dataOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new InternalError();
        }
    }

    public int compareTo(DNSEntry dNSEntry) {
        byte[] byArray = this.toByteArray();
        byte[] byArray2 = dNSEntry.toByteArray();
        int n = Math.min(byArray.length, byArray2.length);
        for (int i = 0; i < n; ++i) {
            if (byArray[i] > byArray2[i]) {
                return 1;
            }
            if (byArray[i] >= byArray2[i]) continue;
            return -1;
        }
        return byArray.length - byArray2.length;
    }

    public int hashCode() {
        return this.getKey().hashCode() + this.getRecordType().indexValue() + this.getRecordClass().indexValue();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("[" + this.getClass().getSimpleName() + "@" + System.identityHashCode(this));
        stringBuilder.append(" type: " + (Object)((Object)this.getRecordType()));
        stringBuilder.append(", class: " + (Object)((Object)this.getRecordClass()));
        stringBuilder.append(this._unique ? "-unique," : ",");
        stringBuilder.append(" name: " + this._name);
        this.toString(stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected void toString(StringBuilder stringBuilder) {
    }
}

