/*
 * Decompiled with CFR 0.152.
 */
package javajs.export;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javajs.util.SB;

class PDFObject
extends SB {
    private Map<String, Object> dictionary;
    private byte[] stream;
    private int index;
    String type;
    int len;
    int pt;

    PDFObject(int index) {
        this.index = index;
    }

    String getRef() {
        return this.index + " 0 R";
    }

    String getID() {
        return this.type.substring(0, 1) + this.index;
    }

    boolean isFont() {
        return "Font".equals(this.type);
    }

    void setStream(byte[] stream) {
        this.stream = stream;
    }

    Object getDef(String key) {
        return this.dictionary.get(key);
    }

    void addDef(String key, Object value) {
        if (this.dictionary == null) {
            this.dictionary = new Hashtable<String, Object>();
        }
        this.dictionary.put(key, value);
        if (key.equals("Type")) {
            this.type = ((String)value).substring(1);
        }
    }

    void setAsStream() {
        this.stream = this.toBytes(0, -1);
        this.setLength(0);
    }

    int output(OutputStream os) throws IOException {
        if (this.index > 0) {
            String s = this.index + " 0 obj\n";
            this.write(os, s.getBytes(), 0);
        }
        int streamLen = 0;
        if (this.dictionary != null) {
            if (this.dictionary.containsKey("Length")) {
                boolean doDeflate;
                if (this.stream == null) {
                    this.setAsStream();
                }
                boolean bl = doDeflate = (streamLen = this.stream.length) > 1000;
                if (doDeflate) {
                    Deflater deflater = new Deflater(9);
                    ByteArrayOutputStream outBytes = new ByteArrayOutputStream(1024);
                    DeflaterOutputStream compBytes = new DeflaterOutputStream((OutputStream)outBytes, deflater);
                    compBytes.write(this.stream, 0, streamLen);
                    compBytes.finish();
                    this.stream = outBytes.toByteArray();
                    this.dictionary.put("Filter", "/FlateDecode");
                    streamLen = this.stream.length;
                }
                this.dictionary.put("Length", "" + streamLen);
            }
            this.write(os, this.getDictionaryText(this.dictionary, "\n").getBytes(), 0);
        }
        if (this.length() > 0) {
            this.write(os, this.toString().getBytes(), 0);
        }
        if (this.stream != null) {
            this.write(os, "stream\r\n".getBytes(), 0);
            this.write(os, this.stream, streamLen);
            this.write(os, "\r\nendstream\r\n".getBytes(), 0);
        }
        if (this.index > 0) {
            this.write(os, "endobj\n".getBytes(), 0);
        }
        return this.len;
    }

    private void write(OutputStream os, byte[] bytes, int nBytes) throws IOException {
        if (nBytes == 0) {
            nBytes = bytes.length;
        }
        this.len += nBytes;
        os.write(bytes, 0, nBytes);
    }

    private String getDictionaryText(Map<String, Object> d, String nl) {
        SB sb = new SB();
        sb.append("<<");
        if (d.containsKey("Type")) {
            sb.append("/Type").appendO(d.get("Type"));
        }
        for (Map.Entry<String, Object> e : d.entrySet()) {
            String s = e.getKey();
            if (s.equals("Type") || s.startsWith("!")) continue;
            sb.append("/" + s);
            Object o = e.getValue();
            if (o instanceof Map) {
                sb.append(this.getDictionaryText((Map)o, ""));
                continue;
            }
            s = (String)e.getValue();
            if (!s.startsWith("/")) {
                sb.append(" ");
            }
            sb.appendO(s);
        }
        return sb.length() > 3 ? sb.append(">>").append(nl).toString() : "";
    }

    private Map<String, Object> createSubdict(Map<String, Object> d0, String dict) {
        Hashtable d = (Hashtable)d0.get(dict);
        if (d == null) {
            d = new Hashtable();
            d0.put(dict, d);
        }
        return d;
    }

    void addResource(String type, String key, String value) {
        Map<String, Object> r = this.createSubdict(this.dictionary, "Resources");
        if (type != null) {
            r = this.createSubdict(r, type);
        }
        r.put(key, value);
    }
}

