/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.JmolDataManager;
import org.jmol.c.VDW;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.JmolStateCreator;
import org.jmol.viewer.Viewer;

public class DataManager
implements JmolDataManager {
    private Map<String, Object[]> dataValues = new Hashtable<String, Object[]>();
    private Viewer vwr;

    @Override
    public JmolDataManager set(Viewer vwr) {
        this.vwr = vwr;
        return this;
    }

    @Override
    public void clear() {
        this.dataValues.clear();
    }

    @Override
    public void setData(String type, Object[] data, int arrayCount, int actualAtomCount, int matchField, int matchFieldColumnCount, int field, int fieldColumnCount) {
        if (type == null) {
            this.clear();
            return;
        }
        if ((type = type.toLowerCase()).equals("element_vdw")) {
            String stringData = ((String)data[1]).trim();
            if (stringData.length() == 0) {
                this.vwr.userVdwMars = null;
                this.vwr.userVdws = null;
                this.vwr.bsUserVdws = null;
                return;
            }
            if (this.vwr.bsUserVdws == null) {
                this.vwr.setUserVdw(this.vwr.defaultVdw);
            }
            Parser.parseFloatArrayFromMatchAndField(stringData, this.vwr.bsUserVdws, 1, 0, (int[])data[2], 2, 0, this.vwr.userVdws, 1);
            int i = this.vwr.userVdws.length;
            while (--i >= 0) {
                this.vwr.userVdwMars[i] = (int)Math.floor(this.vwr.userVdws[i] * 1000.0f);
            }
            return;
        }
        int depth = this.getType(data);
        Object val = data[1];
        if (depth == -1) {
            depth = val instanceof String ? 0 : (AU.isAF(val) ? 1 : (AU.isAFF(val) ? 2 : (AU.isAFFF(val) ? 3 : -1)));
            data[3] = depth;
        }
        if (data[2] != null && arrayCount > 0) {
            int i;
            BS bs;
            float[] f;
            boolean createNew = matchField != 0 || field != Integer.MIN_VALUE && field != Integer.MAX_VALUE;
            Object[] oldData = this.dataValues.get(type);
            float[] fArray = f = oldData == null || createNew ? new float[actualAtomCount] : AU.ensureLengthA((float[])oldData[1], actualAtomCount);
            if (depth == -1) {
                Logger.error("Cannot determine data type for " + val);
                return;
            }
            String stringData = depth == 0 ? (String)val : null;
            float[] floatData = depth == 1 ? (float[])val : null;
            String[] strData = null;
            if (field == Integer.MIN_VALUE && (strData = PT.getTokens(stringData)).length > 1) {
                field = 0;
            }
            if (field == Integer.MIN_VALUE) {
                bs = (BS)data[2];
                DataManager.setSelectedFloats(PT.parseFloat(stringData), bs, f);
            } else if (field == 0 || field == Integer.MAX_VALUE) {
                bs = (BS)data[2];
                if (floatData != null) {
                    int n = floatData.length;
                    if (n == bs.cardinality()) {
                        i = bs.nextSetBit(0);
                        int pt = 0;
                        while (i >= 0) {
                            f[i] = floatData[pt];
                            i = bs.nextSetBit(i + 1);
                            ++pt;
                        }
                    } else {
                        i = bs.nextSetBit(0);
                        while (i >= 0 && i < n) {
                            f[i] = floatData[i];
                            i = bs.nextSetBit(i + 1);
                        }
                    }
                } else {
                    Parser.parseFloatArrayBsData(strData == null ? PT.getTokens(stringData) : strData, bs, f);
                }
            } else if (matchField <= 0) {
                bs = (BS)data[2];
                Parser.parseFloatArrayFromMatchAndField(stringData, bs, 0, 0, null, field, fieldColumnCount, f, 1);
            } else {
                int[] iData = (int[])data[2];
                Parser.parseFloatArrayFromMatchAndField(stringData, null, matchField, matchFieldColumnCount, iData, field, fieldColumnCount, f, 1);
                bs = new BS();
                i = iData.length;
                while (--i >= 0) {
                    if (iData[i] < 0) continue;
                    bs.set(iData[i]);
                }
            }
            if (oldData != null && oldData[2] instanceof BS && !createNew) {
                bs.or((BS)oldData[2]);
            }
            data[3] = 1;
            data[2] = bs;
            data[1] = f;
            if (type.indexOf("property_atom.") == 0) {
                int tok = T.getSettableTokFromString(type = type.substring(14));
                if (tok == 0) {
                    Logger.error("Unknown atom property: " + type);
                    return;
                }
                int nValues = bs.cardinality();
                float[] fValues = new float[nValues];
                int n = 0;
                int i2 = bs.nextSetBit(0);
                while (n < nValues) {
                    fValues[n++] = f[i2];
                    i2 = bs.nextSetBit(i2 + 1);
                }
                this.vwr.setAtomProperty(bs, tok, 0, 0.0f, null, fValues, null);
                return;
            }
        }
        this.dataValues.put(type, data);
    }

    private int getType(Object[] data) {
        return (Integer)data[3];
    }

    private static void setSelectedFloats(float f, BS bs, float[] data) {
        int i0;
        boolean isAll = bs == null;
        int i = i0 = isAll ? 0 : bs.nextSetBit(0);
        while (i >= 0 && i < data.length) {
            data[i] = f;
            i = isAll ? i + 1 : bs.nextSetBit(i + 1);
        }
    }

    @Override
    public Object getData(String label, BS bsSelected, int dataType) {
        if (this.dataValues.size() == 0 || label == null) {
            return null;
        }
        label = label.toLowerCase();
        switch (dataType) {
            case -2: 
            case -1: {
                if (!label.equals("types")) {
                    return this.dataValues.get(label);
                }
                String[] info = new String[]{"types", ""};
                int nv = 0;
                for (String name : this.dataValues.keySet()) {
                    info[1] = info[1] + (nv++ > 0 ? "\n" : "") + name;
                }
                return info;
            }
        }
        Object[] data = this.dataValues.get(label);
        if (data == null || this.getType(data) != dataType) {
            return null;
        }
        if (bsSelected == null) {
            return data[1];
        }
        float[] f = (float[])data[1];
        float[] fnew = new float[bsSelected.cardinality()];
        int i = 0;
        int n = f.length;
        int p = bsSelected.nextSetBit(0);
        while (p >= 0 && i < n) {
            fnew[i++] = f[p];
            p = bsSelected.nextSetBit(p + 1);
        }
        return fnew;
    }

    @Override
    public void deleteModelAtoms(int firstAtomIndex, int nAtoms, BS bsDeleted) {
        if (this.dataValues.size() == 0) {
            return;
        }
        for (String name : this.dataValues.keySet()) {
            if (name.indexOf("property_") != 0) continue;
            Object[] obj = this.dataValues.get(name);
            BSUtil.deleteBits((BS)obj[2], bsDeleted);
            obj[1] = AU.deleteElements(obj[1], firstAtomIndex, nAtoms);
        }
    }

    @Override
    public String getDefaultVdwNameOrData(VDW type, BS bs) {
        SB sb = new SB();
        sb.append(type.getVdwLabel()).append("\n");
        boolean isAll = bs == null;
        int i0 = isAll ? 1 : bs.nextSetBit(0);
        int i1 = isAll ? Elements.elementNumberMax : bs.length();
        int i = i0;
        while (i < i1 && i >= 0) {
            sb.appendI(i).appendC('\t').appendF(type == VDW.USER ? this.vwr.userVdws[i] : (float)Elements.getVanderwaalsMar(i, type) / 1000.0f).appendC('\t').append(Elements.elementSymbolFromNumber(i)).appendC('\n');
            i = isAll ? i + 1 : bs.nextSetBit(i + 1);
        }
        return bs == null ? sb.toString() : "\n  DATA \"element_vdw\"\n" + sb.append("  end \"element_vdw\";\n\n").toString();
    }

    @Override
    public boolean getDataState(JmolStateCreator sc, SB sb) {
        if (this.dataValues.size() == 0) {
            return false;
        }
        boolean haveData = false;
        for (String name : this.dataValues.keySet()) {
            Object[] obj;
            Object data;
            if (name.indexOf("property_") == 0) {
                Object[] obj2 = this.dataValues.get(name);
                if (obj2.length > 4 && !((Boolean)obj2[4]).booleanValue()) continue;
                haveData = true;
                Object data2 = obj2[1];
                if (data2 != null && this.getType(obj2) == 1) {
                    sc.getAtomicPropertyStateBuffer(sb, 17, (BS)obj2[2], name, (float[])data2);
                    sb.append("\n");
                    continue;
                }
                sb.append("\n").append(Escape.encapsulateData(name, data2, -1));
                continue;
            }
            int type = name.indexOf("data2d") == 0 ? 2 : (name.indexOf("data3d") == 0 ? 3 : -1);
            if (type == -1 || (data = (obj = this.dataValues.get(name))[1]) == null || this.getType(obj) != type) continue;
            haveData = true;
            sb.append("\n").append(Escape.encapsulateData(name, data, type));
        }
        return haveData;
    }

    @Override
    public Object[] createFileData(String strModel) {
        Object[] o = new Object[4];
        o[0] = "model";
        o[1] = strModel;
        o[3] = 0;
        return o;
    }
}

