/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.list.IntArrayList;
import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Property;
import cern.jet.math.Mult;
import cern.jet.math.PlusMult;
import java.io.Serializable;

public class LUDecompositionQuick
implements Serializable {
    static final long serialVersionUID = 1020L;
    protected DoubleMatrix2D LU;
    protected int pivsign;
    protected int[] piv;
    protected boolean isNonSingular;
    protected Algebra algebra;
    protected transient double[] workDouble;
    protected transient int[] work1;
    protected transient int[] work2;

    public LUDecompositionQuick() {
        this(Property.DEFAULT.tolerance());
    }

    public LUDecompositionQuick(double tolerance) {
        this.algebra = new Algebra(tolerance);
    }

    public void decompose(DoubleMatrix2D A) {
        int CUT_OFF = 10;
        this.LU = A;
        int m = A.rows();
        int n = A.columns();
        if (this.piv == null || this.piv.length != m) {
            this.piv = new int[m];
        }
        int i = m;
        while (--i >= 0) {
            this.piv[i] = i;
        }
        this.pivsign = 1;
        if (m * n == 0) {
            this.setLU(this.LU);
            return;
        }
        DoubleMatrix1D[] LUrows = new DoubleMatrix1D[m];
        for (int i2 = 0; i2 < m; ++i2) {
            LUrows[i2] = this.LU.viewRow(i2);
        }
        IntArrayList nonZeroIndexes = new IntArrayList();
        DoubleMatrix1D LUcolj = this.LU.viewColumn(0).like();
        Mult multFunction = Mult.mult(0.0);
        for (int j = 0; j < n; ++j) {
            double jj;
            LUcolj.assign(this.LU.viewColumn(j));
            int maxCardinality = m / 10;
            LUcolj.getNonZeros(nonZeroIndexes, null, maxCardinality);
            int cardinality = nonZeroIndexes.size();
            boolean sparse = cardinality < maxCardinality;
            for (int i3 = 0; i3 < m; ++i3) {
                int kmax = Math.min(i3, j);
                double s = sparse ? LUrows[i3].zDotProduct(LUcolj, 0, kmax, nonZeroIndexes) : LUrows[i3].zDotProduct(LUcolj, 0, kmax);
                double before = LUcolj.getQuick(i3);
                double after = before - s;
                LUcolj.setQuick(i3, after);
                this.LU.setQuick(i3, j, after);
                if (!sparse) continue;
                if (before == 0.0 && after != 0.0) {
                    int pos = nonZeroIndexes.binarySearch(i3);
                    pos = -pos - 1;
                    nonZeroIndexes.beforeInsert(pos, i3);
                }
                if (before == 0.0 || after != 0.0) continue;
                nonZeroIndexes.remove(nonZeroIndexes.binarySearch(i3));
            }
            int p = j;
            if (p < m) {
                double max = Math.abs(LUcolj.getQuick(p));
                for (int i4 = j + 1; i4 < m; ++i4) {
                    double v = Math.abs(LUcolj.getQuick(i4));
                    if (!(v > max)) continue;
                    p = i4;
                    max = v;
                }
            }
            if (p != j) {
                LUrows[p].swap(LUrows[j]);
                int k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            if (j >= m || (jj = this.LU.getQuick(j, j)) == 0.0) continue;
            multFunction.multiplicator = 1.0 / jj;
            this.LU.viewColumn(j).viewPart(j + 1, m - (j + 1)).assign(multFunction);
        }
        this.setLU(this.LU);
    }

    public void decompose(DoubleMatrix2D A, int semiBandwidth) {
        if (!this.algebra.property().isSquare(A) || semiBandwidth < 0 || semiBandwidth > 2) {
            this.decompose(A);
            return;
        }
        this.LU = A;
        int m = A.rows();
        int n = A.columns();
        if (this.piv == null || this.piv.length != m) {
            this.piv = new int[m];
        }
        int i = m;
        while (--i >= 0) {
            this.piv[i] = i;
        }
        this.pivsign = 1;
        if (m * n == 0) {
            this.setLU(A);
            return;
        }
        if (semiBandwidth == 2) {
            if (n > 1) {
                A.setQuick(1, 0, A.getQuick(1, 0) / A.getQuick(0, 0));
            }
            for (i = 1; i < n; ++i) {
                double ei = A.getQuick(i, i) - A.getQuick(i, i - 1) * A.getQuick(i - 1, i);
                A.setQuick(i, i, ei);
                if (i >= n - 1) continue;
                A.setQuick(i + 1, i, A.getQuick(i + 1, i) / ei);
            }
        }
        this.setLU(A);
    }

    public double det() {
        int n;
        int m = this.m();
        if (m != (n = this.n())) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        if (!this.isNonsingular()) {
            return 0.0;
        }
        double det = this.pivsign;
        for (int j = 0; j < n; ++j) {
            det *= this.LU.getQuick(j, j);
        }
        return det;
    }

    protected double[] getDoublePivot() {
        int m = this.m();
        double[] vals = new double[m];
        for (int i = 0; i < m; ++i) {
            vals[i] = this.piv[i];
        }
        return vals;
    }

    public DoubleMatrix2D getL() {
        return this.lowerTriangular(this.LU.copy());
    }

    public DoubleMatrix2D getLU() {
        return this.LU.copy();
    }

    public int[] getPivot() {
        return this.piv;
    }

    public DoubleMatrix2D getU() {
        return this.upperTriangular(this.LU.copy());
    }

    public boolean isNonsingular() {
        return this.isNonSingular;
    }

    protected boolean isNonsingular(DoubleMatrix2D matrix) {
        int m = matrix.rows();
        int n = matrix.columns();
        double epsilon = this.algebra.property().tolerance();
        int j = Math.min(n, m);
        while (--j >= 0) {
            if (!(Math.abs(matrix.getQuick(j, j)) <= epsilon)) continue;
            return false;
        }
        return true;
    }

    protected DoubleMatrix2D lowerTriangular(DoubleMatrix2D A) {
        int min;
        int rows = A.rows();
        int columns = A.columns();
        int r = min = Math.min(rows, columns);
        while (--r >= 0) {
            int c = min;
            while (--c >= 0) {
                if (r < c) {
                    A.setQuick(r, c, 0.0);
                    continue;
                }
                if (r != c) continue;
                A.setQuick(r, c, 1.0);
            }
        }
        if (columns > rows) {
            A.viewPart(0, min, rows, columns - min).assign(0.0);
        }
        return A;
    }

    protected int m() {
        return this.LU.rows();
    }

    protected int n() {
        return this.LU.columns();
    }

    public void setLU(DoubleMatrix2D LU2) {
        this.LU = LU2;
        this.isNonSingular = this.isNonsingular(LU2);
    }

    public void solve(DoubleMatrix1D B) {
        double v;
        int i;
        double f;
        int k;
        this.algebra.property().checkRectangular(this.LU);
        int m = this.m();
        int n = this.n();
        if (B.size() != m) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("Matrix is singular.");
        }
        if (this.workDouble == null || this.workDouble.length < m) {
            this.workDouble = new double[m];
        }
        this.algebra.permute(B, this.piv, this.workDouble);
        if (m * n == 0) {
            return;
        }
        for (k = 0; k < n; ++k) {
            f = B.getQuick(k);
            if (f == 0.0) continue;
            for (i = k + 1; i < n; ++i) {
                v = this.LU.getQuick(i, k);
                if (v == 0.0) continue;
                B.setQuick(i, B.getQuick(i) - f * v);
            }
        }
        for (k = n - 1; k >= 0; --k) {
            B.setQuick(k, B.getQuick(k) / this.LU.getQuick(k, k));
            f = B.getQuick(k);
            if (f == 0.0) continue;
            for (i = 0; i < k; ++i) {
                v = this.LU.getQuick(i, k);
                if (v == 0.0) continue;
                B.setQuick(i, B.getQuick(i) - f * v);
            }
        }
    }

    public void solve(DoubleMatrix2D B) {
        int i;
        boolean sparse;
        int cardinality;
        int maxCardinality;
        int k;
        int CUT_OFF = 10;
        this.algebra.property().checkRectangular(this.LU);
        int m = this.m();
        int n = this.n();
        if (B.rows() != m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("Matrix is singular.");
        }
        if (this.work1 == null || this.work1.length < m) {
            this.work1 = new int[m];
        }
        this.algebra.permuteRows(B, this.piv, this.work1);
        if (m * n == 0) {
            return;
        }
        int nx = B.columns();
        DoubleMatrix1D[] Brows = new DoubleMatrix1D[n];
        for (int k2 = 0; k2 < n; ++k2) {
            Brows[k2] = B.viewRow(k2);
        }
        Mult div = Mult.div(0.0);
        PlusMult minusMult = PlusMult.minusMult(0.0);
        IntArrayList nonZeroIndexes = new IntArrayList();
        DoubleMatrix1D Browk = DoubleFactory1D.dense.make(nx);
        for (k = 0; k < n; ++k) {
            Browk.assign(Brows[k]);
            maxCardinality = nx / 10;
            Browk.getNonZeros(nonZeroIndexes, null, maxCardinality);
            cardinality = nonZeroIndexes.size();
            sparse = cardinality < maxCardinality;
            for (i = k + 1; i < n; ++i) {
                minusMult.multiplicator = -this.LU.getQuick(i, k);
                if (minusMult.multiplicator == 0.0) continue;
                if (sparse) {
                    Brows[i].assign(Browk, minusMult, nonZeroIndexes);
                    continue;
                }
                Brows[i].assign(Browk, minusMult);
            }
        }
        for (k = n - 1; k >= 0; --k) {
            div.multiplicator = 1.0 / this.LU.getQuick(k, k);
            Brows[k].assign(div);
            if (Browk == null) {
                Browk = DoubleFactory1D.dense.make(B.columns());
            }
            Browk.assign(Brows[k]);
            maxCardinality = nx / 10;
            Browk.getNonZeros(nonZeroIndexes, null, maxCardinality);
            cardinality = nonZeroIndexes.size();
            sparse = cardinality < maxCardinality;
            for (i = 0; i < k; ++i) {
                minusMult.multiplicator = -this.LU.getQuick(i, k);
                if (minusMult.multiplicator == 0.0) continue;
                if (sparse) {
                    Brows[i].assign(Browk, minusMult, nonZeroIndexes);
                    continue;
                }
                Brows[i].assign(Browk, minusMult);
            }
        }
    }

    private void solveOld(DoubleMatrix2D B) {
        int j;
        int k;
        this.algebra.property().checkRectangular(this.LU);
        int m = this.m();
        int n = this.n();
        if (B.rows() != m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("Matrix is singular.");
        }
        int nx = B.columns();
        if (this.work1 == null || this.work1.length < m) {
            this.work1 = new int[m];
        }
        this.algebra.permuteRows(B, this.piv, this.work1);
        for (k = 0; k < n; ++k) {
            for (int i = k + 1; i < n; ++i) {
                double mult = this.LU.getQuick(i, k);
                if (mult == 0.0) continue;
                for (j = 0; j < nx; ++j) {
                    B.setQuick(i, j, B.getQuick(i, j) - B.getQuick(k, j) * mult);
                }
            }
        }
        for (k = n - 1; k >= 0; --k) {
            double mult = 1.0 / this.LU.getQuick(k, k);
            if (mult != 1.0) {
                for (int j2 = 0; j2 < nx; ++j2) {
                    B.setQuick(k, j2, B.getQuick(k, j2) * mult);
                }
            }
            for (int i = 0; i < k; ++i) {
                mult = this.LU.getQuick(i, k);
                if (mult == 0.0) continue;
                for (j = 0; j < nx; ++j) {
                    B.setQuick(i, j, B.getQuick(i, j) - B.getQuick(k, j) * mult);
                }
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String unknown = "Illegal operation or error: ";
        buf.append("-----------------------------------------------------------------------------\n");
        buf.append("LUDecompositionQuick(A) --> isNonSingular(A), det(A), pivot, L, U, inverse(A)\n");
        buf.append("-----------------------------------------------------------------------------\n");
        buf.append("isNonSingular = ");
        try {
            buf.append(String.valueOf(this.isNonsingular()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\ndet = ");
        try {
            buf.append(String.valueOf(this.det()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\npivot = ");
        try {
            buf.append(String.valueOf(new IntArrayList(this.getPivot())));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\n\nL = ");
        try {
            buf.append(String.valueOf(this.getL()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\n\nU = ");
        try {
            buf.append(String.valueOf(this.getU()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\n\ninverse(A) = ");
        DoubleMatrix2D identity = DoubleFactory2D.dense.identity(this.LU.rows());
        try {
            this.solve(identity);
            buf.append(String.valueOf(identity));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        return buf.toString();
    }

    protected DoubleMatrix2D upperTriangular(DoubleMatrix2D A) {
        int min;
        int rows = A.rows();
        int columns = A.columns();
        int r = min = Math.min(rows, columns);
        while (--r >= 0) {
            int c = min;
            while (--c >= 0) {
                if (r <= c) continue;
                A.setQuick(r, c, 0.0);
            }
        }
        if (columns < rows) {
            A.viewPart(min, 0, rows - min, columns).assign(0.0);
        }
        return A;
    }

    private double[] xgetDoublePivot() {
        int m = this.m();
        double[] vals = new double[m];
        for (int i = 0; i < m; ++i) {
            vals[i] = this.piv[i];
        }
        return vals;
    }
}

