/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Matrix2DMatrix2DFunction;

class Smp {
    protected FJTaskRunnerGroup taskGroup;
    protected int maxThreads;

    protected Smp(int maxThreads) {
        this.maxThreads = maxThreads = Math.max(1, maxThreads);
        this.taskGroup = maxThreads > 1 ? new FJTaskRunnerGroup(maxThreads) : null;
    }

    public void finalize() {
        if (this.taskGroup != null) {
            this.taskGroup.interruptAll();
        }
    }

    protected void run(final DoubleMatrix2D[] blocksA, final DoubleMatrix2D[] blocksB, final double[] results, final Matrix2DMatrix2DFunction function) {
        final FJTask[] subTasks = new FJTask[blocksA.length];
        for (int i = 0; i < blocksA.length; ++i) {
            final int k = i;
            subTasks[i] = new FJTask(){

                @Override
                public void run() {
                    double result = function.apply(blocksA[k], blocksB != null ? blocksB[k] : null);
                    if (results != null) {
                        results[k] = result;
                    }
                }
            };
        }
        try {
            this.taskGroup.invoke(new FJTask(){

                @Override
                public void run() {
                    2.coInvoke(subTasks);
                }
            });
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
    }

    protected DoubleMatrix2D[] splitBlockedNN(DoubleMatrix2D A, int threshold, long flops) {
        int noOfTasks = (int)Math.min(flops / (long)threshold, (long)this.maxThreads);
        boolean splitHoriz = A.columns() < noOfTasks;
        int p = splitHoriz ? A.rows() : A.columns();
        noOfTasks = Math.min(p, noOfTasks);
        if (noOfTasks < 2) {
            return null;
        }
        int span = p / noOfTasks;
        DoubleMatrix2D[] blocks = new DoubleMatrix2D[noOfTasks];
        for (int i = 0; i < noOfTasks; ++i) {
            int offset = i * span;
            if (i == noOfTasks - 1) {
                span = p - span * i;
            }
            blocks[i] = !splitHoriz ? A.viewPart(0, offset, A.rows(), span) : A.viewPart(offset, 0, span, A.columns());
        }
        return blocks;
    }

    protected DoubleMatrix2D[][] splitBlockedNN(DoubleMatrix2D A, DoubleMatrix2D B, int threshold, long flops) {
        DoubleMatrix2D[] blocksA = this.splitBlockedNN(A, threshold, flops);
        if (blocksA == null) {
            return null;
        }
        DoubleMatrix2D[] blocksB = this.splitBlockedNN(B, threshold, flops);
        if (blocksB == null) {
            return null;
        }
        DoubleMatrix2D[][] blocks = new DoubleMatrix2D[][]{blocksA, blocksB};
        return blocks;
    }

    protected DoubleMatrix2D[] splitStridedNN(DoubleMatrix2D A, int threshold, long flops) {
        int noOfTasks = (int)Math.min(flops / (long)threshold, (long)this.maxThreads);
        boolean splitHoriz = A.columns() < noOfTasks;
        int p = splitHoriz ? A.rows() : A.columns();
        noOfTasks = Math.min(p, noOfTasks);
        if (noOfTasks < 2) {
            return null;
        }
        int span = p / noOfTasks;
        DoubleMatrix2D[] blocks = new DoubleMatrix2D[noOfTasks];
        for (int i = 0; i < noOfTasks; ++i) {
            int offset = i * span;
            if (i == noOfTasks - 1) {
                span = p - span * i;
            }
            blocks[i] = !splitHoriz ? A.viewPart(0, i, A.rows(), A.columns() - i).viewStrides(1, noOfTasks) : A.viewPart(i, 0, A.rows() - i, A.columns()).viewStrides(noOfTasks, 1);
        }
        return blocks;
    }

    public void stats() {
        if (this.taskGroup != null) {
            this.taskGroup.stats();
        }
    }
}

