/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.TGPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

public class Node {
    public static final int TYPE_RECTANGLE = 1;
    public static final int TYPE_ROUNDRECT = 2;
    public static final int TYPE_ELLIPSE = 3;
    public static final int TYPE_CIRCLE = 4;
    public static final Font SMALL_TAG_FONT = new Font("Courier", 0, 9);
    public Color BACK_FIXED_COLOR = new Color(255, 32, 20);
    public Color BACK_SELECT_COLOR = new Color(225, 164, 0);
    public Color BACK_DEFAULT_COLOR = Color.decode("#4080A0");
    public Color BACK_HILIGHT_COLOR = new Color(205, 192, 166);
    public Color BACK_MRF_COLOR = new Color(2, 35, 81);
    public Color BACK_JML_COLOR = new Color(58, 176, 255);
    public Color BORDER_DRAG_COLOR = new Color(130, 130, 180);
    public Color BORDER_MOUSE_OVER_COLOR = new Color(160, 160, 180);
    public Color BORDER_INACTIVE_COLOR = new Color(30, 50, 160);
    public Color TEXT_COLOR = Color.white;
    public static Font TEXT_FONT = new Font("Verdana", 0, 10);
    public static int DEFAULT_TYPE = 1;
    protected int typ = 1;
    private String id;
    public double drawx;
    public double drawy;
    protected FontMetrics fontMetrics;
    protected Font font;
    protected String lbl;
    protected Color backColor = this.BACK_DEFAULT_COLOR;
    protected Color textColor = this.TEXT_COLOR;
    public double x;
    public double y;
    public double massfade = 1.0;
    protected double dx;
    protected double dy;
    protected boolean fixed;
    protected int repulsion;
    public boolean justMadeLocal = false;
    public boolean markedForRemoval = false;
    public int visibleEdgeCnt;
    protected boolean visible;
    private Vector edges;
    private String strUrl;

    public Node() {
        this.initialize(null);
        this.lbl = this.id;
    }

    public Node(String id) {
        this.initialize(id);
        this.lbl = id;
    }

    public Node(String id, String label) {
        this.initialize(id);
        this.lbl = label == null ? id : label;
    }

    public Node(String id, int type, Color color, String label) {
        this.initialize(id);
        this.typ = type;
        this.backColor = color;
        this.lbl = label == null ? id : label;
    }

    private void initialize(String identifier) {
        this.id = identifier;
        this.edges = new Vector();
        this.x = Math.random() * 2.0 - 1.0;
        this.y = Math.random() * 2.0 - 1.0;
        this.repulsion = 100;
        this.font = TEXT_FONT;
        this.fixed = false;
        this.typ = DEFAULT_TYPE;
        this.visibleEdgeCnt = 0;
        this.visible = false;
    }

    public void setNodeBackFixedColor(Color color) {
        this.BACK_FIXED_COLOR = color;
    }

    public void setNodeBackSelectColor(Color color) {
        this.BACK_SELECT_COLOR = color;
    }

    public void setNodeBackDefaultColor(Color color) {
        this.BACK_DEFAULT_COLOR = color;
    }

    public void setNodeBackHilightColor(Color color) {
        this.BACK_HILIGHT_COLOR = color;
    }

    public void setNodeBorderDragColor(Color color) {
        this.BORDER_DRAG_COLOR = color;
    }

    public void setNodeBorderMouseOverColor(Color color) {
        this.BORDER_MOUSE_OVER_COLOR = color;
    }

    public void setNodeBorderInactiveColor(Color color) {
        this.BORDER_INACTIVE_COLOR = color;
    }

    public void setNodeTextColor(Color color) {
        this.TEXT_COLOR = color;
    }

    public void setNodeTextFont(Font font) {
        TEXT_FONT = font;
    }

    public void setNodeType(int type) {
        DEFAULT_TYPE = type;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public void setLocation(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Point getLocation() {
        return new Point((int)this.x, (int)this.y);
    }

    public void setVisible(boolean v) {
        this.visible = v;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setType(int type) {
        this.typ = type;
    }

    public int getType() {
        return this.typ;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setBackColor(Color bgColor) {
        this.backColor = bgColor;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setTextColor(Color txtColor) {
        this.textColor = txtColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setLabel(String label) {
        this.lbl = label;
    }

    public String getLabel() {
        return this.lbl;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public boolean getFixed() {
        return this.fixed;
    }

    public int edgeNum() {
        return this.edges.size();
    }

    public int edgeCount() {
        return this.edges.size();
    }

    public int visibleEdgeCount() {
        return this.visibleEdgeCnt;
    }

    public Edge edgeAt(int index) {
        return (Edge)this.edges.elementAt(index);
    }

    public void addEdge(Edge edge) {
        if (edge == null) {
            return;
        }
        this.edges.addElement(edge);
    }

    public void removeEdge(Edge edge) {
        this.edges.removeElement(edge);
    }

    public int getWidth() {
        if (this.fontMetrics != null && this.lbl != null) {
            return this.fontMetrics.stringWidth(this.lbl) + 12;
        }
        return 10;
    }

    public int getHeight() {
        if (this.fontMetrics != null) {
            return this.fontMetrics.getHeight() + 6;
        }
        return 6;
    }

    public boolean intersects(Dimension d) {
        return this.drawx > 0.0 && this.drawx < (double)d.width && this.drawy > 0.0 && this.drawy < (double)d.height;
    }

    public boolean containsPoint(double px, double py) {
        return px > this.drawx - (double)(this.getWidth() / 2) && px < this.drawx + (double)(this.getWidth() / 2) && py > this.drawy - (double)(this.getHeight() / 2) && py < this.drawy + (double)(this.getHeight() / 2);
    }

    public boolean containsPoint(Point p) {
        return (double)p.x > this.drawx - (double)(this.getWidth() / 2) && (double)p.x < this.drawx + (double)(this.getWidth() / 2) && (double)p.y > this.drawy - (double)(this.getHeight() / 2) && (double)p.y < this.drawy + (double)(this.getHeight() / 2);
    }

    public void paint(Graphics g, TGPanel tgPanel) {
        if (!this.intersects(tgPanel.getSize())) {
            return;
        }
        this.paintNodeBody(g, tgPanel);
        if (this.visibleEdgeCount() < this.edgeCount()) {
            int ix = (int)this.drawx;
            int iy = (int)this.drawy;
            int h = this.getHeight();
            int w = this.getWidth();
            int tagX = ix + (w - 7) / 2 - 2 + w % 2;
            int tagY = iy - h / 2 - 2;
            int hiddenEdgeCount = this.edgeCount() - this.visibleEdgeCount();
            char character = hiddenEdgeCount < 9 ? (char)(48 + hiddenEdgeCount) : (char)'*';
            this.paintSmallTag(g, tgPanel, tagX, tagY, Color.red, Color.white, character);
        }
    }

    public Color getPaintBorderColor(TGPanel tgPanel) {
        if (this == tgPanel.getDragNode()) {
            return this.BORDER_DRAG_COLOR;
        }
        if (this == tgPanel.getMouseOverN()) {
            return this.BORDER_MOUSE_OVER_COLOR;
        }
        return this.BORDER_INACTIVE_COLOR;
    }

    public Color getPaintBackColor(TGPanel tgPanel) {
        if (this == tgPanel.getSelect()) {
            return this.BACK_SELECT_COLOR;
        }
        if (this.fixed) {
            return this.BACK_FIXED_COLOR;
        }
        if (this.markedForRemoval) {
            return this.BACK_MRF_COLOR;
        }
        if (this.justMadeLocal) {
            return this.BACK_JML_COLOR;
        }
        return this.backColor;
    }

    public Color getPaintTextColor(TGPanel tgPanel) {
        return this.textColor;
    }

    public void paintNodeBody(Graphics g, TGPanel tgPanel) {
        g.setFont(this.font);
        this.fontMetrics = g.getFontMetrics();
        int ix = (int)this.drawx;
        int iy = (int)this.drawy;
        int h = this.getHeight();
        int w = this.getWidth();
        int r = h / 2 + 1;
        Color borderCol = this.getPaintBorderColor(tgPanel);
        g.setColor(borderCol);
        if (this.typ == 2) {
            g.fillRoundRect(ix - w / 2, iy - h / 2, w, h, r, r);
        } else if (this.typ == 3) {
            g.fillOval(ix - w / 2, iy - h / 2, w, h);
        } else if (this.typ == 4) {
            g.fillOval(ix - w / 2, iy - w / 2, w, w);
        } else {
            g.fillRect(ix - w / 2, iy - h / 2, w, h);
        }
        Color backCol = this.getPaintBackColor(tgPanel);
        g.setColor(backCol);
        if (this.typ == 2) {
            g.fillRoundRect(ix - w / 2 + 2, iy - h / 2 + 2, w - 4, h - 4, r, r);
        } else if (this.typ == 3) {
            g.fillOval(ix - w / 2 + 2, iy - h / 2 + 2, w - 4, h - 4);
        } else if (this.typ == 4) {
            g.fillOval(ix - w / 2 + 2, iy - w / 2 + 2, w - 4, w - 4);
        } else {
            g.fillRect(ix - w / 2 + 2, iy - h / 2 + 2, w - 4, h - 4);
        }
        Color textCol = this.getPaintTextColor(tgPanel);
        g.setColor(textCol);
        g.drawString(this.lbl, ix - this.fontMetrics.stringWidth(this.lbl) / 2, iy + this.fontMetrics.getDescent() + 1);
    }

    public void paintSmallTag(Graphics g, TGPanel tgPanel, int tagX, int tagY, Color backCol, Color textCol, char character) {
        g.setColor(backCol);
        g.fillRect(tagX, tagY, 8, 8);
        g.setColor(textCol);
        g.setFont(SMALL_TAG_FONT);
        g.drawString("" + character, tagX + 2, tagY + 7);
    }

    public String getURL() {
        return this.strUrl;
    }

    public void setURL(String strUrl) {
        this.strUrl = strUrl;
    }
}

