/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators.random;

import edu.uci.ics.jung.algorithms.generators.Lattice2DGenerator;
import edu.uci.ics.jung.algorithms.util.WeightedChoice;
import edu.uci.ics.jung.graph.Graph;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.collections15.Factory;

public class KleinbergSmallWorldGenerator<V, E>
extends Lattice2DGenerator<V, E> {
    private double clustering_exponent;
    private Random random;
    private int num_connections = 1;

    public KleinbergSmallWorldGenerator(Factory<? extends Graph<V, E>> graph_factory, Factory<V> vertex_factory, Factory<E> edge_factory, int latticeSize, double clusteringExponent) {
        this(graph_factory, vertex_factory, edge_factory, latticeSize, latticeSize, clusteringExponent);
    }

    public KleinbergSmallWorldGenerator(Factory<? extends Graph<V, E>> graph_factory, Factory<V> vertex_factory, Factory<E> edge_factory, int row_count, int col_count, double clusteringExponent) {
        super(graph_factory, vertex_factory, edge_factory, row_count, col_count, true);
        this.clustering_exponent = clusteringExponent;
        this.initialize();
    }

    public KleinbergSmallWorldGenerator(Factory<? extends Graph<V, E>> graph_factory, Factory<V> vertex_factory, Factory<E> edge_factory, int row_count, int col_count, double clusteringExponent, boolean isToroidal) {
        super(graph_factory, vertex_factory, edge_factory, row_count, col_count, isToroidal);
        this.clustering_exponent = clusteringExponent;
        this.initialize();
    }

    private void initialize() {
        this.random = new Random();
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public void setRandomSeed(long seed) {
        this.random.setSeed(seed);
    }

    public void setConnectionCount(int num_connections) {
        if (num_connections <= 0) {
            throw new IllegalArgumentException("Number of new connections per vertex must be >= 1");
        }
        this.num_connections = num_connections;
    }

    public int getConnectionCount() {
        return this.num_connections;
    }

    @Override
    public Graph<V, E> create() {
        Object graph = super.create();
        for (int i = 0; i < graph.getVertexCount(); ++i) {
            int j;
            Object source = this.getVertex(i);
            int row = this.getRow(i);
            int col = this.getCol(i);
            int row_offset = row < this.row_count / 2 ? -this.row_count : this.row_count;
            int col_offset = col < this.col_count / 2 ? -this.col_count : this.col_count;
            HashMap vertex_weights = new HashMap();
            for (j = 0; j < this.row_count; ++j) {
                for (int k = 0; k < this.col_count; ++k) {
                    int distance;
                    if (j == row && k == col) continue;
                    int v_dist = Math.abs(j - row);
                    int h_dist = Math.abs(k - col);
                    if (this.is_toroidal) {
                        v_dist = Math.min(v_dist, Math.abs(j - row + row_offset));
                        h_dist = Math.min(h_dist, Math.abs(k - col + col_offset));
                    }
                    if ((distance = v_dist + h_dist) < 2) continue;
                    vertex_weights.put(this.getVertex(j, k), Float.valueOf((float)Math.pow(distance, -this.clustering_exponent)));
                }
            }
            for (j = 0; j < this.num_connections; ++j) {
                WeightedChoice weighted_choice = new WeightedChoice(vertex_weights, this.random);
                Object target = weighted_choice.nextItem();
                graph.addEdge(this.edge_factory.create(), source, target);
            }
        }
        return graph;
    }
}

